/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.render.layer;

import forge.net.mca.client.model.CommonVillagerModel;
import forge.net.mca.client.render.layer.VillagerLayer;
import forge.net.mca.entity.ai.Genetics;
import forge.net.mca.entity.ai.Traits;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class FaceLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends VillagerLayer<T, M> {
    private static final int FACE_COUNT = 22;
    private final String variant;

    public FaceLayer(RenderLayerParent<T, M> renderer, M model, String variant) {
        super(renderer, model);
        this.variant = variant;
        model.m_8009_(false);
        ((HumanoidModel)model).f_102808_.f_104207_ = true;
    }

    @Override
    protected boolean isTranslucent() {
        return true;
    }

    @Override
    protected ResourceLocation getSkin(T villager) {
        int index = (int)Math.min(21.0f, Math.max(0.0f, CommonVillagerModel.getVillager(villager).getGenetics().getGene(Genetics.FACE) * 22.0f));
        int time = ((LivingEntity)villager).f_19797_ / 2 + (int)(CommonVillagerModel.getVillager(villager).getGenetics().getGene(Genetics.HEMOGLOBIN) * 65536.0f);
        boolean blink = time % 50 == 1 || time % 57 == 1 || villager.m_5803_() || villager.m_21224_();
        boolean hasHeterochromia = this.variant.equals("normal") && CommonVillagerModel.getVillager(villager).getTraits().hasTrait(Traits.Trait.HETEROCHROMIA);
        return this.cached(String.format("mca:skins/face/%s/%s/%d%s.png", this.variant, CommonVillagerModel.getVillager(villager).getGenetics().getGender().getStrName(), index, blink ? "_blink" : (hasHeterochromia ? "_hetero" : "")), ResourceLocation::new);
    }
}

