/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import forge.net.mca.MCA;
import forge.net.mca.client.gui.ExtendedScreen;
import forge.net.mca.client.gui.FamilyTreeScreen;
import forge.net.mca.client.gui.widget.RectangleWidget;
import forge.net.mca.client.gui.widget.TooltipButtonWidget;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.network.c2s.GetVillageRequest;
import forge.net.mca.network.c2s.RenameVillageMessage;
import forge.net.mca.network.c2s.ReportBuildingMessage;
import forge.net.mca.network.c2s.SaveVillageMessage;
import forge.net.mca.resources.Rank;
import forge.net.mca.resources.data.BuildingType;
import forge.net.mca.resources.data.tasks.Task;
import forge.net.mca.server.world.data.Building;
import forge.net.mca.server.world.data.Village;
import forge.net.mca.util.localization.FlowingText;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class BlueprintScreen
extends ExtendedScreen {
    private final int positionTaxes = -60;
    private final int positionBirth = -10;
    private final int positionMarriage = 40;
    private Village village;
    private int reputation;
    private boolean isVillage;
    private Rank rank;
    private Set<String> completedTasks;
    private String page;
    private Button[] buttonTaxes;
    private Button[] buttonBirths;
    private Button[] buttonMarriage;
    private Button buttonPage;
    private int pageNumber = 0;
    private final List<Button> catalogButtons = new LinkedList<Button>();
    private static final ResourceLocation ICON_TEXTURES = MCA.locate("textures/buildings.png");
    private BuildingType selectedBuilding;
    private UUID selectedVillager;
    private int mouseX;
    private int mouseY;
    private Map<Rank, List<Task>> tasks;
    private Map<String, BuildingType> buildingTypes;

    private BuildingType getBuildingType(String type) {
        return this.buildingTypes.containsKey(type) ? this.buildingTypes.get(type) : new BuildingType();
    }

    public BlueprintScreen() {
        super((Component)Component.m_237113_((String)"Blueprint"));
    }

    private void saveVillage() {
        NetworkHandler.sendToServer(new SaveVillageMessage(this.village));
    }

    private void changeTaxes(int d) {
        this.village.setTaxes(Math.max(0, Math.min(100, this.village.getTaxes() + d)));
        this.saveVillage();
    }

    private void changePopulationThreshold(int d) {
        this.village.setPopulationThreshold(Math.max(0, Math.min(100, this.village.getPopulationThreshold() + d)));
        this.saveVillage();
    }

    private void changeMarriageThreshold(int d) {
        this.village.setMarriageThreshold(Math.max(0, Math.min(100, this.village.getMarriageThreshold() + d)));
        this.saveVillage();
    }

    private Button[] createValueChanger(int x, int y, int w, int h, Consumer<Boolean> onPress, Component tooltip) {
        Button[] buttons = new Button[3];
        buttons[1] = (Button)this.m_142416_((GuiEventListener)new Button(x - w / 2, y, w / 4, h, (Component)Component.m_237113_((String)"<<"), b -> onPress.accept(false)));
        buttons[2] = (Button)this.m_142416_((GuiEventListener)new Button(x + w / 4, y, w / 4, h, (Component)Component.m_237113_((String)">>"), b -> onPress.accept(true)));
        buttons[0] = (Button)this.m_142416_((GuiEventListener)new Button(x - w / 4, y, w / 2, h, (Component)Component.m_237113_((String)""), b -> {}, (buttonWidget, matrixStack, mx, my) -> this.m_96597_(matrixStack, FlowingText.wrap(tooltip, 160), mx, my)));
        return buttons;
    }

    protected void drawBuildingIcon(PoseStack transform, int x, int y, int u, int v) {
        transform.m_85836_();
        transform.m_85837_((double)x - 6.6, (double)y - 6.6, 0.0);
        transform.m_85841_(0.66f, 0.66f, 0.66f);
        this.m_93228_(transform, 0, 0, u, v, 20, 20);
        transform.m_85849_();
    }

    public void m_7856_() {
        NetworkHandler.sendToServer(new GetVillageRequest());
        this.setPage("waiting");
    }

    private void setPage(String page) {
        if (page.equals("close")) {
            assert (this.f_96541_ != null);
            this.f_96541_.m_91152_(null);
            return;
        }
        this.page = page;
        this.m_169413_();
        this.m_142416_((GuiEventListener)new Button(5, 5, 20, 20, (Component)Component.m_237115_((String)"gui.button.backarrow"), b -> this.setPage("close")));
        int bx = this.f_96543_ / 2 - 180;
        int by = this.f_96544_ / 2 - 56;
        if (!(page.equals("rename") || page.equals("empty") || page.equals("waiting"))) {
            for (String p : new String[]{"map", "rank", "catalog", "villagers", "rules", "refresh"}) {
                Button widget = new Button(bx, by, 80, 20, (Component)Component.m_237115_((String)("gui.blueprint." + p)), b -> this.setPage(p));
                this.m_142416_((GuiEventListener)widget);
                if (page.equals(p)) {
                    widget.f_93623_ = false;
                }
                by += 22;
            }
            by += 22;
        }
        switch (page) {
            case "empty": {
                bx = this.f_96543_ / 2 - 48;
                by = this.f_96544_ / 2;
                this.m_142416_((GuiEventListener)new Button(bx, by + 5, 96, 20, (Component)Component.m_237115_((String)"gui.blueprint.addBuilding"), b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.ADD));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                    this.m_7379_();
                }));
                break;
            }
            case "refresh": {
                NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.FULL_SCAN));
                NetworkHandler.sendToServer(new GetVillageRequest());
                assert (this.f_96541_ != null);
                assert (this.f_96541_.f_91074_ != null);
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237115_((String)"blueprint.refreshed"), true);
                this.setPage("map");
                break;
            }
            case "advanced": {
                bx = this.f_96543_ / 2 + 180 - 64 - 16;
                by = this.f_96544_ / 2 - 56;
                MutableComponent text = Component.m_237115_((String)"gui.blueprint.autoScan");
                if (this.village.isAutoScan()) {
                    text.m_130940_(ChatFormatting.GREEN);
                } else {
                    text.m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.STRIKETHROUGH);
                }
                this.m_142416_((GuiEventListener)new TooltipButtonWidget(bx, by, 96, 20, text, arg_0 -> this.lambda$setPage$7((String)page, arg_0)));
                this.m_142416_((GuiEventListener)new TooltipButtonWidget(bx, by += 22, 96, 20, Component.m_237115_((String)"gui.blueprint.restrictAccess"), b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.FORCE_TYPE, "blocked"));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                }));
                this.m_142416_((GuiEventListener)new TooltipButtonWidget(bx, by += 22, 96, 20, "gui.blueprint.addRoom", b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.ADD_ROOM));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                }));
                by += 66;
                if (this.isVillage) {
                    this.m_142416_((GuiEventListener)new Button(bx, by, 96, 20, (Component)Component.m_237115_((String)"gui.blueprint.renameVillage"), b -> this.setPage("rename")));
                }
                by += 22;
            }
            case "map": {
                bx = this.f_96543_ / 2 + 180 - 64 - 16;
                by = this.f_96544_ / 2 - 56 + 66;
                this.m_142416_((GuiEventListener)new Button(bx, by, 96, 20, (Component)Component.m_237115_((String)"gui.blueprint.addBuilding"), b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.ADD));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                }));
                this.m_142416_((GuiEventListener)new Button(bx, by += 22, 96, 20, (Component)Component.m_237115_((String)"gui.blueprint.removeBuilding"), b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.REMOVE));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                }));
                by += 22;
                if (page.equals("advanced")) break;
                this.m_142416_((GuiEventListener)new Button(bx, by, 96, 20, (Component)Component.m_237115_((String)"gui.blueprint.advanced"), b -> this.setPage("advanced")));
                break;
            }
            case "rank": {
                break;
            }
            case "catalog": {
                int row = 0;
                int col = 0;
                int size = 21;
                int x = this.f_96543_ / 2 - 4 * size - 8;
                int y = (int)((double)(this.f_96544_ / 2) - 2.0 * (double)size);
                this.catalogButtons.clear();
                for (BuildingType bt : this.buildingTypes.values()) {
                    if (!bt.visible()) continue;
                    ImageButton widget = new ImageButton(row * size + x + 10, col * size + y - 10, 20, 20, bt.iconU(), bt.iconV() + 20, 20, ICON_TEXTURES, 256, 256, button -> {
                        this.selectBuilding(bt);
                        button.f_93623_ = false;
                        this.catalogButtons.forEach(b -> {
                            b.f_93623_ = true;
                        });
                    }, (Component)Component.m_237115_((String)("buildingType." + bt.name())));
                    this.catalogButtons.add((Button)this.m_142416_((GuiEventListener)widget));
                    if (++row <= 4) continue;
                    row = 0;
                    ++col;
                }
                break;
            }
            case "villagers": {
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 24 - 20, this.f_96544_ / 2 + 54, 20, 20, (Component)Component.m_237113_((String)"<"), b -> {
                    if (this.pageNumber > 0) {
                        --this.pageNumber;
                    }
                }));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 24, this.f_96544_ / 2 + 54, 20, 20, (Component)Component.m_237113_((String)">"), b -> {
                    if ((double)this.pageNumber < Math.ceil((double)this.village.getPopulation() / 9.0) - 1.0) {
                        ++this.pageNumber;
                    }
                }));
                this.buttonPage = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 24, this.f_96544_ / 2 + 54, 48, 20, (Component)Component.m_237113_((String)"0/0)"), b -> {}));
                break;
            }
            case "rules": {
                this.buttonTaxes = this.createValueChanger(this.f_96543_ / 2, this.f_96544_ / 2 + -60 + 10, 80, 20, b -> this.changeTaxes(b != false ? 10 : -10), (Component)Component.m_237115_((String)"gui.blueprint.tooltip.taxes"));
                this.toggleButtons(this.buttonTaxes, false);
                this.buttonBirths = this.createValueChanger(this.f_96543_ / 2, this.f_96544_ / 2 + -10 + 10, 80, 20, b -> this.changePopulationThreshold(b != false ? 10 : -10), (Component)Component.m_237115_((String)"gui.blueprint.tooltip.births"));
                this.toggleButtons(this.buttonBirths, false);
                this.buttonMarriage = this.createValueChanger(this.f_96543_ / 2, this.f_96544_ / 2 + 40 + 10, 80, 20, b -> this.changeMarriageThreshold(b != false ? 10 : -10), (Component)Component.m_237115_((String)"gui.blueprint.tooltip.marriage"));
                this.toggleButtons(this.buttonMarriage, false);
                break;
            }
            case "rename": {
                EditBox field = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2 - 65, this.f_96544_ / 2 - 16, 130, 20, (Component)Component.m_237115_((String)"gui.blueprint.renameVillage")));
                field.m_94199_(32);
                field.m_94144_(this.village.getName());
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 66, this.f_96544_ / 2 + 8, 64, 20, (Component)Component.m_237115_((String)"gui.blueprint.cancel"), b -> this.setPage("map")));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 2, this.f_96544_ / 2 + 8, 64, 20, (Component)Component.m_237115_((String)"gui.blueprint.rename"), b -> {
                    NetworkHandler.sendToServer(new RenameVillageMessage(this.village.getId(), field.m_94155_()));
                    this.village.setName(field.m_94155_());
                    this.setPage("map");
                }));
            }
        }
    }

    private void selectBuilding(BuildingType b) {
        this.selectedBuilding = b;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_6305_(PoseStack transform, int sizeX, int sizeY, float offset) {
        this.m_7333_(transform);
        assert (this.f_96541_ != null);
        this.mouseX = (int)(this.f_96541_.f_91067_.m_91589_() * (double)this.f_96543_ / (double)this.f_96541_.m_91268_().m_85441_());
        this.mouseY = (int)(this.f_96541_.f_91067_.m_91594_() * (double)this.f_96544_ / (double)this.f_96541_.m_91268_().m_85442_());
        switch (this.page) {
            case "waiting": {
                BlueprintScreen.m_93215_((PoseStack)transform, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.waiting"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)-5592406);
                break;
            }
            case "empty": {
                BlueprintScreen.m_93215_((PoseStack)transform, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.empty"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 20), (int)-5592406);
                break;
            }
            case "map": {
                this.renderStats(transform);
            }
            case "advanced": {
                this.renderName(transform);
                this.renderMap(transform);
                break;
            }
            case "rank": {
                this.renderTasks(transform);
                this.renderStats(transform);
                break;
            }
            case "catalog": {
                this.renderCatalog(transform);
                break;
            }
            case "villagers": {
                this.renderVillagers(transform);
                break;
            }
            case "rules": {
                this.renderRules(transform);
            }
        }
        super.m_6305_(transform, sizeX, sizeY, offset);
    }

    private void renderName(PoseStack transform) {
        transform.m_85836_();
        transform.m_85841_(2.0f, 2.0f, 2.0f);
        if (this.isVillage) {
            BlueprintScreen.m_93208_((PoseStack)transform, (Font)this.f_96547_, (String)this.village.getName(), (int)(this.f_96543_ / 4), (int)(this.f_96544_ / 4 - 48), (int)-1);
        } else {
            BlueprintScreen.m_93215_((PoseStack)transform, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.settlement"), (int)(this.f_96543_ / 4), (int)(this.f_96544_ / 4 - 48), (int)-1);
        }
        transform.m_85849_();
    }

    private void renderStats(PoseStack transform) {
        int x = this.f_96543_ / 2 + (this.page.equals("rank") ? -70 : 105);
        int y = this.f_96544_ / 2 - 50;
        MutableComponent rankStr = Component.m_237115_((String)this.rank.getTranslationKey());
        int rankColor = this.rank.ordinal() == 0 ? -65536 : -256;
        this.f_96547_.m_92763_(transform, (Component)Component.m_237110_((String)"gui.blueprint.currentRank", (Object[])new Object[]{rankStr}), (float)x, (float)y, rankColor);
        this.f_96547_.m_92763_(transform, (Component)Component.m_237110_((String)"gui.blueprint.reputation", (Object[])new Object[]{String.valueOf(this.reputation)}), (float)x, (float)(y + 11), this.rank.ordinal() == 0 ? -65536 : -1);
        this.f_96547_.m_92763_(transform, (Component)Component.m_237110_((String)"gui.blueprint.buildings", (Object[])new Object[]{this.village.getBuildings().size()}), (float)x, (float)(y + 22), -1);
        this.f_96547_.m_92763_(transform, (Component)Component.m_237110_((String)"gui.blueprint.population", (Object[])new Object[]{this.village.getPopulation(), this.village.getMaxPopulation()}), (float)x, (float)(y + 33), -1);
    }

    /*
     * WARNING - void declaration
     */
    private void renderMap(PoseStack transform) {
        void var10_13;
        int mapSize = 75;
        int y = this.f_96544_ / 2 + 8;
        RectangleWidget.drawRectangle(transform, this.f_96543_ / 2 - mapSize, y - mapSize, this.f_96543_ / 2 + mapSize, y + mapSize, -120);
        transform.m_85836_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICON_TEXTURES);
        float sc = Math.min((float)mapSize / (float)(this.village.getBox().getMaxBlockCount() + 3) * 2.0f, 2.0f);
        int mouseLocalX = (int)(((double)this.mouseX - (double)this.f_96543_ / 2.0) / (double)sc + (double)this.village.getCenter().m_123341_());
        int mouseLocalY = (int)((float)(this.mouseY - y) / sc + (float)this.village.getCenter().m_123343_());
        transform.m_85837_((double)this.f_96543_ / 2.0, (double)y, 0.0);
        transform.m_85841_(sc, sc, 0.0f);
        transform.m_85837_((double)(-this.village.getCenter().m_123341_()), (double)(-this.village.getCenter().m_123343_()), 0.0);
        assert (this.f_96541_ != null);
        LocalPlayer player = this.f_96541_.f_91074_;
        if (player != null) {
            RectangleWidget.drawRectangle(transform, (int)player.m_20185_() - 1, (int)player.m_20189_() - 1, (int)player.m_20185_() + 1, (int)player.m_20189_() + 1, -65281);
        }
        LinkedList<Building> hoverBuildings = new LinkedList<Building>();
        for (Building building : this.village.getBuildings().values()) {
            BuildingType bt = this.getBuildingType(building.getType());
            if (bt.isIcon()) {
                BlockPos blockPos = building.getCenter();
                this.drawBuildingIcon(transform, blockPos.m_123341_(), blockPos.m_123343_(), bt.iconU(), bt.iconV());
                int n = 6;
                Vec3i vec3i = new Vec3i(mouseLocalX, blockPos.m_123342_(), mouseLocalY);
                if (!(blockPos.m_123331_(vec3i) < (double)(n * n))) continue;
                hoverBuildings.add(building);
                continue;
            }
            BlockPos blockPos = building.getPos0();
            BlockPos blockPos2 = building.getPos1();
            RectangleWidget.drawRectangle(transform, blockPos.m_123341_(), blockPos.m_123343_(), blockPos2.m_123341_(), blockPos2.m_123343_(), bt.getColor());
            if (bt.visible()) {
                BlockPos c = building.getCenter();
                this.drawBuildingIcon(transform, c.m_123341_(), c.m_123343_(), bt.iconU(), bt.iconV());
            }
            int margin = 1;
            if (mouseLocalX < blockPos.m_123341_() - margin || mouseLocalX > blockPos2.m_123341_() + margin || mouseLocalY < blockPos.m_123343_() - margin || mouseLocalY > blockPos2.m_123343_() + margin) continue;
            hoverBuildings.add(building);
        }
        transform.m_85849_();
        hoverBuildings.sort((a, b) -> b.getCenter().m_123342_() - a.getCenter().m_123342_());
        LinkedList<List<Component>> tooltips = new LinkedList<List<Component>>();
        for (Object b2 : hoverBuildings) {
            tooltips.add(this.getBuildingTooltip((Building)b2));
        }
        boolean bl = false;
        for (List list : tooltips) {
            var10_13 += this.getTooltipHeight(list) + 9;
        }
        int py = this.mouseY - var10_13 / 2 + 12;
        for (List list : tooltips) {
            this.m_96597_(transform, list, this.mouseX, py);
            py += this.getTooltipHeight(list) + 9;
        }
    }

    private List<Component> getBuildingTooltip(Building hoverBuilding) {
        LinkedList<Component> lines = new LinkedList<Component>();
        BuildingType bt = this.getBuildingType(hoverBuilding.getType());
        lines.add((Component)Component.m_237115_((String)("buildingType." + bt.name())));
        if (!bt.grouped()) {
            lines.add((Component)Component.m_237110_((String)"gui.blueprint.size", (Object[])new Object[]{String.valueOf(hoverBuilding.getSize())}));
        }
        for (String string : hoverBuilding.getResidents().values()) {
            lines.add((Component)Component.m_237113_((String)string));
        }
        for (Map.Entry entry : hoverBuilding.getBlocks().entrySet()) {
            lines.add((Component)Component.m_237113_((String)(((List)entry.getValue()).size() + " x ")).m_7220_(this.getBlockName((ResourceLocation)entry.getKey())).m_130940_(ChatFormatting.GRAY));
        }
        return lines;
    }

    private void renderTasks(PoseStack transform) {
        if (this.rank == null) {
            return;
        }
        int y = this.f_96544_ / 2 + 5;
        int x = this.f_96543_ / 2 - 70;
        for (Task task : this.tasks.get((Object)this.rank.promote())) {
            boolean completed = this.completedTasks.contains(task.getId());
            MutableComponent t = task.getTranslatable().m_130940_(completed ? ChatFormatting.STRIKETHROUGH : ChatFormatting.RESET);
            this.f_96547_.m_92763_(transform, (Component)t, (float)x, (float)y, completed ? -7798904 : -43691);
            y += 11;
        }
    }

    private void renderCatalog(PoseStack transform) {
        transform.m_85836_();
        transform.m_85841_(2.0f, 2.0f, 2.0f);
        BlueprintScreen.m_93215_((PoseStack)transform, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.catalogFull"), (int)(this.f_96543_ / 4), (int)(this.f_96544_ / 4 - 52), (int)-1);
        transform.m_85849_();
        BlueprintScreen.m_93215_((PoseStack)transform, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.catalogHint").m_130940_(ChatFormatting.GRAY), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 82), (int)-1);
        int x = this.f_96543_ / 2 + 35;
        int y = this.f_96544_ / 2 - 50;
        if (this.selectedBuilding != null) {
            this.f_96547_.m_92763_(transform, (Component)Component.m_237115_((String)("buildingType." + this.selectedBuilding.name())), (float)x, (float)y, this.selectedBuilding.getColor());
            List<Component> wrap = FlowingText.wrap((Component)Component.m_237115_((String)("buildingType." + this.selectedBuilding.name() + ".description")).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC), 150);
            for (Component component : wrap) {
                this.f_96547_.m_92763_(transform, component, (float)x, (float)(y + 12), -1);
                y += 10;
            }
            MutableComponent size = this.selectedBuilding.size() == 0 ? Component.m_237115_((String)"gui.blueprint.anySize") : Component.m_237110_((String)"gui.blueprint.size", (Object[])new Object[]{String.valueOf(this.selectedBuilding.size())});
            this.f_96547_.m_92763_(transform, (Component)size, (float)x, (float)(y + 20), -2236963);
            for (Map.Entry<ResourceLocation, Integer> entry : this.selectedBuilding.getGroups().entrySet()) {
                this.f_96547_.m_92763_(transform, (Component)Component.m_237113_((String)(entry.getValue() + " x ")).m_7220_(this.getBlockName(entry.getKey())), (float)x, (float)(y + 32), -1);
                y += 10;
            }
        } else {
            List<Component> wrap = FlowingText.wrap((Component)Component.m_237115_((String)"gui.blueprint.buildingTypes").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC), 150);
            for (Component component : wrap) {
                this.f_96547_.m_92763_(transform, component, (float)x, (float)y, -1);
                y += 10;
            }
        }
    }

    private void renderVillagers(PoseStack transform) {
        int index;
        int maxPages = (int)Math.ceil((double)this.village.getPopulation() / 9.0);
        this.buttonPage.m_93666_((Component)Component.m_237113_((String)(this.pageNumber + 1 + "/" + maxPages)));
        List villager = this.village.getBuildings().values().stream().flatMap(b -> b.getResidents().entrySet().stream()).sorted(Map.Entry.comparingByValue()).toList();
        this.selectedVillager = null;
        for (int i = 0; i < 9 && (index = i + this.pageNumber * 9) < villager.size(); ++i) {
            int y = this.f_96544_ / 2 - 51 + i * 11;
            boolean hover = this.isMouseWithin(this.f_96543_ / 2 - 50, y - 1, 100, 11);
            BlueprintScreen.m_93215_((PoseStack)transform, (Font)this.f_96547_, (Component)Component.m_237113_((String)((String)villager.get(index).getValue())), (int)(this.f_96543_ / 2), (int)y, (int)(hover ? -2631804 : -1));
            if (!hover) continue;
            this.selectedVillager = (UUID)villager.get(index).getKey();
        }
    }

    private void renderRules(PoseStack transform) {
        this.buttonTaxes[0].m_93666_((Component)Component.m_237113_((String)(this.village.getTaxes() + "%")));
        this.buttonMarriage[0].m_93666_((Component)Component.m_237113_((String)(this.village.getMarriageThreshold() + "%")));
        this.buttonBirths[0].m_93666_((Component)Component.m_237113_((String)(this.village.getPopulationThreshold() + "%")));
        BlueprintScreen.m_93215_((PoseStack)transform, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.taxes"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + -60), (int)-1);
        if (!this.rank.isAtLeast(Rank.MERCHANT)) {
            BlueprintScreen.m_93215_((PoseStack)transform, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.rankTooLow"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + -60 + 15), (int)-1);
            this.toggleButtons(this.buttonTaxes, false);
        } else {
            this.toggleButtons(this.buttonTaxes, true);
        }
        BlueprintScreen.m_93215_((PoseStack)transform, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.birth"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + -10), (int)-1);
        if (!this.rank.isAtLeast(Rank.NOBLE)) {
            BlueprintScreen.m_93215_((PoseStack)transform, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.rankTooLow"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + -10 + 15), (int)-1);
            this.toggleButtons(this.buttonBirths, false);
        } else {
            this.toggleButtons(this.buttonBirths, true);
        }
        BlueprintScreen.m_93215_((PoseStack)transform, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.marriage"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + 40), (int)-1);
        if (!this.rank.isAtLeast(Rank.MAYOR)) {
            BlueprintScreen.m_93215_((PoseStack)transform, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.rankTooLow"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + 40 + 15), (int)-1);
            this.toggleButtons(this.buttonMarriage, false);
        } else {
            this.toggleButtons(this.buttonMarriage, true);
        }
    }

    private Component getBlockName(ResourceLocation id) {
        if (Registry.f_122824_.m_7804_(id)) {
            return Component.m_237115_((String)((Block)Registry.f_122824_.m_7745_(id)).m_7705_());
        }
        return Component.m_237115_((String)("tag." + id.toString()));
    }

    private void toggleButtons(Button[] buttons, boolean active) {
        for (Button b : buttons) {
            b.f_93623_ = active;
            b.f_93624_ = active;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.page.equals("villagers") && this.selectedVillager != null) {
            assert (this.f_96541_ != null);
            this.f_96541_.m_91152_((Screen)new FamilyTreeScreen(this.selectedVillager));
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected boolean isMouseWithin(int x, int y, int w, int h) {
        return this.mouseX >= x && this.mouseX < x + w && this.mouseY >= y && this.mouseY < y + h;
    }

    public void setVillage(Village village) {
        this.village = village;
        if (village == null) {
            this.setPage("empty");
        } else if (this.page.equals("waiting")) {
            this.setPage("map");
        }
    }

    public void setRank(Rank rank, int reputation, boolean isVillage, Set<String> completedTasks, Map<Rank, List<Task>> tasks, Map<String, BuildingType> buildingTypes) {
        this.rank = rank;
        this.reputation = reputation;
        this.isVillage = isVillage;
        this.completedTasks = completedTasks;
        this.tasks = tasks;
        this.buildingTypes = buildingTypes;
    }

    private /* synthetic */ void lambda$setPage$7(String page, Button b) {
        NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.AUTO_SCAN));
        NetworkHandler.sendToServer(new GetVillageRequest());
        this.village.toggleAutoScan();
        this.setPage(page);
    }
}

