/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.block;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import forge.net.mca.TagsMCA;
import forge.net.mca.block.BlockEntityTypesMCA;
import forge.net.mca.block.InfernalFlameBlock;
import forge.net.mca.block.JewelerWorkbench;
import forge.net.mca.block.TombstoneBlock;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.Vec3;

public interface BlocksMCA {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"mca", (ResourceKey)Registry.f_122901_);
    public static final RegistrySupplier<Block> ROSE_GOLD_BLOCK = BlocksMCA.register("rose_gold_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50074_)));
    public static final RegistrySupplier<Block> JEWELER_WORKBENCH = BlocksMCA.register("jeweler_workbench", () -> new JewelerWorkbench(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_).m_60955_()));
    public static final RegistrySupplier<Block> INFERNAL_FLAME = BlocksMCA.register("infernal_flame", () -> new InfernalFlameBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50084_)));
    public static final RegistrySupplier<Block> GRAVELLING_HEADSTONE = BlocksMCA.register("gravelling_headstone", () -> new TombstoneBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_(), 100, 50, new Vec3(0.0, -25.0, 40.0), -90.0f, true, TombstoneBlock.GRAVELLING_SHAPE));
    public static final RegistrySupplier<Block> UPRIGHT_HEADSTONE = BlocksMCA.register("upright_headstone", () -> new TombstoneBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_(), 90, 50, new Vec3(0.0, -55.0, 23.0), 0.0f, true, TombstoneBlock.UPRIGHT_SHAPE));
    public static final RegistrySupplier<Block> SLANTED_HEADSTONE = BlocksMCA.register("slanted_headstone", () -> new TombstoneBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_(), 100, 15, new Vec3(0.0, -25.0, 10.0), -45.0f, true, TombstoneBlock.SLANTED_SHAPE));
    public static final RegistrySupplier<Block> CROSS_HEADSTONE = BlocksMCA.register("cross_headstone", () -> new TombstoneBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_(), 80, 15, new Vec3(0.0, -13.0, 15.0), -45.0f, true, TombstoneBlock.CROSS_SHAPE));
    public static final RegistrySupplier<Block> WALL_HEADSTONE = BlocksMCA.register("wall_headstone", () -> new TombstoneBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_(), 100, 15, new Vec3(0.0, -25.0, 40.0), 0.0f, false, TombstoneBlock.WALL_SHAPE));

    public static void bootstrap() {
        BLOCKS.register();
        TagsMCA.Blocks.bootstrap();
        BlockEntityTypesMCA.bootstrap();
    }

    public static <T extends Block> RegistrySupplier<T> register(String name, Supplier<T> block) {
        ResourceLocation id = new ResourceLocation("mca", name);
        return BLOCKS.register(id, block);
    }
}

