/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.server.world.data;

import fabric.net.mca.Config;
import fabric.net.mca.MCA;
import fabric.net.mca.advancement.criterion.CriterionMCA;
import fabric.net.mca.resources.API;
import fabric.net.mca.resources.data.BuildingType;
import fabric.net.mca.server.ReaperSpawner;
import fabric.net.mca.server.SpawnQueue;
import fabric.net.mca.server.world.data.BabyBunker;
import fabric.net.mca.server.world.data.Building;
import fabric.net.mca.server.world.data.PlayerSaveData;
import fabric.net.mca.server.world.data.Village;
import fabric.net.mca.util.NbtHelper;
import fabric.net.mca.util.WorldUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1317;
import net.minecraft.class_1543;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4538;

public class VillageManager
extends class_18
implements Iterable<Village> {
    private final Map<Integer, Village> villages = new HashMap<Integer, Village>();
    public final Set<class_2338> cache = ConcurrentHashMap.newKeySet();
    public final Map<Integer, Integer> buildingToVillages = new HashMap<Integer, Integer>();
    private final List<class_2338> buildingQueue = new LinkedList<class_2338>();
    private int lastBuildingId;
    private int lastVillageId;
    private final class_3218 world;
    private final ReaperSpawner reapers;
    private final BabyBunker babies;
    private int buildingCooldown = 21;

    public static VillageManager get(class_3218 world) {
        return WorldUtils.loadData(world, nbt -> new VillageManager(world, (class_2487)nbt), VillageManager::new, "mca_villages");
    }

    VillageManager(class_3218 world) {
        this.world = world;
        this.reapers = new ReaperSpawner(this);
        this.babies = new BabyBunker(this);
    }

    VillageManager(class_3218 world, class_2487 nbt) {
        this.world = world;
        this.lastBuildingId = nbt.method_10550("lastBuildingId");
        this.lastVillageId = nbt.method_10550("lastVillageId");
        this.reapers = nbt.method_10573("reapers", 10) ? new ReaperSpawner(this, nbt.method_10562("reapers")) : new ReaperSpawner(this);
        this.babies = nbt.method_10573("babies", 10) ? new BabyBunker(this, nbt.method_10562("babies")) : new BabyBunker(this);
        class_2499 villageList = nbt.method_10554("villages", 10);
        for (int i = 0; i < villageList.size(); ++i) {
            Village village = new Village();
            village.load(villageList.method_10602(i));
            if (village.getBuildings().isEmpty()) {
                MCA.LOGGER.warn("Empty village detected (" + village.getName() + "), removing...");
                this.method_80();
                continue;
            }
            this.villages.put(village.getId(), village);
        }
        for (Village v : this.villages.values()) {
            for (Building b : v.getBuildings().values()) {
                this.buildingToVillages.put(b.getId(), v.getId());
            }
        }
    }

    public ReaperSpawner getReaperSpawner() {
        return this.reapers;
    }

    public BabyBunker getBabies() {
        return this.babies;
    }

    public Optional<Village> getOrEmpty(int id) {
        return Optional.ofNullable(this.villages.get(id));
    }

    public boolean removeVillage(int id) {
        if (this.villages.remove(id) != null) {
            this.cache.clear();
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Village> iterator() {
        return this.villages.values().iterator();
    }

    public Stream<Village> findVillages(Predicate<Village> predicate) {
        return this.villages.values().stream().filter(predicate);
    }

    public Optional<Village> findNearestVillage(class_1297 entity) {
        class_2338 p = entity.method_24515();
        return this.findVillages(v -> v.isWithinBorder(entity)).min((a, b) -> (int)(a.getCenter().method_10262((class_2382)p) - b.getCenter().method_10262((class_2382)p)));
    }

    public Optional<Village> findNearestVillage(class_2338 p, int margin) {
        return this.findVillages(v -> v.isWithinBorder(p, margin)).min((a, b) -> (int)(a.getCenter().method_10262((class_2382)p) - b.getCenter().method_10262((class_2382)p)));
    }

    public boolean isWithinHorizontalBoundaries(class_2338 p) {
        return this.villages.values().stream().anyMatch(v -> v.getBox().expand(0, 1000, 0).method_14662((class_2382)p));
    }

    public class_2487 method_75(class_2487 nbt) {
        nbt.method_10569("lastBuildingId", this.lastBuildingId);
        nbt.method_10569("lastVillageId", this.lastVillageId);
        nbt.method_10566("villages", (class_2520)NbtHelper.fromList(this.villages.values(), Village::save));
        nbt.method_10566("reapers", (class_2520)this.reapers.writeNbt());
        return nbt;
    }

    public void tick() {
        if (this.world.method_8532() % 100L == 0L) {
            this.world.method_18456().forEach(player -> PlayerSaveData.get(player).updateLastSeenVillage(this, (class_3222)player));
        }
        if (this.world.method_8532() % (long)(Config.getInstance().bountyHunterInterval / 10) == 0L && this.world.method_8407() != class_1267.field_5801) {
            this.world.method_18456().forEach(player -> {
                if (this.world.field_9229.method_43048(10) == 0 && !this.isWithinHorizontalBoundaries(player.method_24515()) && !player.method_7337()) {
                    this.villages.values().stream().filter(v -> v.getPopulation() >= 3).filter(v -> v.getReputation((class_1657)player) < Config.getInstance().bountyHunterHeartsInterval).min(Comparator.comparingInt(v -> v.getReputation((class_1657)player))).ifPresent(buildings -> this.startBountyHunterWave((class_3222)player, (Village)buildings));
                }
            });
        }
        long time = this.world.method_8510();
        for (Village v : this) {
            v.tick(this.world, time);
        }
        if (time % (long)this.buildingCooldown == 0L && !this.buildingQueue.isEmpty()) {
            this.processBuilding(this.buildingQueue.remove(0));
        }
        this.reapers.tick(this.world);
        SpawnQueue.getInstance().tick();
    }

    private void startBountyHunterWave(class_3222 player, Village sender) {
        int count = Math.min(30, -sender.getReputation((class_1657)player) / 100 + 2);
        if (sender.getPopulation() == 0) {
            sender.cleanReputation();
            sender.resetHearts((class_1657)player);
            count *= 2;
        } else {
            sender.pushHearts((class_1657)player, count * 50);
        }
        CriterionMCA.GENERIC_EVENT_CRITERION.trigger(player, "bounty_hunter");
        for (int c = 0; c < count; ++c) {
            if (this.world.field_9229.method_43056()) {
                this.spawnBountyHunter(class_1299.field_6105, player);
                continue;
            }
            this.spawnBountyHunter(class_1299.field_6117, player);
        }
        player.method_7353((class_2561)class_2561.method_43469((String)(sender.getPopulation() == 0 ? "events.bountyHuntersFinal" : "events.bountyHunters"), (Object[])new Object[]{sender.getName()}).method_27692(class_124.field_1061), false);
    }

    private <T extends class_1543> void spawnBountyHunter(class_1299<T> t, class_3222 player) {
        class_1543 pillager = (class_1543)t.method_5883((class_1937)this.world);
        if (pillager != null) {
            for (int attempt = 0; attempt < 32; ++attempt) {
                int z;
                int y;
                float f = this.world.field_9229.method_43057() * ((float)Math.PI * 2);
                int x = (int)(player.method_23317() + (double)(class_3532.method_15362((float)f) * 32.0f));
                class_2338 pos = new class_2338(x, y = this.world.method_8624(class_2902.class_2903.field_13202, x, z = (int)(player.method_23321() + (double)(class_3532.method_15374((float)f) * 32.0f))), z);
                if (!class_1948.method_8660((class_1317.class_1319)class_1317.class_1319.field_6317, (class_4538)this.world, (class_2338)pos, t)) continue;
                pillager.method_5814((double)x, (double)y, (double)z);
                pillager.method_5980((class_1309)player);
                WorldUtils.spawnEntity((class_1937)this.world, (class_1308)pillager, class_3730.field_16467);
                break;
            }
        }
    }

    public void reportBuilding(class_2338 pos) {
        this.cache.add(pos);
        this.buildingQueue.add(pos);
    }

    public Building.validationResult processBuilding(class_2338 pos) {
        return this.processBuilding(pos, false, false);
    }

    private BuildingType getGroupedBuildingType(class_2338 pos) {
        class_2248 block = this.world.method_8320(pos).method_26204();
        for (BuildingType bt : API.getVillagePool()) {
            if (!bt.grouped() || !bt.getBlockToGroup().containsKey(class_2378.field_11146.method_10221((Object)block))) continue;
            return bt;
        }
        return null;
    }

    private Set<class_2338> getBlockedSet(Village village) {
        return village.getBuildings().values().stream().filter(b -> !b.getBuildingType().grouped()).map(Building::getSourceBlock).collect(Collectors.toSet());
    }

    public Building.validationResult processBuilding(class_2338 pos, boolean enforce, boolean strictScan) {
        Village village;
        Optional<Village> optionalVillage = this.findNearestVillage(pos, 64);
        BuildingType groupedBuildingType = this.getGroupedBuildingType(pos);
        HashSet<class_2338> blocked = new HashSet();
        boolean found = false;
        LinkedList<Integer> toRemove = new LinkedList<Integer>();
        if (optionalVillage.isPresent()) {
            Iterator name;
            village = optionalVillage.get();
            blocked = this.getBlockedSet(village);
            if (groupedBuildingType != null) {
                name = groupedBuildingType.name();
                double range = groupedBuildingType.mergeRange() * groupedBuildingType.mergeRange();
                Optional<Building> building = village.getBuildings().values().stream().filter(arg_0 -> VillageManager.lambda$processBuilding$13((String)((Object)name), arg_0)).min((a, b) -> (int)(a.getCenter().method_10262((class_2382)pos) - b.getCenter().method_10262((class_2382)pos))).filter(b -> b.getCenter().method_10262((class_2382)pos) < range);
                if (building.isPresent()) {
                    found = true;
                    building.get().addPOI((class_1937)this.world, pos);
                    this.method_80();
                }
            } else {
                for (Building b2 : village.getBuildings().values()) {
                    if (!b2.containsPos((class_2382)pos)) continue;
                    if (!enforce) {
                        found = true;
                    }
                    if (!enforce && this.world.method_8510() - b2.getLastScan() <= 4800L || b2.validateBuilding((class_1937)this.world, blocked) == Building.validationResult.SUCCESS) continue;
                    toRemove.add(b2.getId());
                }
            }
            village.getBuildings().values().stream().filter(b -> enforce || this.world.method_8510() - b.getLastScan() > 4800L).filter(b -> b.getBuildingType().grouped()).filter(b -> b.getCenter().method_10262((class_2382)pos) < 1024.0).forEach(b -> {
                b.validateBlocks((class_1937)this.world);
                if (b.getBlockPosStream().findAny().isEmpty()) {
                    toRemove.add(b.getId());
                }
            });
            name = toRemove.iterator();
            while (name.hasNext()) {
                int id = (Integer)name.next();
                village.removeBuilding(id);
                this.method_80();
            }
            if (village.getBuildings().isEmpty()) {
                this.villages.remove(village.getId());
                optionalVillage = Optional.empty();
                this.method_80();
            }
        }
        if (!found && !blocked.contains(pos)) {
            village = optionalVillage.orElse(new Village(this.lastVillageId++));
            Building building = new Building(pos, strictScan);
            if (groupedBuildingType != null) {
                building.setType(groupedBuildingType.name());
                building.addPOI((class_1937)this.world, pos);
            } else {
                Building.validationResult result = building.validateBuilding((class_1937)this.world, blocked);
                if (result == Building.validationResult.SUCCESS) {
                    if (village.getBuildings().values().stream().anyMatch(b -> b.isIdentical(building))) {
                        return Building.validationResult.IDENTICAL;
                    }
                } else {
                    return result;
                }
            }
            this.villages.put(village.getId(), village);
            building.setId(this.lastBuildingId++);
            village.getBuildings().put(building.getId(), building);
            village.calculateDimensions();
            this.buildingToVillages.put(building.getId(), village.getId());
            this.villages.values().stream().filter(v -> v != village).filter(v -> v.getBox().method_35410(64).method_14657((class_3341)village.getBox())).findAny().ifPresent(v -> {
                if (v.getPopulation() > village.getPopulation()) {
                    this.merge((Village)v, village);
                    this.villages.remove(village.getId());
                } else {
                    this.merge(village, (Village)v);
                    this.villages.remove(v.getId());
                }
            });
            this.method_80();
        }
        return Building.validationResult.SUCCESS;
    }

    public void setBuildingCooldown(int buildingCooldown) {
        this.buildingCooldown = buildingCooldown;
    }

    public int mapBuildingToVillage(Integer buildingId) {
        return this.buildingToVillages.getOrDefault(buildingId, -1);
    }

    public void merge(Village into, Village from) {
        into.merge(from);
        for (Building b : from.getBuildings().values()) {
            this.buildingToVillages.put(b.getId(), into.getId());
        }
    }

    private static /* synthetic */ boolean lambda$processBuilding$13(String name, Building b) {
        return b.getType().equals(name);
    }
}

