/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.resources.data.dialogue;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fabric.net.mca.client.gui.Constraint;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.interaction.InteractionPredicate;
import fabric.net.mca.resources.data.dialogue.Answer;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_3222;

public class Question {
    private final String id;
    private final String group;
    private final List<Answer> answers;
    private final boolean auto;
    private final boolean silent;

    public Question(String id, String group, List<Answer> answers, boolean auto, boolean silent) {
        this.id = id;
        this.group = group;
        this.answers = answers;
        this.auto = auto;
        this.silent = silent;
    }

    public static Question fromJson(String id, JsonObject json) {
        String group = json.has("group") ? json.get("group").getAsString() : null;
        boolean auto = json.has("auto") && json.get("auto").getAsBoolean();
        boolean silent = json.has("silent") && json.get("silent").getAsBoolean();
        LinkedList<Answer> answers = new LinkedList<Answer>();
        for (JsonElement e : json.getAsJsonArray("answers")) {
            answers.add(Answer.fromJson(e.getAsJsonObject()));
        }
        if (json.has("baseConditions")) {
            int r = 0;
            for (JsonElement conditions : json.getAsJsonArray("baseConditions")) {
                for (JsonElement e : conditions.getAsJsonArray()) {
                    InteractionPredicate predicate = InteractionPredicate.fromJson(e.getAsJsonObject());
                    int finalR = r;
                    answers.forEach(a -> a.getResults().get(finalR).getConditions().add(predicate));
                }
                ++r;
            }
        }
        return new Question(id, group, answers, auto, silent);
    }

    public String getId() {
        return this.id;
    }

    public String getGroup() {
        return this.group;
    }

    public List<Answer> getAnswers() {
        return this.answers;
    }

    public boolean isCloseScreen() {
        return this.answers == null;
    }

    public Answer getAnswer(String answer) {
        for (Answer a : this.answers) {
            if (!a.getName().equals(answer)) continue;
            return a;
        }
        return null;
    }

    public static String getTranslationKey(String question) {
        return "dialogue." + question;
    }

    public static String getTranslationKey(String question, String answer) {
        return "dialogue." + question + "." + answer;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public List<String> getValidAnswers(class_3222 player, VillagerEntityMCA villager) {
        Set<Constraint> constraints = Constraint.allMatching(villager, player);
        LinkedList<String> ans = new LinkedList<String>();
        for (Answer a : this.answers) {
            if (!a.isValidForConstraint(constraints)) continue;
            ans.add(a.getName());
        }
        return ans;
    }

    public boolean isSilent() {
        return this.silent;
    }
}

