/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.network;

import fabric.net.mca.Config;
import fabric.net.mca.MCAClient;
import fabric.net.mca.client.book.Book;
import fabric.net.mca.client.gui.BlueprintScreen;
import fabric.net.mca.client.gui.CombScreen;
import fabric.net.mca.client.gui.ExtendedBookScreen;
import fabric.net.mca.client.gui.FamilyTreeScreen;
import fabric.net.mca.client.gui.FamilyTreeSearchScreen;
import fabric.net.mca.client.gui.InteractScreen;
import fabric.net.mca.client.gui.LimitedVillagerEditorScreen;
import fabric.net.mca.client.gui.NameBabyScreen;
import fabric.net.mca.client.gui.NeedleScreen;
import fabric.net.mca.client.gui.VillagerEditorScreen;
import fabric.net.mca.client.gui.WhistleScreen;
import fabric.net.mca.entity.EntitiesMCA;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.VillagerLike;
import fabric.net.mca.item.BabyItem;
import fabric.net.mca.item.ExtendedWrittenBookItem;
import fabric.net.mca.network.ClientInteractionManager;
import fabric.net.mca.network.s2c.AnalysisResults;
import fabric.net.mca.network.s2c.BabyNameResponse;
import fabric.net.mca.network.s2c.FamilyTreeUUIDResponse;
import fabric.net.mca.network.s2c.GetChildDataResponse;
import fabric.net.mca.network.s2c.GetFamilyResponse;
import fabric.net.mca.network.s2c.GetFamilyTreeResponse;
import fabric.net.mca.network.s2c.GetInteractDataResponse;
import fabric.net.mca.network.s2c.GetVillageFailedResponse;
import fabric.net.mca.network.s2c.GetVillageResponse;
import fabric.net.mca.network.s2c.GetVillagerResponse;
import fabric.net.mca.network.s2c.InteractionDialogueResponse;
import fabric.net.mca.network.s2c.OpenDestinyGuiRequest;
import fabric.net.mca.network.s2c.OpenGuiRequest;
import fabric.net.mca.network.s2c.PlayerDataMessage;
import fabric.net.mca.network.s2c.ShowToastRequest;
import fabric.net.mca.network.s2c.SkinListResponse;
import fabric.net.mca.network.s2c.VillagerNameResponse;
import fabric.net.mca.server.world.data.BabyTracker;
import fabric.net.mca.server.world.data.Village;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_437;

public class ClientInteractionManagerImpl
implements ClientInteractionManager {
    private final class_310 client = class_310.method_1551();

    @Override
    public void handleGuiRequest(OpenGuiRequest message) {
        assert (this.client.field_1687 != null);
        assert (class_310.method_1551().field_1724 != null);
        switch (message.getGui()) {
            case WHISTLE: {
                this.client.method_1507((class_437)new WhistleScreen());
                break;
            }
            case BOOK: {
                class_1799 item;
                class_1792 class_17922;
                if (this.client.field_1724 == null || !((class_17922 = (item = this.client.field_1724.method_5998(class_1268.field_5808)).method_7909()) instanceof ExtendedWrittenBookItem)) break;
                ExtendedWrittenBookItem bookItem = (ExtendedWrittenBookItem)class_17922;
                Book book = bookItem.getBook(item);
                this.client.method_1507((class_437)new ExtendedBookScreen(book));
                break;
            }
            case BLUEPRINT: {
                this.client.method_1507((class_437)new BlueprintScreen());
                break;
            }
            case INTERACT: {
                class_1799 item;
                boolean isOnBlacklist;
                if (this.client.field_1724 == null || (isOnBlacklist = Config.getInstance().villagerInteractionItemBlacklist.contains(class_2378.field_11142.method_10221((Object)(item = this.client.field_1724.method_5998(class_1268.field_5808)).method_7909()).toString()))) break;
                VillagerLike villager = (VillagerLike)this.client.field_1687.method_8469(message.villager);
                this.client.method_1507((class_437)new InteractScreen(villager));
                break;
            }
            case VILLAGER_EDITOR: {
                class_1297 entity = this.client.field_1687.method_8469(message.villager);
                assert (entity != null);
                this.client.method_1507((class_437)new VillagerEditorScreen(entity.method_5667(), class_310.method_1551().field_1724.method_5667()));
                break;
            }
            case LIMITED_VILLAGER_EDITOR: {
                class_1297 entity = this.client.field_1687.method_8469(message.villager);
                assert (entity != null);
                this.client.method_1507((class_437)new LimitedVillagerEditorScreen(entity.method_5667(), class_310.method_1551().field_1724.method_5667()));
                break;
            }
            case NEEDLE_AND_THREAD: {
                class_1297 entity = this.client.field_1687.method_8469(message.villager);
                if (entity == null) {
                    this.client.method_1507((class_437)new NeedleScreen(class_310.method_1551().field_1724.method_5667()));
                    break;
                }
                this.client.method_1507((class_437)new NeedleScreen(entity.method_5667(), class_310.method_1551().field_1724.method_5667()));
                break;
            }
            case COMB: {
                class_1297 entity = this.client.field_1687.method_8469(message.villager);
                if (entity == null) {
                    this.client.method_1507((class_437)new CombScreen(class_310.method_1551().field_1724.method_5667()));
                    break;
                }
                this.client.method_1507((class_437)new CombScreen(entity.method_5667(), class_310.method_1551().field_1724.method_5667()));
                break;
            }
            case BABY_NAME: {
                class_1799 item;
                if (this.client.field_1724 == null || !((item = this.client.field_1724.method_5998(class_1268.field_5808)).method_7909() instanceof BabyItem)) break;
                this.client.method_1507((class_437)new NameBabyScreen((class_1657)this.client.field_1724, item));
                break;
            }
            case FAMILY_TREE: {
                this.client.method_1507((class_437)new FamilyTreeSearchScreen());
                break;
            }
        }
    }

    @Override
    public void handleFamilyTreeResponse(GetFamilyTreeResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof FamilyTreeScreen) {
            FamilyTreeScreen gui = (FamilyTreeScreen)screen;
            gui.setFamilyData(message.uuid, message.family);
        }
    }

    @Override
    public void handleInteractDataResponse(GetInteractDataResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof InteractScreen) {
            InteractScreen gui = (InteractScreen)screen;
            gui.setConstraints(message.constraints);
            gui.setParents(message.father, message.mother);
            gui.setSpouse(message.marriageState, message.spouse);
        }
    }

    @Override
    public void handleVillageDataResponse(GetVillageResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof BlueprintScreen) {
            BlueprintScreen gui = (BlueprintScreen)screen;
            Village village = new Village();
            village.load(message.getData());
            gui.setVillage(village);
            gui.setRank(message.rank, message.reputation, message.isVillage, message.ids, message.tasks, message.buildingTypes);
        }
    }

    @Override
    public void handleVillageDataFailedResponse(GetVillageFailedResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof BlueprintScreen) {
            BlueprintScreen gui = (BlueprintScreen)screen;
            gui.setVillage(null);
        }
    }

    @Override
    public void handleFamilyDataResponse(GetFamilyResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof WhistleScreen) {
            WhistleScreen gui = (WhistleScreen)screen;
            gui.setVillagerData(message.getData());
        }
    }

    @Override
    public void handleVillagerDataResponse(GetVillagerResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof VillagerEditorScreen) {
            VillagerEditorScreen gui = (VillagerEditorScreen)screen;
            gui.setVillagerData(message.getData());
        }
    }

    @Override
    public void handleDialogueResponse(InteractionDialogueResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof InteractScreen) {
            InteractScreen gui = (InteractScreen)screen;
            gui.setDialogue(message.question, message.answers, message.silent);
        }
    }

    @Override
    public void handleChildData(GetChildDataResponse message) {
        BabyItem.CLIENT_STATE_CACHE.put((Object)message.id, Optional.ofNullable(message.getData()).map(BabyTracker.ChildSaveState::new));
    }

    @Override
    public void handleSkinListResponse(AnalysisResults message) {
        InteractScreen.setAnalysis(message.analysis);
    }

    @Override
    public void handleBabyNameResponse(BabyNameResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof NameBabyScreen) {
            NameBabyScreen gui = (NameBabyScreen)screen;
            gui.setBabyName(message.getName());
        }
    }

    @Override
    public void handleVillagerNameResponse(VillagerNameResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof VillagerEditorScreen) {
            VillagerEditorScreen gui = (VillagerEditorScreen)screen;
            gui.setVillagerName(message.getName());
        }
    }

    @Override
    public void handleToastMessage(ShowToastRequest message) {
        class_370.method_27024((class_374)this.client.method_1566(), (class_370.class_371)class_370.class_371.field_2218, (class_2561)message.getTitle(), (class_2561)message.getMessage());
    }

    @Override
    public void handleFamilyTreeUUIDResponse(FamilyTreeUUIDResponse response) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof FamilyTreeSearchScreen) {
            FamilyTreeSearchScreen gui = (FamilyTreeSearchScreen)screen;
            gui.setList(response.getList());
        }
    }

    @Override
    public void handlePlayerDataMessage(PlayerDataMessage response) {
        VillagerEntityMCA villager = (VillagerEntityMCA)((class_1299)EntitiesMCA.MALE_VILLAGER.get()).method_5883((class_1937)class_310.method_1551().field_1687);
        assert (villager != null);
        villager.method_5749(response.getData());
        MCAClient.playerData.put(response.uuid, villager);
    }

    @Override
    public void handleSkinListResponse(SkinListResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof VillagerEditorScreen) {
            VillagerEditorScreen gui = (VillagerEditorScreen)screen;
            gui.setSkinList(message.getClothing(), message.getHair());
        }
    }

    @Override
    public void handleDestinyGuiRequest(OpenDestinyGuiRequest message) {
        MCAClient.getDestinyManager().requestOpen(message.allowTeleportation);
    }
}

