/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.entity.ai.brain.tasks.chore;

import com.google.common.collect.ImmutableMap;
import fabric.net.mca.TagsMCA;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.ai.Chore;
import fabric.net.mca.entity.ai.TaskUtils;
import fabric.net.mca.entity.ai.brain.tasks.chore.AbstractChoreTask;
import fabric.net.mca.util.InventoryUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_173;
import net.minecraft.class_1747;
import net.minecraft.class_1752;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2511;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4538;
import net.minecraft.class_47;

public class HarvestingTask
extends AbstractChoreTask {
    private static final int TICKS_PER_TURN = 15;
    private static final int ITEM_READY = 0;
    private static final int ITEM_FOUND = 1;
    private static final int ITEM_MISSING = 2;
    private final List<class_2338> harvestable = new ArrayList<class_2338>();
    private int lastCropScan = 0;

    public HarvestingTask() {
        super((Map<class_4140<?>, class_4141>)ImmutableMap.of((Object)class_4140.field_18446, (Object)class_4141.field_18457, (Object)class_4140.field_18445, (Object)class_4141.field_18457));
    }

    @Override
    protected boolean shouldRun(class_3218 world, VillagerEntityMCA villager) {
        return villager.getVillagerBrain().getCurrentJob() == Chore.HARVEST && super.shouldRun(world, villager);
    }

    protected boolean shouldKeepRunning(class_3218 world, VillagerEntityMCA villager, long time) {
        return this.shouldRun(world, villager);
    }

    protected void finishRunning(class_3218 world, VillagerEntityMCA villager, long time) {
        class_1799 stack = villager.method_5998(villager.getDominantHand());
        if (!stack.method_7960()) {
            villager.method_6122(villager.getDominantHand(), class_1799.field_8037);
        }
    }

    @Override
    protected void run(class_3218 world, VillagerEntityMCA villager, long time) {
        super.run(world, villager, time);
        if (!villager.method_6084(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((class_1263)villager.method_35199(), stack -> stack.method_7909() instanceof class_1794);
            if (i == -1) {
                this.abandonJobWithMessage("chore.harvesting.nohoe");
            } else {
                class_1799 stack2 = villager.method_35199().method_5438(i);
                villager.method_6122(villager.getDominantHand(), stack2);
            }
        }
    }

    private class_2338 searchCrop(int rangeX, int rangeY, boolean harvestableOnly) {
        List<class_2338> nearbyCrops = TaskUtils.getNearbyBlocks(this.villager.method_24515(), this.villager.field_6002, blockState -> blockState.method_26164(class_3481.field_20341) || blockState.method_26204() instanceof class_2511, rangeX, rangeY);
        this.harvestable.clear();
        if (harvestableOnly) {
            this.harvestable.addAll(nearbyCrops.stream().filter(pos -> {
                class_2302 crop;
                class_2680 state = this.villager.field_6002.method_8320(pos);
                class_2248 patt3805$temp = state.method_26204();
                return patt3805$temp instanceof class_2302 && (crop = (class_2302)patt3805$temp).method_9825(state) || state.method_26204() instanceof class_2511;
            }).toList());
        }
        return TaskUtils.getNearestPoint(this.villager.method_24515(), this.harvestable.isEmpty() ? nearbyCrops : this.harvestable);
    }

    private class_2338 searchUnusedFarmLand(int rangeX, int rangeY) {
        return TaskUtils.getNearestPoint(this.villager.method_24515(), TaskUtils.getNearbyBlocks(this.villager.method_24515(), this.villager.field_6002, blockState -> blockState.method_27852(class_2246.field_10362), rangeX, rangeY).stream().filter(pos -> {
            class_2680 state = this.villager.field_6002.method_8320(pos);
            return state.method_26204() instanceof class_2344 && state.method_26184((class_4538)this.villager.field_6002, pos) && this.villager.field_6002.method_8320(pos.method_10084()).method_26215();
        }).toList());
    }

    @Override
    protected void keepRunning(class_3218 world, VillagerEntityMCA villager, long time) {
        class_2338 crops;
        if (this.villager == null) {
            this.villager = villager;
        }
        if (!InventoryUtils.contains((class_1263)villager.method_35199(), class_1794.class) && !villager.method_6084(villager.getDominantSlot())) {
            this.abandonJobWithMessage("chore.harvesting.nohoe");
        } else if (!villager.method_6084(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((class_1263)villager.method_35199(), stack -> stack.method_7909() instanceof class_1794);
            class_1799 stack2 = villager.method_35199().method_5438(i);
            villager.method_6122(villager.getDominantHand(), stack2);
        }
        class_2338 fertileFarmLand = this.searchUnusedFarmLand(16, 3);
        if (fertileFarmLand == null && villager.field_6012 - this.lastCropScan > 1200) {
            this.lastCropScan = villager.field_6012;
            fertileFarmLand = this.searchUnusedFarmLand(32, 16);
        }
        if (fertileFarmLand != null && villager.method_19623()) {
            villager.moveTowards(fertileFarmLand);
            if (villager.method_5707(class_243.method_24955((class_2382)fertileFarmLand)) <= 6.0 && this.tickAction()) {
                this.plantSeeds(world, villager, fertileFarmLand.method_10084());
            }
        }
        if ((crops = this.searchCrop(16, 3, true)) == null && villager.field_6012 - this.lastCropScan > 1200) {
            crops = this.searchCrop(32, 16, true);
        }
        if (crops == null) {
            this.failedTicks = 100;
            return;
        }
        if (this.harvestable.isEmpty()) {
            crops = this.searchCrop(16, 3, false);
        }
        villager.moveTowards(crops);
        if (villager.method_5707(class_243.method_24955((class_2382)crops)) <= 4.5 && this.tickAction()) {
            class_2680 state = world.method_8320(crops);
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof class_2302) {
                class_2302 crop = (class_2302)class_22482;
                if (crop.method_9825(state)) {
                    this.harvestCrops(world, crops);
                    this.plantSeeds(world, villager, crops);
                } else {
                    this.bonemealCrop(world, villager, crops);
                }
            } else if (state.method_26204() instanceof class_2511) {
                this.harvestCrops(world, crops);
            }
        }
    }

    private boolean tickAction() {
        return this.villager.field_6002.method_8510() % 15L == 0L;
    }

    private int swapItem(Predicate<class_1799> find) {
        class_1799 stack = this.villager.method_6047();
        if (find.test(stack)) {
            return 0;
        }
        class_1277 inventory = this.villager.method_35199();
        int slot = InventoryUtils.getFirstSlotContainingItem((class_1263)inventory, find);
        if (slot < 0) {
            return 2;
        }
        this.villager.method_6122(this.villager.getDominantHand(), inventory.method_5438(slot));
        return 1;
    }

    private boolean plantSeed(class_1799 itemStack, class_3218 serverWorld, class_2338 currentTarget) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            return serverWorld.method_8652(currentTarget, blockItem.method_7711().method_9564(), 3);
        }
        return false;
    }

    private void plantSeeds(class_3218 world, VillagerEntityMCA villager, class_2338 target) {
        class_3965 hitResult = new class_3965(class_243.method_24955((class_2382)target), class_2350.field_11033, target, true);
        class_1269 result = InventoryUtils.stream((class_1263)villager.method_35199()).filter(stack -> !stack.method_7960() && stack.method_7909() instanceof class_1747 && stack.method_31573(TagsMCA.Items.VILLAGER_PLANTABLE)).filter(stack -> {
            if (this.plantSeed((class_1799)stack, world, hitResult.method_17777())) {
                stack.method_7934(1);
                return true;
            }
            return false;
        }).findFirst().map(v -> class_1269.field_5812).orElse(class_1269.field_5814);
        if (result.method_23665()) {
            if (result.method_23666()) {
                villager.method_6104(villager.getDominantHand());
            }
        } else if (this.getAssigningPlayer().isPresent()) {
            villager.sendChatMessage(this.getAssigningPlayer().get(), "chore.harvesting.noseed", new Object[0]);
        }
    }

    private void bonemealCrop(class_3218 world, VillagerEntityMCA villager, class_2338 pos) {
        if (this.swapItem(stack -> stack.method_7909() instanceof class_1752) == 0 && class_1752.method_7720((class_1799)villager.method_6118(villager.getDominantSlot()), (class_1937)world, (class_2338)pos)) {
            villager.method_6104(villager.getDominantHand());
        }
    }

    private void harvestCrops(class_3218 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        class_47.class_48 lootcontext$builder = new class_47.class_48(world).method_312(class_181.field_24424, (Object)this.villager.method_19538()).method_312(class_181.field_1229, (Object)class_1799.field_8037).method_312(class_181.field_1226, (Object)this.villager).method_312(class_181.field_1224, (Object)state).method_311(this.villager.method_6051()).method_303(0.0f);
        ObjectArrayList drops = world.method_8503().method_3857().method_367(state.method_26204().method_26162()).method_319(lootcontext$builder.method_309(class_173.field_1172));
        for (class_1799 stack : drops) {
            this.villager.method_35199().method_5491(stack);
        }
        world.method_8651(pos, false, (class_1297)this.villager);
    }
}

