/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_9;
import org.jetbrains.annotations.Nullable;

public class SmarterOpenDoorsTask
extends class_4097<class_1309> {
    private static final int RUN_TIME = 20;
    private static final double PATHING_DISTANCE = 2.0;
    private static final double REACH_DISTANCE = 2.0;
    @Nullable
    private class_9 pathNode;
    private int ticks;

    public SmarterOpenDoorsTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_18449, (Object)class_4141.field_18456, (Object)class_4140.field_26389, (Object)class_4141.field_18458));
    }

    protected boolean method_18919(class_3218 world, class_1309 entity) {
        class_11 path = (class_11)entity.method_18868().method_18904(class_4140.field_18449).get();
        if (path.method_30849() || path.method_46()) {
            return false;
        }
        if (!Objects.equals(this.pathNode, path.method_29301())) {
            this.ticks = 20;
            return true;
        }
        if (this.ticks > 0) {
            --this.ticks;
        }
        return this.ticks == 0;
    }

    protected void method_18920(class_3218 world, class_1309 entity, long time) {
        class_2323 doorBlock2;
        class_2338 blockPos2;
        class_2680 blockState2;
        class_11 path = (class_11)entity.method_18868().method_18904(class_4140.field_18449).get();
        this.pathNode = path.method_29301();
        class_9 pathNode = path.method_30850();
        class_9 pathNode2 = path.method_29301();
        class_2338 blockPos = pathNode.method_22879();
        class_2680 blockState = world.method_8320(blockPos);
        if (blockState.method_27851(class_3481.field_15494, state -> state.method_26204() instanceof class_2323)) {
            class_2323 doorBlock = (class_2323)blockState.method_26204();
            if (!doorBlock.method_30841(blockState)) {
                doorBlock.method_10033((class_1297)entity, (class_1937)world, blockState, blockPos, true);
            }
            this.rememberToCloseDoor(world, entity, blockPos);
        }
        if ((blockState2 = world.method_8320(blockPos2 = pathNode2.method_22879())).method_27851(class_3481.field_15494, state -> state.method_26204() instanceof class_2323) && !(doorBlock2 = (class_2323)blockState2.method_26204()).method_30841(blockState2)) {
            doorBlock2.method_10033((class_1297)entity, (class_1937)world, blockState2, blockPos2, true);
            this.rememberToCloseDoor(world, entity, blockPos2);
        }
        SmarterOpenDoorsTask.pathToDoor(world, entity, pathNode, pathNode2);
    }

    public static void pathToDoor(class_3218 world, class_1309 entity, @Nullable class_9 lastNode, @Nullable class_9 currentNode) {
        class_4095 brain = entity.method_18868();
        if (brain.method_18896(class_4140.field_26389)) {
            Iterator iterator = ((Set)brain.method_18904(class_4140.field_26389).get()).iterator();
            while (iterator.hasNext()) {
                class_4208 globalPos = (class_4208)iterator.next();
                class_2338 blockPos = globalPos.method_19446();
                if (lastNode != null && lastNode.method_22879().equals((Object)blockPos) || currentNode != null && currentNode.method_22879().equals((Object)blockPos)) continue;
                if (SmarterOpenDoorsTask.cannotReachDoor(world, entity, globalPos)) {
                    iterator.remove();
                    continue;
                }
                class_2680 blockState = world.method_8320(blockPos);
                if (!blockState.method_27851(class_3481.field_15494, state -> state.method_26204() instanceof class_2323)) {
                    iterator.remove();
                    continue;
                }
                class_2323 doorBlock = (class_2323)blockState.method_26204();
                if (!doorBlock.method_30841(blockState)) {
                    iterator.remove();
                    continue;
                }
                if (SmarterOpenDoorsTask.hasOtherMobReachedDoor(world, entity, blockPos)) {
                    iterator.remove();
                    continue;
                }
                doorBlock.method_10033((class_1297)entity, (class_1937)world, blockState, blockPos, false);
                iterator.remove();
            }
        }
    }

    private static boolean hasOtherMobReachedDoor(class_3218 world, class_1309 entity, class_2338 pos) {
        class_4095 brain = entity.method_18868();
        if (!brain.method_18896(class_4140.field_18441)) {
            return false;
        }
        return ((List)brain.method_18904(class_4140.field_18441).get()).stream().filter(livingEntity2 -> livingEntity2.method_5864() == entity.method_5864()).filter(livingEntity -> pos.method_19769((class_2374)livingEntity.method_19538(), 2.0)).anyMatch(livingEntity -> SmarterOpenDoorsTask.hasReached(world, livingEntity, pos));
    }

    private static boolean hasReached(class_3218 world, class_1309 entity, class_2338 pos) {
        if (!entity.method_18868().method_18896(class_4140.field_18449)) {
            return false;
        }
        class_11 path = (class_11)entity.method_18868().method_18904(class_4140.field_18449).get();
        if (path.method_46()) {
            return false;
        }
        class_9 pathNode = path.method_30850();
        if (pathNode == null) {
            return false;
        }
        class_9 pathNode2 = path.method_29301();
        return pos.equals((Object)pathNode.method_22879()) || pos.equals((Object)pathNode2.method_22879());
    }

    private static boolean cannotReachDoor(class_3218 world, class_1309 entity, class_4208 doorPos) {
        return doorPos.method_19442() != world.method_27983() || !doorPos.method_19446().method_19769((class_2374)entity.method_19538(), 2.0);
    }

    private void rememberToCloseDoor(class_3218 world, class_1309 entity, class_2338 pos) {
        class_4095 brain = entity.method_18868();
        class_4208 globalPos = class_4208.method_19443((class_5321)world.method_27983(), (class_2338)pos);
        if (brain.method_18904(class_4140.field_26389).isPresent()) {
            ((Set)brain.method_18904(class_4140.field_26389).get()).add(globalPos);
        } else {
            brain.method_18878(class_4140.field_26389, (Object)Sets.newHashSet((Object[])new class_4208[]{globalPos}));
        }
    }
}

