/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import fabric.net.mca.entity.EquipmentSet;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.ai.MemoryModuleTypeMCA;
import fabric.net.mca.util.InventoryUtils;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class EquipmentTask
extends class_4097<VillagerEntityMCA> {
    private static final int COOLDOWN = 100;
    private int lastEquipTime;
    private final Predicate<VillagerEntityMCA> condition;
    private final Function<VillagerEntityMCA, EquipmentSet> equipmentSet;
    private boolean lastArmorWearState;

    public EquipmentTask(Predicate<VillagerEntityMCA> condition, Function<VillagerEntityMCA, EquipmentSet> set) {
        super((Map)ImmutableMap.of((Object)((class_4140)MemoryModuleTypeMCA.WEARS_ARMOR.get()), (Object)class_4141.field_18458));
        this.condition = condition;
        this.equipmentSet = set;
    }

    protected boolean shouldRun(class_3218 world, VillagerEntityMCA villager) {
        if (this.lastArmorWearState != villager.getVillagerBrain().getArmorWear()) {
            return true;
        }
        boolean present = villager.method_18868().method_18904((class_4140)MemoryModuleTypeMCA.WEARS_ARMOR.get()).isPresent();
        if (this.condition.test(villager)) {
            this.lastEquipTime = villager.field_6012;
            return !present || this.equipmentSet.apply(villager).getMainHand() != class_1802.field_8162 && villager.method_6047().method_7960();
        }
        if (villager.field_6012 - this.lastEquipTime > 100) {
            return present;
        }
        return false;
    }

    private void equipBestArmor(VillagerEntityMCA villager, class_1304 slot, class_1792 fallback) {
        class_1799 stack = InventoryUtils.getBestArmor((class_1263)villager.method_35199(), slot).orElse(new class_1799((class_1935)fallback));
        villager.method_5673(slot, stack);
    }

    private void equipBestWeapon(VillagerEntityMCA villager, class_1792 fallback) {
        class_1799 stack = InventoryUtils.getBestSword((class_1263)villager.method_35199()).orElse(new class_1799((class_1935)fallback));
        villager.method_5673(villager.getDominantSlot(), stack);
    }

    protected void run(class_3218 world, VillagerEntityMCA villager, long time) {
        super.method_18920(world, (class_1309)villager, time);
        this.lastArmorWearState = villager.getVillagerBrain().getArmorWear();
        EquipmentSet set = this.equipmentSet.apply(villager);
        boolean wear = this.condition.test(villager);
        if (wear) {
            villager.method_18868().method_18878((class_4140)MemoryModuleTypeMCA.WEARS_ARMOR.get(), (Object)true);
        } else {
            villager.method_18868().method_18875((class_4140)MemoryModuleTypeMCA.WEARS_ARMOR.get());
        }
        if (wear) {
            this.equipBestWeapon(villager, set.getMainHand());
            villager.method_5673(villager.getOpposingSlot(), new class_1799((class_1935)set.getGetOffHand()));
        } else {
            villager.method_6122(villager.getDominantHand(), class_1799.field_8037);
            villager.method_6122(villager.getOpposingHand(), class_1799.field_8037);
        }
        if (wear || villager.getVillagerBrain().getArmorWear()) {
            this.equipBestArmor(villager, class_1304.field_6169, set.getHead());
            this.equipBestArmor(villager, class_1304.field_6174, set.getChest());
            this.equipBestArmor(villager, class_1304.field_6172, set.getLegs());
            this.equipBestArmor(villager, class_1304.field_6166, set.getFeet());
        } else {
            villager.method_5673(class_1304.field_6169, class_1799.field_8037);
            villager.method_5673(class_1304.field_6174, class_1799.field_8037);
            villager.method_5673(class_1304.field_6172, class_1799.field_8037);
            villager.method_5673(class_1304.field_6166, class_1799.field_8037);
        }
    }
}

