/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.entity.ai;

import fabric.net.mca.Config;
import fabric.net.mca.entity.VillagerLike;
import fabric.net.mca.util.network.datasync.CDataManager;
import fabric.net.mca.util.network.datasync.CDataParameter;
import fabric.net.mca.util.network.datasync.CParameter;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5819;

public class Traits {
    private static final CDataParameter<class_2487> TRAITS = CParameter.create("traits", new class_2487());
    private class_5819 random;
    private final VillagerLike<?> entity;

    public static <E extends class_1297> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(TRAITS);
    }

    public Traits(VillagerLike<?> entity) {
        this.entity = entity;
        this.random = class_5819.method_43049((long)entity.asEntity().field_6002.field_9229.method_43055());
    }

    public Set<Trait> getTraits() {
        return ((class_2487)this.entity.getTrackedValue(TRAITS)).method_10541().stream().map(Trait::valueOf).collect(Collectors.toSet());
    }

    public Set<Trait> getInheritedTraits() {
        return this.getTraits().stream().filter(t -> this.random.method_43057() < t.inherit * Config.getInstance().traitInheritChance).collect(Collectors.toSet());
    }

    public boolean hasTrait(VillagerLike<?> target, Trait trait) {
        return ((class_2487)target.getTrackedValue(TRAITS)).method_10545(trait.name());
    }

    public boolean hasTrait(Trait trait) {
        return this.hasTrait(this.entity, trait);
    }

    public boolean hasTrait(String trait) {
        return this.hasTrait(this.entity, Trait.valueOf(trait.toUpperCase()));
    }

    public boolean eitherHaveTrait(Trait trait, VillagerLike<?> other) {
        return this.hasTrait(this.entity, trait) || this.hasTrait(other, trait);
    }

    public boolean hasSameTrait(Trait trait, VillagerLike<?> other) {
        return this.hasTrait(this.entity, trait) && this.hasTrait(other, trait);
    }

    public void addTrait(Trait trait) {
        class_2487 traits = ((class_2487)this.entity.getTrackedValue(TRAITS)).method_10553();
        traits.method_10556(trait.name(), true);
        this.entity.setTrackedValue(TRAITS, traits);
    }

    public void removeTrait(Trait trait) {
        class_2487 traits = ((class_2487)this.entity.getTrackedValue(TRAITS)).method_10553();
        traits.method_10551(trait.name());
        this.entity.setTrackedValue(TRAITS, traits);
    }

    public void randomize() {
        float total = (float)Arrays.stream(Trait.values()).mapToDouble(tr -> tr.chance).sum();
        for (Trait t : Trait.values()) {
            float chance = Config.getInstance().traitChance / total * t.chance;
            if (!(this.random.method_43057() < chance)) continue;
            this.addTrait(t);
        }
    }

    public void inherit(Traits from) {
        for (Trait t : from.getInheritedTraits()) {
            this.addTrait(t);
        }
    }

    public void inherit(Traits from, long seed) {
        class_5819 old = this.random;
        this.random = class_5819.method_43049((long)seed);
        this.inherit(from);
        this.random = old;
    }

    public float getVerticalScaleFactor() {
        return this.hasTrait(Trait.DWARFISM) ? 0.65f : 1.0f;
    }

    public float getHorizontalScaleFactor() {
        return this.hasTrait(Trait.DWARFISM) ? 0.85f : 1.0f;
    }

    public static enum Trait {
        LEFT_HANDED(1.0f, 0.5f, false),
        COLOR_BLIND(1.0f, 0.5f),
        HETEROCHROMIA(1.0f, 2.0f),
        LACTOSE_INTOLERANCE(1.0f, 1.0f),
        COELIAC_DISEASE(1.0f, 1.0f, false),
        DIABETES(1.0f, 1.0f, false),
        DWARFISM(1.0f, 1.0f),
        ALBINISM(1.0f, 1.0f),
        VEGETARIAN(1.0f, 0.0f, false),
        BISEXUAL(1.0f, 0.0f),
        HOMOSEXUAL(1.0f, 0.0f),
        ELECTRIFIED(0.0f, 0.0f, false),
        SIRBEN(0.025f, 1.0f, false),
        RAINBOW(0.05f, 0.0f);

        private final float chance;
        private final float inherit;
        private final boolean usableOnPlayer;

        private Trait(float chance, float inherit, boolean usableOnPlayer) {
            this.chance = chance;
            this.inherit = inherit;
            this.usableOnPlayer = usableOnPlayer;
        }

        private Trait(float chance, float inherit) {
            this(chance, inherit, true);
        }

        public class_2561 getName() {
            return class_2561.method_43471((String)("trait." + this.name().toLowerCase(Locale.ENGLISH)));
        }

        public class_2561 getDescription() {
            return class_2561.method_43471((String)("traitDescription." + this.name().toLowerCase(Locale.ENGLISH)));
        }

        public boolean isUsableOnPlayer() {
            return this.usableOnPlayer;
        }
    }
}

