/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.entity.ai;

import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.server.world.data.Building;
import fabric.net.mca.server.world.data.GraveyardManager;
import fabric.net.mca.server.world.data.Village;
import fabric.net.mca.server.world.data.VillageManager;
import fabric.net.mca.util.network.datasync.CDataManager;
import fabric.net.mca.util.network.datasync.CDataParameter;
import fabric.net.mca.util.network.datasync.CParameter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_4153;
import net.minecraft.class_4208;
import net.minecraft.class_5321;

public class Residency {
    private static final CDataParameter<Integer> BUILDING = CParameter.create("buildings", -1);
    private static final CDataParameter<class_2338> HANGOUT = CParameter.create("hangoutPos", class_2338.field_10980);
    private final VillagerEntityMCA entity;

    public static <E extends class_1297> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(BUILDING, HANGOUT);
    }

    public Residency(VillagerEntityMCA entity) {
        this.entity = entity;
    }

    public class_2338 getWorkplace() {
        return this.entity.method_18868().method_18904(class_4140.field_18439).map(class_4208::method_19446).orElse(class_2338.field_10980);
    }

    public void setWorkplace(class_1657 player) {
        this.entity.sendChatMessage(player, "interaction.setworkplace.success", new Object[0]);
        this.entity.method_18868().method_18875(class_4140.field_18439);
        this.entity.method_18868().method_18875(class_4140.field_25160);
    }

    public class_2338 getHangout() {
        return (class_2338)this.entity.getTrackedValue(HANGOUT);
    }

    public void setHangout(class_1657 player) {
        this.entity.sendChatMessage(player, "interaction.sethangout.success", new Object[0]);
        this.entity.setTrackedValue(HANGOUT, player.method_24515());
    }

    public void setBuildingId(int id) {
        this.entity.setTrackedValue(BUILDING, id);
    }

    public Optional<Village> getHomeVillage() {
        VillageManager manager = VillageManager.get((class_3218)this.entity.field_6002);
        return manager.getOrEmpty(manager.mapBuildingToVillage((Integer)this.entity.getTrackedValue(BUILDING)));
    }

    public Optional<Building> getHomeBuilding() {
        Optional<Building> building = this.getHomeVillage().flatMap(v -> v.getBuilding((Integer)this.entity.getTrackedValue(BUILDING)));
        if (building.isEmpty()) {
            this.setHomeLess();
        }
        return building;
    }

    public void leaveHome() {
        VillageManager manager = VillageManager.get((class_3218)this.entity.field_6002);
        Optional<Village> village = this.getHomeVillage();
        village.ifPresent(v -> {
            Optional<Building> building = v.getBuilding((Integer)this.entity.getTrackedValue(BUILDING));
            if (building.isPresent()) {
                building.get().getResidents().remove(this.entity.method_5667());
                manager.method_80();
            }
            v.cleanReputation();
            v.markDirty((class_3218)this.entity.field_6002);
        });
    }

    public Optional<class_4208> getHome() {
        return this.getHomeBuilding().map(building -> class_4208.method_19443((class_5321)this.entity.field_6002.method_27983(), (class_2338)building.getCenter()));
    }

    public void tick() {
        if (!this.entity.requiresHome()) {
            return;
        }
        if (this.entity.field_6012 % 600 == 0 && this.entity.doesProfessionRequireHome()) {
            if (this.getHomeVillage().filter(v -> !v.isAutoScan()).isEmpty()) {
                this.reportBuildings();
            }
            if ((Integer)this.entity.getTrackedValue(BUILDING) == -1) {
                Village.findNearest((class_1297)this.entity).ifPresent(this::seekNewHome);
            }
        }
        if (this.entity.field_6012 % 1200 == 0) {
            this.getHomeVillage().ifPresentOrElse(village -> {
                Optional<Building> building = village.getBuilding((Integer)this.entity.getTrackedValue(BUILDING));
                if (building.filter(b -> b.hasResident(this.entity.method_5667()) && !b.isCrowded()).isEmpty()) {
                    if (building.isPresent()) {
                        this.setHomeLess();
                    }
                } else {
                    Optional globalPos = this.entity.getMCABrain().method_18904(class_4140.field_18438);
                    if (globalPos.isPresent() && !building.get().containsPos((class_2382)((class_4208)globalPos.get()).method_19446())) {
                        this.setHomeLess();
                        return;
                    }
                    int mood = village.popMood((class_3218)this.entity.field_6002);
                    if (mood != 0) {
                        this.entity.getVillagerBrain().modifyMoodValue(mood);
                    }
                    this.entity.field_6002.method_18456().forEach(player -> {
                        int rep = village.popHearts((class_1657)player);
                        if (rep != 0) {
                            this.entity.getVillagerBrain().getMemoriesForPlayer((class_1657)player).modHearts(rep);
                        }
                    });
                    this.entity.field_6002.method_18456().forEach(player -> {
                        int hearts = this.entity.getVillagerBrain().getMemoriesForPlayer((class_1657)player).getHearts();
                        village.setReputation((class_1657)player, this.entity, hearts);
                    });
                }
            }, this::setHomeLess);
        }
    }

    private void setHomeLess() {
        Optional<Village> village = this.getHomeVillage();
        village.ifPresent(buildings -> buildings.removeResident(this.entity));
        this.setBuildingId(-1);
        this.entity.getMCABrain().method_18875(class_4140.field_18438);
    }

    private void setBuilding(Building b) {
        List<class_2338> group = b.getBlocksOfGroup(new class_2960("minecraft:beds"));
        if (group.size() > 0) {
            this.setBuilding(b, group.get(b.getResidents().size() % group.size()));
        } else {
            this.setBuilding(b, b.getCenter());
        }
    }

    private void setBuilding(Building b, class_2338 p) {
        this.setBuildingId(b.getId());
        this.entity.getMCABrain().method_18878(class_4140.field_18438, (Object)class_4208.method_19443((class_5321)this.entity.field_6002.method_27983(), (class_2338)p));
    }

    private void reportBuildings() {
        VillageManager manager = VillageManager.get((class_3218)this.entity.field_6002);
        Stream stream = ((class_3218)this.entity.field_6002).method_19494().method_21647(type -> true, p -> !manager.cache.contains(p), this.entity.method_24515(), 48, class_4153.class_4155.field_18489);
        stream.forEach(manager::reportBuilding);
        GraveyardManager.get((class_3218)this.entity.field_6002).reportToVillageManager((class_1297)this.entity);
    }

    private boolean seekNewHome(Village village) {
        List<Building> buildings = village.getBuildings().values().stream().filter(Building::hasFreeSpace).toList();
        if (!buildings.isEmpty()) {
            Building b = buildings.get(this.entity.method_6051().method_43048(buildings.size()));
            this.setBuilding(b);
            village.addResident(this.entity, b.getId());
            return true;
        }
        return false;
    }

    public void setHome(class_1657 player) {
        VillageManager manager = VillageManager.get((class_3218)player.field_6002);
        manager.processBuilding(player.method_24515(), true, false);
        manager.findNearestVillage((class_1297)player).ifPresentOrElse(village -> village.getBuildingAt((class_2382)player.method_24515()).ifPresentOrElse(building -> {
            if (!this.entity.doesProfessionRequireHome() || this.entity.getDespawnDelay() > 0) {
                this.entity.sendChatMessage(player, "interaction.sethome.temporary", new Object[0]);
            } else if (building.hasFreeSpace()) {
                this.entity.sendChatMessage(player, "interaction.sethome.success", new Object[0]);
                this.setHomeLess();
                this.setBuilding((Building)building, player.method_24515());
                village.addResident(this.entity, building.getId());
            } else if (building.getBuildingType().noBeds()) {
                this.entity.sendChatMessage(player, "interaction.sethome.bedfail." + building.getBuildingType().name(), new Object[0]);
            } else if (building.getBedCount() == 0) {
                this.entity.sendChatMessage(player, "interaction.sethome.nobeds", new Object[0]);
            } else {
                this.entity.sendChatMessage(player, "interaction.sethome.bedfail", new Object[0]);
            }
        }, () -> this.entity.sendChatMessage(player, "interaction.sethome.fail", new Object[0])), () -> this.entity.sendChatMessage(player, "interaction.sethome.fail", new Object[0]));
    }

    public void goHome(class_1657 player) {
        this.getHome().filter(p -> p.method_19442() == this.entity.field_6002.method_27983()).ifPresentOrElse(home -> {
            this.entity.moveTowards(home.method_19446());
            this.entity.sendChatMessage(player, "interaction.gohome.success", new Object[0]);
        }, () -> this.entity.sendChatMessage(player, "interaction.gohome.fail.nohome", new Object[0]));
    }
}

