/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.net.mca.MCA;
import fabric.net.mca.client.gui.ExtendedScreen;
import fabric.net.mca.client.gui.FamilyTreeScreen;
import fabric.net.mca.client.gui.widget.RectangleWidget;
import fabric.net.mca.client.gui.widget.TooltipButtonWidget;
import fabric.net.mca.cobalt.network.NetworkHandler;
import fabric.net.mca.network.c2s.GetVillageRequest;
import fabric.net.mca.network.c2s.RenameVillageMessage;
import fabric.net.mca.network.c2s.ReportBuildingMessage;
import fabric.net.mca.network.c2s.SaveVillageMessage;
import fabric.net.mca.resources.Rank;
import fabric.net.mca.resources.data.BuildingType;
import fabric.net.mca.resources.data.tasks.Task;
import fabric.net.mca.server.world.data.Building;
import fabric.net.mca.server.world.data.Village;
import fabric.net.mca.util.localization.FlowingText;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_746;

public class BlueprintScreen
extends ExtendedScreen {
    private final int positionTaxes = -60;
    private final int positionBirth = -10;
    private final int positionMarriage = 40;
    private Village village;
    private int reputation;
    private boolean isVillage;
    private Rank rank;
    private Set<String> completedTasks;
    private String page;
    private class_4185[] buttonTaxes;
    private class_4185[] buttonBirths;
    private class_4185[] buttonMarriage;
    private class_4185 buttonPage;
    private int pageNumber = 0;
    private final List<class_4185> catalogButtons = new LinkedList<class_4185>();
    private static final class_2960 ICON_TEXTURES = MCA.locate("textures/buildings.png");
    private BuildingType selectedBuilding;
    private UUID selectedVillager;
    private int mouseX;
    private int mouseY;
    private Map<Rank, List<Task>> tasks;
    private Map<String, BuildingType> buildingTypes;

    private BuildingType getBuildingType(String type) {
        return this.buildingTypes.containsKey(type) ? this.buildingTypes.get(type) : new BuildingType();
    }

    public BlueprintScreen() {
        super((class_2561)class_2561.method_43470((String)"Blueprint"));
    }

    private void saveVillage() {
        NetworkHandler.sendToServer(new SaveVillageMessage(this.village));
    }

    private void changeTaxes(int d) {
        this.village.setTaxes(Math.max(0, Math.min(100, this.village.getTaxes() + d)));
        this.saveVillage();
    }

    private void changePopulationThreshold(int d) {
        this.village.setPopulationThreshold(Math.max(0, Math.min(100, this.village.getPopulationThreshold() + d)));
        this.saveVillage();
    }

    private void changeMarriageThreshold(int d) {
        this.village.setMarriageThreshold(Math.max(0, Math.min(100, this.village.getMarriageThreshold() + d)));
        this.saveVillage();
    }

    private class_4185[] createValueChanger(int x, int y, int w, int h, Consumer<Boolean> onPress, class_2561 tooltip) {
        class_4185[] buttons = new class_4185[3];
        buttons[1] = (class_4185)this.method_37063((class_364)new class_4185(x - w / 2, y, w / 4, h, (class_2561)class_2561.method_43470((String)"<<"), b -> onPress.accept(false)));
        buttons[2] = (class_4185)this.method_37063((class_364)new class_4185(x + w / 4, y, w / 4, h, (class_2561)class_2561.method_43470((String)">>"), b -> onPress.accept(true)));
        buttons[0] = (class_4185)this.method_37063((class_364)new class_4185(x - w / 4, y, w / 2, h, (class_2561)class_2561.method_43470((String)""), b -> {}, (buttonWidget, matrixStack, mx, my) -> this.method_30901(matrixStack, FlowingText.wrap(tooltip, 160), mx, my)));
        return buttons;
    }

    protected void drawBuildingIcon(class_4587 transform, int x, int y, int u, int v) {
        transform.method_22903();
        transform.method_22904((double)x - 6.6, (double)y - 6.6, 0.0);
        transform.method_22905(0.66f, 0.66f, 0.66f);
        this.method_25302(transform, 0, 0, u, v, 20, 20);
        transform.method_22909();
    }

    public void method_25426() {
        NetworkHandler.sendToServer(new GetVillageRequest());
        this.setPage("waiting");
    }

    private void setPage(String page) {
        if (page.equals("close")) {
            assert (this.field_22787 != null);
            this.field_22787.method_1507(null);
            return;
        }
        this.page = page;
        this.method_37067();
        this.method_37063((class_364)new class_4185(5, 5, 20, 20, (class_2561)class_2561.method_43471((String)"gui.button.backarrow"), b -> this.setPage("close")));
        int bx = this.field_22789 / 2 - 180;
        int by = this.field_22790 / 2 - 56;
        if (!(page.equals("rename") || page.equals("empty") || page.equals("waiting"))) {
            for (String p : new String[]{"map", "rank", "catalog", "villagers", "rules", "refresh"}) {
                class_4185 widget = new class_4185(bx, by, 80, 20, (class_2561)class_2561.method_43471((String)("gui.blueprint." + p)), b -> this.setPage(p));
                this.method_37063((class_364)widget);
                if (page.equals(p)) {
                    widget.field_22763 = false;
                }
                by += 22;
            }
            by += 22;
        }
        switch (page) {
            case "empty": {
                bx = this.field_22789 / 2 - 48;
                by = this.field_22790 / 2;
                this.method_37063((class_364)new class_4185(bx, by + 5, 96, 20, (class_2561)class_2561.method_43471((String)"gui.blueprint.addBuilding"), b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.ADD));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                    this.method_25419();
                }));
                break;
            }
            case "refresh": {
                NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.FULL_SCAN));
                NetworkHandler.sendToServer(new GetVillageRequest());
                assert (this.field_22787 != null);
                assert (this.field_22787.field_1724 != null);
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43471((String)"blueprint.refreshed"), true);
                this.setPage("map");
                break;
            }
            case "advanced": {
                bx = this.field_22789 / 2 + 180 - 64 - 16;
                by = this.field_22790 / 2 - 56;
                class_5250 text = class_2561.method_43471((String)"gui.blueprint.autoScan");
                if (this.village.isAutoScan()) {
                    text.method_27692(class_124.field_1060);
                } else {
                    text.method_27692(class_124.field_1080).method_27692(class_124.field_1055);
                }
                this.method_37063((class_364)new TooltipButtonWidget(bx, by, 96, 20, text, arg_0 -> this.lambda$setPage$7((String)page, arg_0)));
                this.method_37063((class_364)new TooltipButtonWidget(bx, by += 22, 96, 20, class_2561.method_43471((String)"gui.blueprint.restrictAccess"), b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.FORCE_TYPE, "blocked"));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                }));
                this.method_37063((class_364)new TooltipButtonWidget(bx, by += 22, 96, 20, "gui.blueprint.addRoom", b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.ADD_ROOM));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                }));
                by += 66;
                if (this.isVillage) {
                    this.method_37063((class_364)new class_4185(bx, by, 96, 20, (class_2561)class_2561.method_43471((String)"gui.blueprint.renameVillage"), b -> this.setPage("rename")));
                }
                by += 22;
            }
            case "map": {
                bx = this.field_22789 / 2 + 180 - 64 - 16;
                by = this.field_22790 / 2 - 56 + 66;
                this.method_37063((class_364)new class_4185(bx, by, 96, 20, (class_2561)class_2561.method_43471((String)"gui.blueprint.addBuilding"), b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.ADD));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                }));
                this.method_37063((class_364)new class_4185(bx, by += 22, 96, 20, (class_2561)class_2561.method_43471((String)"gui.blueprint.removeBuilding"), b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.REMOVE));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                }));
                by += 22;
                if (page.equals("advanced")) break;
                this.method_37063((class_364)new class_4185(bx, by, 96, 20, (class_2561)class_2561.method_43471((String)"gui.blueprint.advanced"), b -> this.setPage("advanced")));
                break;
            }
            case "rank": {
                break;
            }
            case "catalog": {
                int row = 0;
                int col = 0;
                int size = 21;
                int x = this.field_22789 / 2 - 4 * size - 8;
                int y = (int)((double)(this.field_22790 / 2) - 2.0 * (double)size);
                this.catalogButtons.clear();
                for (BuildingType bt : this.buildingTypes.values()) {
                    if (!bt.visible()) continue;
                    class_344 widget = new class_344(row * size + x + 10, col * size + y - 10, 20, 20, bt.iconU(), bt.iconV() + 20, 20, ICON_TEXTURES, 256, 256, button -> {
                        this.selectBuilding(bt);
                        button.field_22763 = false;
                        this.catalogButtons.forEach(b -> {
                            b.field_22763 = true;
                        });
                    }, (class_2561)class_2561.method_43471((String)("buildingType." + bt.name())));
                    this.catalogButtons.add((class_4185)this.method_37063((class_364)widget));
                    if (++row <= 4) continue;
                    row = 0;
                    ++col;
                }
                break;
            }
            case "villagers": {
                this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 24 - 20, this.field_22790 / 2 + 54, 20, 20, (class_2561)class_2561.method_43470((String)"<"), b -> {
                    if (this.pageNumber > 0) {
                        --this.pageNumber;
                    }
                }));
                this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 24, this.field_22790 / 2 + 54, 20, 20, (class_2561)class_2561.method_43470((String)">"), b -> {
                    if ((double)this.pageNumber < Math.ceil((double)this.village.getPopulation() / 9.0) - 1.0) {
                        ++this.pageNumber;
                    }
                }));
                this.buttonPage = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 24, this.field_22790 / 2 + 54, 48, 20, (class_2561)class_2561.method_43470((String)"0/0)"), b -> {}));
                break;
            }
            case "rules": {
                this.buttonTaxes = this.createValueChanger(this.field_22789 / 2, this.field_22790 / 2 + -60 + 10, 80, 20, b -> this.changeTaxes(b != false ? 10 : -10), (class_2561)class_2561.method_43471((String)"gui.blueprint.tooltip.taxes"));
                this.toggleButtons(this.buttonTaxes, false);
                this.buttonBirths = this.createValueChanger(this.field_22789 / 2, this.field_22790 / 2 + -10 + 10, 80, 20, b -> this.changePopulationThreshold(b != false ? 10 : -10), (class_2561)class_2561.method_43471((String)"gui.blueprint.tooltip.births"));
                this.toggleButtons(this.buttonBirths, false);
                this.buttonMarriage = this.createValueChanger(this.field_22789 / 2, this.field_22790 / 2 + 40 + 10, 80, 20, b -> this.changeMarriageThreshold(b != false ? 10 : -10), (class_2561)class_2561.method_43471((String)"gui.blueprint.tooltip.marriage"));
                this.toggleButtons(this.buttonMarriage, false);
                break;
            }
            case "rename": {
                class_342 field = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 - 65, this.field_22790 / 2 - 16, 130, 20, (class_2561)class_2561.method_43471((String)"gui.blueprint.renameVillage")));
                field.method_1880(32);
                field.method_1852(this.village.getName());
                this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 66, this.field_22790 / 2 + 8, 64, 20, (class_2561)class_2561.method_43471((String)"gui.blueprint.cancel"), b -> this.setPage("map")));
                this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 2, this.field_22790 / 2 + 8, 64, 20, (class_2561)class_2561.method_43471((String)"gui.blueprint.rename"), b -> {
                    NetworkHandler.sendToServer(new RenameVillageMessage(this.village.getId(), field.method_1882()));
                    this.village.setName(field.method_1882());
                    this.setPage("map");
                }));
            }
        }
    }

    private void selectBuilding(BuildingType b) {
        this.selectedBuilding = b;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(class_4587 transform, int sizeX, int sizeY, float offset) {
        this.method_25420(transform);
        assert (this.field_22787 != null);
        this.mouseX = (int)(this.field_22787.field_1729.method_1603() * (double)this.field_22789 / (double)this.field_22787.method_22683().method_4489());
        this.mouseY = (int)(this.field_22787.field_1729.method_1604() * (double)this.field_22790 / (double)this.field_22787.method_22683().method_4506());
        switch (this.page) {
            case "waiting": {
                BlueprintScreen.method_27534((class_4587)transform, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"gui.blueprint.waiting"), (int)(this.field_22789 / 2), (int)(this.field_22790 / 2), (int)-5592406);
                break;
            }
            case "empty": {
                BlueprintScreen.method_27534((class_4587)transform, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"gui.blueprint.empty"), (int)(this.field_22789 / 2), (int)(this.field_22790 / 2 - 20), (int)-5592406);
                break;
            }
            case "map": {
                this.renderStats(transform);
            }
            case "advanced": {
                this.renderName(transform);
                this.renderMap(transform);
                break;
            }
            case "rank": {
                this.renderTasks(transform);
                this.renderStats(transform);
                break;
            }
            case "catalog": {
                this.renderCatalog(transform);
                break;
            }
            case "villagers": {
                this.renderVillagers(transform);
                break;
            }
            case "rules": {
                this.renderRules(transform);
            }
        }
        super.method_25394(transform, sizeX, sizeY, offset);
    }

    private void renderName(class_4587 transform) {
        transform.method_22903();
        transform.method_22905(2.0f, 2.0f, 2.0f);
        if (this.isVillage) {
            BlueprintScreen.method_25300((class_4587)transform, (class_327)this.field_22793, (String)this.village.getName(), (int)(this.field_22789 / 4), (int)(this.field_22790 / 4 - 48), (int)-1);
        } else {
            BlueprintScreen.method_27534((class_4587)transform, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"gui.blueprint.settlement"), (int)(this.field_22789 / 4), (int)(this.field_22790 / 4 - 48), (int)-1);
        }
        transform.method_22909();
    }

    private void renderStats(class_4587 transform) {
        int x = this.field_22789 / 2 + (this.page.equals("rank") ? -70 : 105);
        int y = this.field_22790 / 2 - 50;
        class_5250 rankStr = class_2561.method_43471((String)this.rank.getTranslationKey());
        int rankColor = this.rank.ordinal() == 0 ? -65536 : -256;
        this.field_22793.method_30881(transform, (class_2561)class_2561.method_43469((String)"gui.blueprint.currentRank", (Object[])new Object[]{rankStr}), (float)x, (float)y, rankColor);
        this.field_22793.method_30881(transform, (class_2561)class_2561.method_43469((String)"gui.blueprint.reputation", (Object[])new Object[]{String.valueOf(this.reputation)}), (float)x, (float)(y + 11), this.rank.ordinal() == 0 ? -65536 : -1);
        this.field_22793.method_30881(transform, (class_2561)class_2561.method_43469((String)"gui.blueprint.buildings", (Object[])new Object[]{this.village.getBuildings().size()}), (float)x, (float)(y + 22), -1);
        this.field_22793.method_30881(transform, (class_2561)class_2561.method_43469((String)"gui.blueprint.population", (Object[])new Object[]{this.village.getPopulation(), this.village.getMaxPopulation()}), (float)x, (float)(y + 33), -1);
    }

    /*
     * WARNING - void declaration
     */
    private void renderMap(class_4587 transform) {
        void var10_13;
        int mapSize = 75;
        int y = this.field_22790 / 2 + 8;
        RectangleWidget.drawRectangle(transform, this.field_22789 / 2 - mapSize, y - mapSize, this.field_22789 / 2 + mapSize, y + mapSize, -120);
        transform.method_22903();
        RenderSystem.setShaderTexture((int)0, (class_2960)ICON_TEXTURES);
        float sc = Math.min((float)mapSize / (float)(this.village.getBox().getMaxBlockCount() + 3) * 2.0f, 2.0f);
        int mouseLocalX = (int)(((double)this.mouseX - (double)this.field_22789 / 2.0) / (double)sc + (double)this.village.getCenter().method_10263());
        int mouseLocalY = (int)((float)(this.mouseY - y) / sc + (float)this.village.getCenter().method_10260());
        transform.method_22904((double)this.field_22789 / 2.0, (double)y, 0.0);
        transform.method_22905(sc, sc, 0.0f);
        transform.method_22904((double)(-this.village.getCenter().method_10263()), (double)(-this.village.getCenter().method_10260()), 0.0);
        assert (this.field_22787 != null);
        class_746 player = this.field_22787.field_1724;
        if (player != null) {
            RectangleWidget.drawRectangle(transform, (int)player.method_23317() - 1, (int)player.method_23321() - 1, (int)player.method_23317() + 1, (int)player.method_23321() + 1, -65281);
        }
        LinkedList<Building> hoverBuildings = new LinkedList<Building>();
        for (Building building : this.village.getBuildings().values()) {
            BuildingType bt = this.getBuildingType(building.getType());
            if (bt.isIcon()) {
                class_2338 class_23382 = building.getCenter();
                this.drawBuildingIcon(transform, class_23382.method_10263(), class_23382.method_10260(), bt.iconU(), bt.iconV());
                int n = 6;
                class_2382 class_23822 = new class_2382(mouseLocalX, class_23382.method_10264(), mouseLocalY);
                if (!(class_23382.method_10262(class_23822) < (double)(n * n))) continue;
                hoverBuildings.add(building);
                continue;
            }
            class_2338 class_23383 = building.getPos0();
            class_2338 class_23384 = building.getPos1();
            RectangleWidget.drawRectangle(transform, class_23383.method_10263(), class_23383.method_10260(), class_23384.method_10263(), class_23384.method_10260(), bt.getColor());
            if (bt.visible()) {
                class_2338 c = building.getCenter();
                this.drawBuildingIcon(transform, c.method_10263(), c.method_10260(), bt.iconU(), bt.iconV());
            }
            int margin = 1;
            if (mouseLocalX < class_23383.method_10263() - margin || mouseLocalX > class_23384.method_10263() + margin || mouseLocalY < class_23383.method_10260() - margin || mouseLocalY > class_23384.method_10260() + margin) continue;
            hoverBuildings.add(building);
        }
        transform.method_22909();
        hoverBuildings.sort((a, b) -> b.getCenter().method_10264() - a.getCenter().method_10264());
        LinkedList<List<class_2561>> tooltips = new LinkedList<List<class_2561>>();
        for (Object b2 : hoverBuildings) {
            tooltips.add(this.getBuildingTooltip((Building)b2));
        }
        boolean bl = false;
        for (List list : tooltips) {
            var10_13 += this.getTooltipHeight(list) + 9;
        }
        int py = this.mouseY - var10_13 / 2 + 12;
        for (List list : tooltips) {
            this.method_30901(transform, list, this.mouseX, py);
            py += this.getTooltipHeight(list) + 9;
        }
    }

    private List<class_2561> getBuildingTooltip(Building hoverBuilding) {
        LinkedList<class_2561> lines = new LinkedList<class_2561>();
        BuildingType bt = this.getBuildingType(hoverBuilding.getType());
        lines.add((class_2561)class_2561.method_43471((String)("buildingType." + bt.name())));
        if (!bt.grouped()) {
            lines.add((class_2561)class_2561.method_43469((String)"gui.blueprint.size", (Object[])new Object[]{String.valueOf(hoverBuilding.getSize())}));
        }
        for (String string : hoverBuilding.getResidents().values()) {
            lines.add((class_2561)class_2561.method_43470((String)string));
        }
        for (Map.Entry entry : hoverBuilding.getBlocks().entrySet()) {
            lines.add((class_2561)class_2561.method_43470((String)(((List)entry.getValue()).size() + " x ")).method_10852(this.getBlockName((class_2960)entry.getKey())).method_27692(class_124.field_1080));
        }
        return lines;
    }

    private void renderTasks(class_4587 transform) {
        if (this.rank == null) {
            return;
        }
        int y = this.field_22790 / 2 + 5;
        int x = this.field_22789 / 2 - 70;
        for (Task task : this.tasks.get((Object)this.rank.promote())) {
            boolean completed = this.completedTasks.contains(task.getId());
            class_5250 t = task.getTranslatable().method_27692(completed ? class_124.field_1055 : class_124.field_1070);
            this.field_22793.method_30881(transform, (class_2561)t, (float)x, (float)y, completed ? -7798904 : -43691);
            y += 11;
        }
    }

    private void renderCatalog(class_4587 transform) {
        transform.method_22903();
        transform.method_22905(2.0f, 2.0f, 2.0f);
        BlueprintScreen.method_27534((class_4587)transform, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"gui.blueprint.catalogFull"), (int)(this.field_22789 / 4), (int)(this.field_22790 / 4 - 52), (int)-1);
        transform.method_22909();
        BlueprintScreen.method_27534((class_4587)transform, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"gui.blueprint.catalogHint").method_27692(class_124.field_1080), (int)(this.field_22789 / 2), (int)(this.field_22790 / 2 - 82), (int)-1);
        int x = this.field_22789 / 2 + 35;
        int y = this.field_22790 / 2 - 50;
        if (this.selectedBuilding != null) {
            this.field_22793.method_30881(transform, (class_2561)class_2561.method_43471((String)("buildingType." + this.selectedBuilding.name())), (float)x, (float)y, this.selectedBuilding.getColor());
            List<class_2561> wrap = FlowingText.wrap((class_2561)class_2561.method_43471((String)("buildingType." + this.selectedBuilding.name() + ".description")).method_27692(class_124.field_1080).method_27692(class_124.field_1056), 150);
            for (class_2561 class_25612 : wrap) {
                this.field_22793.method_30881(transform, class_25612, (float)x, (float)(y + 12), -1);
                y += 10;
            }
            class_5250 size = this.selectedBuilding.size() == 0 ? class_2561.method_43471((String)"gui.blueprint.anySize") : class_2561.method_43469((String)"gui.blueprint.size", (Object[])new Object[]{String.valueOf(this.selectedBuilding.size())});
            this.field_22793.method_30881(transform, (class_2561)size, (float)x, (float)(y + 20), -2236963);
            for (Map.Entry<class_2960, Integer> entry : this.selectedBuilding.getGroups().entrySet()) {
                this.field_22793.method_30881(transform, (class_2561)class_2561.method_43470((String)(entry.getValue() + " x ")).method_10852(this.getBlockName(entry.getKey())), (float)x, (float)(y + 32), -1);
                y += 10;
            }
        } else {
            List<class_2561> wrap = FlowingText.wrap((class_2561)class_2561.method_43471((String)"gui.blueprint.buildingTypes").method_27692(class_124.field_1080).method_27692(class_124.field_1056), 150);
            for (class_2561 class_25613 : wrap) {
                this.field_22793.method_30881(transform, class_25613, (float)x, (float)y, -1);
                y += 10;
            }
        }
    }

    private void renderVillagers(class_4587 transform) {
        int index;
        int maxPages = (int)Math.ceil((double)this.village.getPopulation() / 9.0);
        this.buttonPage.method_25355((class_2561)class_2561.method_43470((String)(this.pageNumber + 1 + "/" + maxPages)));
        List villager = this.village.getBuildings().values().stream().flatMap(b -> b.getResidents().entrySet().stream()).sorted(Map.Entry.comparingByValue()).toList();
        this.selectedVillager = null;
        for (int i = 0; i < 9 && (index = i + this.pageNumber * 9) < villager.size(); ++i) {
            int y = this.field_22790 / 2 - 51 + i * 11;
            boolean hover = this.isMouseWithin(this.field_22789 / 2 - 50, y - 1, 100, 11);
            BlueprintScreen.method_27534((class_4587)transform, (class_327)this.field_22793, (class_2561)class_2561.method_43470((String)((String)villager.get(index).getValue())), (int)(this.field_22789 / 2), (int)y, (int)(hover ? -2631804 : -1));
            if (!hover) continue;
            this.selectedVillager = (UUID)villager.get(index).getKey();
        }
    }

    private void renderRules(class_4587 transform) {
        this.buttonTaxes[0].method_25355((class_2561)class_2561.method_43470((String)(this.village.getTaxes() + "%")));
        this.buttonMarriage[0].method_25355((class_2561)class_2561.method_43470((String)(this.village.getMarriageThreshold() + "%")));
        this.buttonBirths[0].method_25355((class_2561)class_2561.method_43470((String)(this.village.getPopulationThreshold() + "%")));
        BlueprintScreen.method_27534((class_4587)transform, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"gui.blueprint.taxes"), (int)(this.field_22789 / 2), (int)(this.field_22790 / 2 + -60), (int)-1);
        if (!this.rank.isAtLeast(Rank.MERCHANT)) {
            BlueprintScreen.method_27534((class_4587)transform, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"gui.blueprint.rankTooLow"), (int)(this.field_22789 / 2), (int)(this.field_22790 / 2 + -60 + 15), (int)-1);
            this.toggleButtons(this.buttonTaxes, false);
        } else {
            this.toggleButtons(this.buttonTaxes, true);
        }
        BlueprintScreen.method_27534((class_4587)transform, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"gui.blueprint.birth"), (int)(this.field_22789 / 2), (int)(this.field_22790 / 2 + -10), (int)-1);
        if (!this.rank.isAtLeast(Rank.NOBLE)) {
            BlueprintScreen.method_27534((class_4587)transform, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"gui.blueprint.rankTooLow"), (int)(this.field_22789 / 2), (int)(this.field_22790 / 2 + -10 + 15), (int)-1);
            this.toggleButtons(this.buttonBirths, false);
        } else {
            this.toggleButtons(this.buttonBirths, true);
        }
        BlueprintScreen.method_27534((class_4587)transform, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"gui.blueprint.marriage"), (int)(this.field_22789 / 2), (int)(this.field_22790 / 2 + 40), (int)-1);
        if (!this.rank.isAtLeast(Rank.MAYOR)) {
            BlueprintScreen.method_27534((class_4587)transform, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"gui.blueprint.rankTooLow"), (int)(this.field_22789 / 2), (int)(this.field_22790 / 2 + 40 + 15), (int)-1);
            this.toggleButtons(this.buttonMarriage, false);
        } else {
            this.toggleButtons(this.buttonMarriage, true);
        }
    }

    private class_2561 getBlockName(class_2960 id) {
        if (class_2378.field_11146.method_10250(id)) {
            return class_2561.method_43471((String)((class_2248)class_2378.field_11146.method_10223(id)).method_9539());
        }
        return class_2561.method_43471((String)("tag." + id.toString()));
    }

    private void toggleButtons(class_4185[] buttons, boolean active) {
        for (class_4185 b : buttons) {
            b.field_22763 = active;
            b.field_22764 = active;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.page.equals("villagers") && this.selectedVillager != null) {
            assert (this.field_22787 != null);
            this.field_22787.method_1507((class_437)new FamilyTreeScreen(this.selectedVillager));
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected boolean isMouseWithin(int x, int y, int w, int h) {
        return this.mouseX >= x && this.mouseX < x + w && this.mouseY >= y && this.mouseY < y + h;
    }

    public void setVillage(Village village) {
        this.village = village;
        if (village == null) {
            this.setPage("empty");
        } else if (this.page.equals("waiting")) {
            this.setPage("map");
        }
    }

    public void setRank(Rank rank, int reputation, boolean isVillage, Set<String> completedTasks, Map<Rank, List<Task>> tasks, Map<String, BuildingType> buildingTypes) {
        this.rank = rank;
        this.reputation = reputation;
        this.isVillage = isVillage;
        this.completedTasks = completedTasks;
        this.tasks = tasks;
        this.buildingTypes = buildingTypes;
    }

    private /* synthetic */ void lambda$setPage$7(String page, class_4185 b) {
        NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.AUTO_SCAN));
        NetworkHandler.sendToServer(new GetVillageRequest());
        this.village.toggleAutoScan();
        this.setPage(page);
    }
}

