/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IItemHandlerInteractionUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public class InventoryInteractionHelper {
    private InventoryInteractionHelper() {
    }

    public static boolean tryInventoryInteraction(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return false;
        }
        return InventoryInteractionHelper.tryInventoryInteraction(context.m_8083_(), context.m_43725_(), context.m_43722_(), context.m_43719_(), player);
    }

    public static boolean tryInventoryInteraction(BlockPos pos, Level world, ItemStack backpack, Direction face, Player player) {
        if (Config.COMMON.noInteractionBlocks.isBlockInteractionDisallowed(world.m_8055_(pos).m_60734_())) {
            return false;
        }
        return WorldHelper.getBlockEntity((BlockGetter)world, (BlockPos)pos).map(te -> te.getCapability(ForgeCapabilities.ITEM_HANDLER, face).map(itemHandler -> player.f_19853_.f_46443_ || backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> InventoryInteractionHelper.tryRunningInteractionWrappers(itemHandler, wrapper, player)).orElse(false) != false).orElse(false)).orElse(false);
    }

    private static boolean tryRunningInteractionWrappers(IItemHandler itemHandler, IStorageWrapper wrapper, Player player) {
        List wrappers = wrapper.getUpgradeHandler().getWrappersThatImplement(IItemHandlerInteractionUpgrade.class);
        if (wrappers.isEmpty()) {
            return false;
        }
        wrappers.forEach(upgrade -> upgrade.onHandlerInteract(itemHandler, player));
        return true;
    }
}

