/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.frozenup.init;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class FrozenUpSoundEvents {
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"frozenup");
    public static final RegistryObject<SoundEvent> ENTITY_CHILLOO_AMBIENT = FrozenUpSoundEvents.chilloo("ambient");
    public static final RegistryObject<SoundEvent> ENTITY_CHILLOO_DEATH = FrozenUpSoundEvents.chilloo("death");
    public static final RegistryObject<SoundEvent> ENTITY_CHILLOO_HURT = FrozenUpSoundEvents.chilloo("hurt");
    public static final RegistryObject<SoundEvent> ENTITY_CHILLOO_EAT = FrozenUpSoundEvents.chilloo("eat");
    public static final RegistryObject<SoundEvent> ENTITY_CHILLOO_SPIT = FrozenUpSoundEvents.chilloo("spit");
    public static final RegistryObject<SoundEvent> BLOCK_CHILLOO_FEATHER_BLOCK_BREAK = FrozenUpSoundEvents.chillooFeatherBlock("break");
    public static final RegistryObject<SoundEvent> BLOCK_CHILLOO_FEATHER_BLOCK_PLACE = FrozenUpSoundEvents.chillooFeatherBlock("place");
    public static final RegistryObject<SoundEvent> BLOCK_CHILLOO_FEATHER_LAMP_TOGGLE_ON = FrozenUpSoundEvents.chillooFeatherLamp("toggle_on");
    public static final RegistryObject<SoundEvent> BLOCK_CHILLOO_FEATHER_LAMP_TOGGLE_OFF = FrozenUpSoundEvents.chillooFeatherLamp("toggle_off");
    public static final RegistryObject<SoundEvent> ITEM_MUG_DRINK = FrozenUpSoundEvents.mug("drink");

    private static RegistryObject<SoundEvent> chilloo(String type) {
        return FrozenUpSoundEvents.entity("chilloo", type);
    }

    private static RegistryObject<SoundEvent> chillooFeatherBlock(String type) {
        return FrozenUpSoundEvents.block("chilloo_feather_block", type);
    }

    private static RegistryObject<SoundEvent> chillooFeatherLamp(String type) {
        return FrozenUpSoundEvents.block("chilloo_feather_lamp", type);
    }

    private static RegistryObject<SoundEvent> mug(String type) {
        return FrozenUpSoundEvents.item("mug", type);
    }

    private static RegistryObject<SoundEvent> block(String block, String type) {
        return FrozenUpSoundEvents.register("block." + block + "." + type);
    }

    private static RegistryObject<SoundEvent> entity(String entity, String type) {
        return FrozenUpSoundEvents.register("entity." + entity + "." + type);
    }

    private static RegistryObject<SoundEvent> item(String item, String type) {
        return FrozenUpSoundEvents.register("item." + item + "." + type);
    }

    private static RegistryObject<SoundEvent> register(String name) {
        return SOUND_EVENTS.register(name, () -> new SoundEvent(new ResourceLocation("frozenup", name)));
    }
}

