/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.frozenup.init;

import com.ninni.frozenup.FrozenUp;
import com.ninni.frozenup.block.FeatherLampBlock;
import com.ninni.frozenup.block.FiberCoveringBlock;
import com.ninni.frozenup.block.MugBlock;
import com.ninni.frozenup.block.VerticalSlabBlock;
import com.ninni.frozenup.block.vanilla.TruffleCakeBlock;
import com.ninni.frozenup.init.FrozenUpItems;
import com.ninni.frozenup.sound.FrozenUpBlockSoundGroups;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="frozenup", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FrozenUpBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"frozenup");
    public static final RegistryObject<Block> CHILLOO_FEATHER_BLOCK = FrozenUpBlocks.register("chilloo_feather_block", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76315_).m_60978_(0.1f).m_60918_(FrozenUpBlockSoundGroups.CHILLOO_FEATHER_BLOCK)));
    public static final RegistryObject<Block> CHILLOO_FEATHER_COVERING = FrozenUpBlocks.register("chilloo_feather_covering", () -> new FiberCoveringBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)CHILLOO_FEATHER_BLOCK.get()))));
    public static final RegistryObject<Block> CHILLOO_FEATHER_LAMP = FrozenUpBlocks.register("chilloo_feather_lamp", () -> new FeatherLampBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76315_).m_60978_(0.3f).m_60918_(FrozenUpBlockSoundGroups.CHILLOO_FEATHER_BLOCK).m_60953_(FrozenUpBlocks.createLightLevelFromLitBlockState(10))));
    public static final RegistryObject<Block> TRUFFLE_CAKE = FrozenUpBlocks.register("truffle_cake", () -> new TruffleCakeBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76287_).m_60978_(0.5f).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<Block> CUT_ICE = FrozenUpBlocks.register("cut_ice", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50354_)));
    public static final RegistryObject<Block> CUT_ICE_STAIRS = FrozenUpBlocks.register("cut_ice_stairs", () -> new StairBlock(((Block)CUT_ICE.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)CUT_ICE.get()))));
    public static final RegistryObject<Block> CUT_ICE_SLAB = FrozenUpBlocks.register("cut_ice_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)CUT_ICE.get()))));
    public static final RegistryObject<Block> CUT_ICE_CUBES = FrozenUpBlocks.register("cut_ice_cubes", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50354_)));
    public static final RegistryObject<Block> CUT_ICE_CUBE_STAIRS = FrozenUpBlocks.register("cut_ice_cube_stairs", () -> new StairBlock(((Block)CUT_ICE_CUBES.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)CUT_ICE_CUBES.get()))));
    public static final RegistryObject<Block> CUT_ICE_CUBE_SLAB = FrozenUpBlocks.register("cut_ice_cube_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)CUT_ICE_CUBES.get()))));
    public static final RegistryObject<Block> CUT_ICE_CUBE_WALL = FrozenUpBlocks.register("cut_ice_cube_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)CUT_ICE_CUBES.get()))));
    public static final RegistryObject<Block> EMPTY_MUG = FrozenUpBlocks.register("empty_mug", () -> new MugBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60955_()));
    public static final RegistryObject<Block> MUG_OF_MILK = FrozenUpBlocks.register("mug_of_milk", () -> new MugBlock((Supplier<Item>)FrozenUpItems.MUG_OF_MILK, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)EMPTY_MUG.get()))));
    public static final RegistryObject<Block> MUG_OF_CHOCOLATE_MILK = FrozenUpBlocks.register("mug_of_chocolate_milk", () -> new MugBlock((Supplier<Item>)FrozenUpItems.MUG_OF_CHOCOLATE_MILK, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)EMPTY_MUG.get()))));
    public static final RegistryObject<Block> MUG_OF_TRUFFLE_HOT_CHOCOLATE = FrozenUpBlocks.register("mug_of_truffle_hot_chocolate", () -> new MugBlock((Supplier<Item>)FrozenUpItems.MUG_OF_TRUFFLE_HOT_CHOCOLATE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)EMPTY_MUG.get()))));
    public static final RegistryObject<Block> CUT_ICE_VERTICAL_SLAB = FrozenUpBlocks.compatRegister("quark", "cut_ice_vertical_slab", () -> new VerticalSlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)CUT_ICE.get()))));
    public static final RegistryObject<Block> CUT_ICE_CUBE_VERTICAL_SLAB = FrozenUpBlocks.compatRegister("quark", "cut_ice_cube_vertical_slab", () -> new VerticalSlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)CUT_ICE_CUBES.get()))));

    private static ToIntFunction<BlockState> createLightLevelFromLitBlockState(int litLevel) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? litLevel : 0;
    }

    private static <B extends Block> RegistryObject<B> compatRegister(String modid, String id, Supplier<B> supplier) {
        return FrozenUpBlocks.compatRegister(modid, id, supplier, true);
    }

    private static <B extends Block> RegistryObject<B> compatRegister(String modid, String id, Supplier<B> supplier, boolean registerItem) {
        RegistryObject block = BLOCKS.register(id, supplier);
        if (registerItem) {
            FrozenUpItems.ITEMS.register(id, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_((CreativeModeTab)(ModList.get().isLoaded(modid) ? FrozenUp.ITEM_GROUP : null))));
        }
        return block;
    }

    private static <B extends Block> RegistryObject<B> register(String id, Supplier<B> supplier, boolean registerItem) {
        RegistryObject block = BLOCKS.register(id, supplier);
        if (registerItem) {
            FrozenUpItems.ITEMS.register(id, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(FrozenUp.ITEM_GROUP)));
        }
        return block;
    }

    private static <B extends Block> RegistryObject<B> register(String id, Supplier<B> block) {
        return FrozenUpBlocks.register(id, block, false);
    }
}

