/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.frozenup.entity.ai.goal;

import com.ninni.frozenup.entity.ChillooEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class DigInGrassGoal
extends Goal {
    private static final Predicate<BlockState> GRASS_PREDICATE = BlockStatePredicate.m_61287_((Block)Blocks.f_50034_);
    private static final ResourceLocation DIGGING_LOOT = new ResourceLocation("frozenup", "entities/chilloo_digging");
    private final ChillooEntity chilloo;
    private final Level world;
    private int timer;

    public DigInGrassGoal(ChillooEntity chilloo) {
        this.chilloo = chilloo;
        this.world = chilloo.f_19853_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.chilloo.m_217043_().m_188503_(1000) != 0 || !this.chilloo.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
            return false;
        }
        BlockPos blockPos = this.chilloo.m_20183_();
        if (GRASS_PREDICATE.test(this.world.m_8055_(blockPos))) {
            return true;
        }
        return this.world.m_8055_(blockPos.m_7495_()).m_204336_(BlockTags.f_144274_);
    }

    public void m_8056_() {
        this.timer = this.m_183277_(40);
        this.world.m_7605_((Entity)this.chilloo, (byte)10);
        this.chilloo.m_21573_().m_26573_();
    }

    public int getTimer() {
        return this.timer;
    }

    public void m_8041_() {
        this.timer = 0;
    }

    public boolean m_8045_() {
        return this.timer > 0;
    }

    public void m_8037_() {
        this.timer = Math.max(0, this.timer - 1);
        if (this.timer == 4) {
            BlockPos pos = this.chilloo.m_20183_();
            if (GRASS_PREDICATE.test(this.world.m_8055_(pos))) {
                this.chilloo.onDiggingInGrass();
            } else {
                BlockPos downPos = pos.m_7495_();
                if (this.world.m_8055_(downPos).m_204336_(BlockTags.f_144274_)) {
                    if (this.world.m_46469_().m_46207_(GameRules.f_46132_)) {
                        this.world.m_46796_(2001, downPos, Block.m_49956_((BlockState)Blocks.f_50493_.m_49966_()));
                        ObjectArrayList items = this.world.m_7654_().m_129898_().m_79217_(DIGGING_LOOT).m_230922_(new LootContext.Builder((ServerLevel)this.world).m_230911_(this.world.m_213780_()).m_78975_(LootContextParamSets.f_81410_));
                        this.chilloo.m_8061_(EquipmentSlot.MAINHAND, items.isEmpty() ? ItemStack.f_41583_ : (ItemStack)items.get(0));
                    }
                    this.chilloo.onDiggingInGrass();
                }
            }
        }
        if (!this.chilloo.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
            this.m_8041_();
        }
    }
}

