/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.frozenup.entity;

import com.ninni.frozenup.entity.ai.goal.DigInGrassGoal;
import com.ninni.frozenup.init.FrozenUpCriteriaTriggers;
import com.ninni.frozenup.init.FrozenUpEntities;
import com.ninni.frozenup.init.FrozenUpItemTags;
import com.ninni.frozenup.init.FrozenUpItems;
import com.ninni.frozenup.init.FrozenUpSoundEvents;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class ChillooEntity
extends TamableAnimal
implements Shearable {
    private static final EntityDataAccessor<Integer> BANDS_COLOR = SynchedEntityData.m_135353_(ChillooEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    static final Predicate<ItemEntity> PICKABLE_DROP_FILTER = item -> !item.m_32063_() && item.m_6084_();
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(ChillooEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final String TIME_SINCE_SHEARED_KEY = "TimeSinceSheared";
    private float headRollProgress;
    private float lastHeadRollProgress;
    private int eatingTime;
    private int digInGrassTimer;
    private long timeSinceSheared;
    private DigInGrassGoal digInGrassGoal;

    public ChillooEntity(EntityType<? extends ChillooEntity> type, Level world) {
        super(type, world);
        this.m_21553_(true);
    }

    public float getStepHeight() {
        return 1.0f;
    }

    protected void m_8099_() {
        this.digInGrassGoal = new DigInGrassGoal(this);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Fox.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(FrozenUpItemTags.CHILLOO_BREED_ITEMS), false));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 0.6, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new PickupItemGoal());
        this.f_21345_.m_25352_(8, (Goal)this.digInGrassGoal);
        this.f_21345_.m_25352_(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(11, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createChillooAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 12.0);
    }

    public float getEyeHeightAccess(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.5f;
    }

    public float getHeadRoll(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.lastHeadRollProgress, (float)this.headRollProgress) * 0.11f * (float)Math.PI;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.m_6142_()) {
            ++this.eatingTime;
            ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (this.canEat(itemStack)) {
                if (this.eatingTime > 600) {
                    ItemStack itemStack2 = itemStack.m_41671_(this.f_19853_, (LivingEntity)this);
                    if (!itemStack2.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, itemStack2);
                    }
                    this.eatingTime = 0;
                } else if (this.eatingTime > 560 && this.f_19796_.m_188501_() < 0.1f) {
                    this.m_5496_(this.m_7866_(itemStack), 1.0f, 1.0f);
                    this.f_19853_.m_7605_((Entity)this, (byte)45);
                }
            }
        }
        if (this.f_19853_.f_46443_) {
            this.digInGrassTimer = Math.max(0, this.digInGrassTimer - 1);
        }
    }

    protected void m_8024_() {
        this.digInGrassTimer = this.digInGrassGoal.getTimer();
        super.m_8024_();
        long time = this.f_19853_.m_46467_();
        if (this.isSheared() && this.f_19796_.m_188503_((int)(time - this.timeSinceSheared)) > 4200) {
            this.timeSinceSheared = time;
            this.setSheared(false);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.isSheared() && this.m_9236_().m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_HOT_OVERWORLD)) {
            int i = 0;
            while ((double)i < 0.25) {
                double velX = this.f_19796_.m_188583_() * -5.0;
                double velY = this.f_19796_.m_188583_() * -5.0;
                double velZ = this.f_19796_.m_188583_() * -5.0;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123804_, this.m_20208_(0.4), this.m_20227_(1.0) - 0.5, this.m_20262_(0.4), velX, velY, velZ);
                ++i;
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (itemStack.m_204117_(Tags.Items.SHEARS)) {
            if (!this.f_19853_.f_46443_ && this.m_6220_()) {
                this.m_5851_(SoundSource.PLAYERS);
                this.m_146852_(GameEvent.f_157781_, (Entity)player);
                itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (item == FrozenUpItems.TRUFFLE.get() && this.m_21223_() < this.m_21233_() && this.m_21824_()) {
            this.feedTruffleToChilloo(player);
        }
        if (item == FrozenUpItems.TRUFFLE.get() && !this.m_21824_()) {
            this.feedTruffleToChilloo(player);
        }
        if (this.f_19853_.f_46443_) {
            return this.m_21830_((LivingEntity)player) || this.m_21824_() || item == FrozenUpItems.TRUFFLE.get() && !this.m_21824_() ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            ItemStack stackInHand = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!stackInHand.m_41619_() && itemStack.m_41619_() && !player.m_36341_()) {
                player.m_36356_(stackInHand);
                stackInHand.m_41774_(1);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    FrozenUpCriteriaTriggers.RETRIEVE_ITEM_FROM_TAMED_CHILLOO.trigger(serverPlayer);
                }
                if (!this.m_20067_()) {
                    this.f_19853_.m_6269_(null, (Entity)this, (SoundEvent)FrozenUpSoundEvents.ENTITY_CHILLOO_SPIT.get(), this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
                }
                return InteractionResult.SUCCESS;
            }
            if (item == FrozenUpItems.TRUFFLE.get() && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(Objects.requireNonNull(item.m_41473_()).m_38744_());
                return InteractionResult.SUCCESS;
            }
            if (!itemStack.m_204117_(Tags.Items.DYES) && this.m_21830_((LivingEntity)player)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            DyeColor dyeColor = ((DyeItem)item).m_41089_();
            if (dyeColor != this.getBandsColor()) {
                this.setBandsColor(dyeColor);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (item == FrozenUpItems.TRUFFLE.get()) {
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.m_21839_(true);
            this.f_19853_.m_7605_((Entity)this, (byte)7);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                FrozenUpCriteriaTriggers.TAME_A_CHILLOO.trigger(serverPlayer);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void feedTruffleToChilloo(Player player) {
        Vec3 vec3d = this.m_20191_().m_82399_();
        RandomSource random = this.f_19853_.m_213780_();
        ItemStack stack = ((Item)FrozenUpItems.TRUFFLE.get()).m_7968_();
        if (!this.m_20067_()) {
            this.f_19853_.m_6269_(null, (Entity)this, (SoundEvent)FrozenUpSoundEvents.ENTITY_CHILLOO_EAT.get(), this.m_5720_(), 1.5f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
        if (!player.m_150110_().f_35937_) {
            player.m_21120_(player.m_7655_()).m_41774_(1);
        }
        for (int i = 0; i < 10; ++i) {
            double velX = random.m_188583_() * 0.075;
            double velY = random.m_188583_() * 0.075;
            double velZ = random.m_188583_() * 0.075;
            this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, velX, velY, velZ);
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(FrozenUpItemTags.CHILLOO_BREED_ITEMS);
    }

    protected void m_6668_(DamageSource source) {
        ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (!itemStack.m_41619_()) {
            this.m_19983_(itemStack);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        super.m_6668_(source);
    }

    public boolean m_7066_(ItemStack stack) {
        if (!this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
            return false;
        }
        return super.m_7066_(stack);
    }

    public boolean m_7252_(ItemStack stack) {
        ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (stack.m_150930_((Item)FrozenUpItems.CHILLOO_FEATHER.get())) {
            return false;
        }
        return itemStack.m_41619_() || this.eatingTime > 0 && stack.m_41720_().m_41472_() && !itemStack.m_41720_().m_41472_();
    }

    public void m_7822_(byte status) {
        if (status == 10) {
            this.digInGrassTimer = 40;
        } else {
            super.m_7822_(status);
        }
        if (status == 45) {
            ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!itemStack.m_41619_()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vec3d = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).m_82496_(-this.m_146909_() * 0.0175f).m_82524_(-this.m_146908_() * 0.0175f);
                    this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), this.m_20185_() + this.m_20154_().f_82479_ / 2.0, this.m_20186_(), this.m_20189_() + this.m_20154_().f_82481_ / 2.0, vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_);
                }
            }
        } else {
            super.m_7822_(status);
        }
    }

    public float getNeckAngle(float delta) {
        if (this.digInGrassTimer <= 0) {
            return 0.0f;
        }
        if (this.digInGrassTimer >= 4 && this.digInGrassTimer <= 36) {
            return 1.0f;
        }
        return this.digInGrassTimer < 4 ? ((float)this.digInGrassTimer - delta) / 4.0f : -((float)(this.digInGrassTimer - 40) - delta) / 4.0f;
    }

    public float getHeadAngle(float delta) {
        if (this.digInGrassTimer > 4 && this.digInGrassTimer <= 36) {
            float f = ((float)(this.digInGrassTimer - 4) - delta) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.m_14031_((float)(f * 28.7f));
        }
        return this.digInGrassTimer > 0 ? 0.62831855f : this.m_146909_() * ((float)Math.PI / 180);
    }

    private boolean canEat(ItemStack stack) {
        return stack.m_41720_().m_41472_() && this.f_19861_;
    }

    private void spit(ItemStack stack) {
        if (!stack.m_41619_() && !this.f_19853_.f_46443_) {
            ItemEntity itemEntity = new ItemEntity(this.f_19853_, this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, stack);
            itemEntity.m_32010_(40);
            itemEntity.m_32052_(this.m_20148_());
            this.m_5496_((SoundEvent)FrozenUpSoundEvents.ENTITY_CHILLOO_SPIT.get(), 1.0f, 1.0f);
            this.f_19853_.m_7967_((Entity)itemEntity);
        }
    }

    private void dropItem(ItemStack stack) {
        this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack));
    }

    protected void m_7581_(ItemEntity item) {
        ItemStack itemStack = item.m_32055_();
        if (this.m_7252_(itemStack)) {
            int i = itemStack.m_41613_();
            if (i > 1) {
                this.dropItem(itemStack.m_41620_(i - 1));
            }
            this.spit(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_21053_(item);
            this.m_8061_(EquipmentSlot.MAINHAND, itemStack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)item, itemStack.m_41613_());
            item.m_146870_();
            this.eatingTime = 0;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BANDS_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(SHEARED, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Sheared", this.isSheared());
        tag.m_128356_(TIME_SINCE_SHEARED_KEY, this.timeSinceSheared);
        tag.m_128344_("BandsColor", (byte)this.getBandsColor().m_41060_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setSheared(tag.m_128471_("Sheared"));
        this.timeSinceSheared = tag.m_128454_(TIME_SINCE_SHEARED_KEY);
        if (tag.m_128425_("BandsColor", 99)) {
            this.setBandsColor(DyeColor.m_41053_((int)tag.m_128451_("BandsColor")));
        }
    }

    public boolean isSheared() {
        return ((Boolean)this.f_19804_.m_135370_(SHEARED)).equals(true);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    public DyeColor getBandsColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(BANDS_COLOR)));
    }

    public void setBandsColor(DyeColor color) {
        this.f_19804_.m_135381_(BANDS_COLOR, (Object)color.m_41060_());
    }

    public boolean m_6573_(Player player) {
        return super.m_6573_(player);
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(this.m_21233_());
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(12.0);
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob p_146744_) {
        ChillooEntity chilloo = (ChillooEntity)((EntityType)FrozenUpEntities.CHILLOO.get()).m_20615_((Level)world);
        UUID uUID = this.m_21805_();
        if (uUID != null && chilloo != null) {
            chilloo.m_21816_(uUID);
            chilloo.m_7105_(true);
        }
        return chilloo;
    }

    public void onDiggingInGrass() {
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)FrozenUpSoundEvents.ENTITY_CHILLOO_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)FrozenUpSoundEvents.ENTITY_CHILLOO_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)FrozenUpSoundEvents.ENTITY_CHILLOO_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12345_, 0.15f, 1.0f);
    }

    public void m_5851_(SoundSource category) {
        this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12344_, category, 1.0f, 1.0f);
        this.setSheared(true);
        if (this.isSheared()) {
            this.timeSinceSheared = this.f_19853_.m_46467_();
        }
        int l = 2 + this.f_19796_.m_188503_(5);
        for (int i = 0; i < l; ++i) {
            ItemEntity itemEntity = this.m_20000_((ItemLike)FrozenUpItems.CHILLOO_FEATHER.get(), 1);
            if (itemEntity == null) continue;
            itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.isSheared() && !this.m_6162_();
    }

    class PickupItemGoal
    extends Goal {
        public PickupItemGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!ChillooEntity.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                return false;
            }
            if (ChillooEntity.this.m_5448_() == null && ChillooEntity.this.m_21188_() == null) {
                if (!ChillooEntity.this.m_21691_()) {
                    return false;
                }
                if (ChillooEntity.this.m_217043_().m_188503_(PickupItemGoal.m_186073_((int)10)) != 0) {
                    return false;
                }
                return !ChillooEntity.this.f_19853_.m_6443_(ItemEntity.class, ChillooEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER).isEmpty() && ChillooEntity.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
            }
            return false;
        }

        public void m_8037_() {
            List list = ChillooEntity.this.f_19853_.m_6443_(ItemEntity.class, ChillooEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
            if (ChillooEntity.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_() && !list.isEmpty()) {
                ChillooEntity.this.m_21573_().m_6570_((Entity)list.get(0), 1);
            }
        }

        public void m_8056_() {
            List list = ChillooEntity.this.f_19853_.m_6443_(ItemEntity.class, ChillooEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
            if (!list.isEmpty()) {
                ChillooEntity.this.m_21573_().m_6570_((Entity)list.get(0), 1);
            }
        }
    }
}

