/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.frozenup.client.model;

import com.google.common.collect.ImmutableList;
import com.ninni.frozenup.entity.ChillooEntity;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChillooEntityModel
extends AgeableListModel<ChillooEntity> {
    private float headPitchModifier;
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    public final ModelPart head;
    private final ModelPart leftWhiskers;
    private final ModelPart rightWhiskers;

    public ChillooEntityModel(ModelPart root) {
        super(true, 8.0f, 3.35f);
        this.root = root;
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.leftWhiskers = this.head.m_171324_("leftWhiskers");
        this.rightWhiskers = this.head.m_171324_("rightWhiskers");
        this.rightLeg = this.body.m_171324_("rightLeg");
        this.leftLeg = this.body.m_171324_("leftLeg");
        this.tail = this.body.m_171324_("tail");
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition data = new MeshDefinition();
        PartDefinition root = data.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171555_(false).m_171488_(-5.0f, -4.5f, -8.0f, 10.0f, 9.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(0, 25).m_171555_(false).m_171488_(-5.0f, 4.5f, -8.0f, 10.0f, 3.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)13.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(34, 26).m_171555_(false).m_171488_(-1.5f, 3.0f, 0.0f, 3.0f, 4.0f, 18.0f, new CubeDeformation(0.0f)).m_171514_(0, 44).m_171555_(false).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.5f, (float)8.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = body.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(58, 15).m_171555_(true).m_171488_(-2.0f, 0.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(55, 55).m_171555_(true).m_171488_(-2.0f, 8.0f, -2.5f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(50, 48).m_171555_(true).m_171488_(-2.0f, 8.0f, -4.0f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5f, (float)0.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = body.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(58, 15).m_171555_(false).m_171488_(-3.0f, 0.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(55, 55).m_171555_(false).m_171488_(-3.0f, 8.0f, -2.5f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(50, 48).m_171555_(false).m_171488_(-3.0f, 8.0f, -4.0f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5f, (float)0.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171555_(false).m_171488_(-4.0f, -3.0f, -9.0f, 8.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(24, 48).m_171555_(false).m_171488_(-3.0f, 3.0f, -7.5f, 6.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftWhiskers = head.m_171599_("leftWhiskers", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171555_(false).m_171488_(0.0f, -1.5f, 0.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)1.5f, (float)-4.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition rightWhiskers = head.m_171599_("rightWhiskers", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171555_(true).m_171488_(-3.0f, -1.5f, 0.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)1.5f, (float)-4.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)data, (int)80, (int)80);
    }

    public void prepareMobModel(ChillooEntity entity, float limbAngle, float limbDistance, float tickDelta) {
        super.m_6839_((Entity)entity, limbAngle, limbDistance, tickDelta);
        this.head.f_104201_ = 15.0f + entity.getNeckAngle(tickDelta) * 4.0f;
        this.headPitchModifier = entity.getHeadAngle(tickDelta);
    }

    public void setupAnim(ChillooEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        limbDistance = Mth.m_14036_((float)limbDistance, (float)-0.45f, (float)0.45f);
        float speed = 1.0f;
        float degree = 1.0f;
        this.head.f_104203_ = this.headPitchModifier;
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.leftWhiskers.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.6f)) * degree * 0.2f * 0.5f + 0.8f;
        this.rightWhiskers.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.6f + (float)Math.PI)) * degree * 0.2f * 0.5f - 0.8f;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * speed * 0.6f)) * 1.4f * limbDistance;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * speed * 0.6f + (float)Math.PI)) * 1.4f * limbDistance;
        this.body.f_104205_ = Mth.m_14089_((float)(limbAngle * speed * 0.4f)) * 0.3f * limbDistance;
        this.tail.f_104204_ = Mth.m_14089_((float)(limbAngle * speed * 0.2f)) * degree * 1.0f * limbDistance;
        this.tail.f_104203_ = Mth.m_14089_((float)(limbAngle * speed * 0.4f + 1.5707964f)) * degree * 0.2f * limbDistance - 0.2f;
        this.body.f_104203_ = 0.0f;
        this.tail.f_104201_ = 0.0f;
        this.rightLeg.f_104202_ = 0.0f;
        this.leftLeg.f_104202_ = 0.0f;
        this.body.f_104201_ = 13.5f;
        this.leftLeg.f_104205_ = 0.0f;
        this.rightLeg.f_104205_ = 0.0f;
        this.head.f_104201_ = 15.0f;
        this.head.f_104202_ = -8.0f;
        if (entity.m_21824_()) {
            this.tail.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.2f)) * degree * 1.0f * 0.5f;
            this.tail.f_104203_ = Mth.m_14089_((float)(animationProgress * speed * 0.4f + 1.5707964f)) * degree * 0.2f * 0.5f - 0.2f;
        }
        if (entity.m_21825_()) {
            this.body.f_104203_ = -20.0f;
            this.body.f_104201_ = 17.0f;
            this.tail.f_104201_ = 0.4f;
            this.tail.f_104203_ += 2.2f;
            this.rightLeg.f_104203_ = -0.5f;
            this.rightLeg.f_104205_ = 0.5f;
            this.rightLeg.f_104202_ = 5.5f;
            this.leftLeg.f_104203_ = -0.5f;
            this.leftLeg.f_104205_ = -0.5f;
            this.leftLeg.f_104202_ = 5.5f;
            this.head.f_104201_ = 8.5f;
            this.head.f_104202_ = -2.5f;
            if (entity.m_6162_()) {
                this.head.f_104201_ = 12.5f;
                this.head.f_104202_ = -4.5f;
            }
        }
    }

    public void setRotateAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body);
    }
}

