/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.frozenup.block.vanilla;

import com.ninni.frozenup.init.FrozenUpCriteriaTriggers;
import com.ninni.frozenup.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TruffleCakeBlock
extends Block {
    public static final IntegerProperty BITES = BlockStateProperties.f_61412_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
    protected static final VoxelShape ONE_BITE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)8.0), (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)8.0, (double)14.0, (double)9.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape TWO_BITES = Block.m_49796_((double)2.0, (double)0.0, (double)8.0, (double)14.0, (double)9.0, (double)14.0);
    protected static final VoxelShape THREE_BITES = Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)14.0, (double)9.0, (double)14.0);

    public TruffleCakeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        if ((Integer)state.m_61143_((Property)BITES) == 1) {
            return ONE_BITE;
        }
        if ((Integer)state.m_61143_((Property)BITES) == 2) {
            return TWO_BITES;
        }
        if ((Integer)state.m_61143_((Property)BITES) == 3) {
            return THREE_BITES;
        }
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (world.m_5776_()) {
            if (TruffleCakeBlock.tryEat((LevelAccessor)world, pos, state, player).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return TruffleCakeBlock.tryEat((LevelAccessor)world, pos, state, player);
    }

    protected static InteractionResult tryEat(LevelAccessor world, BlockPos pos, BlockState state, Player player) {
        if (!player.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        player.m_36220_(Stats.f_12942_);
        player.m_36324_().m_38707_(3, 0.3f);
        Util.removeEntityEffects((LivingEntity)player, instance -> instance.m_19544_().m_19483_() == MobEffectCategory.HARMFUL);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (Util.removeEntityEffects((LivingEntity)player, mobEffectInstance -> mobEffectInstance.m_19544_().m_19483_() == MobEffectCategory.HARMFUL)) {
                FrozenUpCriteriaTriggers.CURE_HARMFUL_STATUS_EFFECTS.trigger(serverPlayer);
            }
        }
        player.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
        world.m_142346_((Entity)player, GameEvent.f_157806_, pos);
        if ((Integer)state.m_61143_((Property)BITES) < 3) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)BITES) + 1)), 3);
        } else {
            world.m_7471_(pos, false);
            world.m_142346_((Entity)player, GameEvent.f_157794_, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60767_().m_76333_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BITES});
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return TruffleCakeBlock.getComparatorOutput((Integer)state.m_61143_((Property)BITES));
    }

    public static int getComparatorOutput(int bites) {
        return (7 - bites) * 2;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

