/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.frozenup.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VerticalSlabBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<VerticalSlabType> TYPE = EnumProperty.m_61587_((String)"type", VerticalSlabType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public VerticalSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, WATERLOGGED});
    }

    public boolean m_7923_(BlockState state) {
        return state.m_61143_(TYPE) != VerticalSlabType.DOUBLE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return ((VerticalSlabType)((Object)state.m_61143_(VerticalSlabBlock.TYPE))).shape;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = context.m_43725_().m_8055_(blockpos);
        if (blockstate.m_60734_() == this) {
            return (BlockState)((BlockState)blockstate.m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(blockpos).m_76152_() == Fluids.f_76193_))).m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.fromDirection(this.getDirectionForPlacement(context))));
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.m_43722_();
        VerticalSlabType slabtype = (VerticalSlabType)((Object)state.m_61143_(TYPE));
        return slabtype != VerticalSlabType.DOUBLE && itemstack.m_41720_() == this.m_5456_() && (useContext.m_7058_() && useContext.m_43719_() == slabtype.direction && this.getDirectionForPlacement(useContext) == slabtype.direction || !useContext.m_7058_() && useContext.m_43719_().m_122434_() != slabtype.direction.m_122434_());
    }

    private Direction getDirectionForPlacement(BlockPlaceContext context) {
        Direction face = context.m_43719_();
        if (face.m_122434_() != Direction.Axis.Y) {
            return face;
        }
        Vec3 difference = context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)context.m_8083_())).m_82492_(0.5, 0.0, 0.5);
        return Direction.m_122364_((double)(-Math.toDegrees(Math.atan2(difference.m_7096_(), difference.m_7094_())))).m_122424_();
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        return state.m_61143_(TYPE) != VerticalSlabType.DOUBLE && super.m_7361_(world, pos, state, fluidState);
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return state.m_61143_(TYPE) != VerticalSlabType.DOUBLE && super.m_6044_(world, pos, state, fluid);
    }

    public BlockState m_7417_(BlockState state, Direction p_60542_, BlockState p_60543_, LevelAccessor world, BlockPos pos, BlockPos p_60546_) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return state;
    }

    public boolean m_7357_(BlockState p_60475_, BlockGetter world, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.WATER && world.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    public static enum VerticalSlabType implements StringRepresentable
    {
        NORTH(Direction.NORTH),
        SOUTH(Direction.SOUTH),
        WEST(Direction.WEST),
        EAST(Direction.EAST),
        DOUBLE(null);

        private final String name;
        @Nullable
        public final Direction direction;
        public final VoxelShape shape;

        private VerticalSlabType(Direction direction) {
            this.direction = direction;
            String string2 = this.name = direction == null ? "double" : direction.m_7912_();
            if (direction == null) {
                this.shape = Shapes.m_83144_();
            } else {
                boolean isNegativeAxis = direction.m_122421_() == Direction.AxisDirection.NEGATIVE;
                double min = isNegativeAxis ? 8.0 : 0.0;
                double max = isNegativeAxis ? 16.0 : 8.0;
                this.shape = direction.m_122434_() == Direction.Axis.X ? Block.m_49796_((double)min, (double)0.0, (double)0.0, (double)max, (double)16.0, (double)16.0) : Block.m_49796_((double)0.0, (double)0.0, (double)min, (double)16.0, (double)16.0, (double)max);
            }
        }

        public static VerticalSlabType fromDirection(Direction direction) {
            for (VerticalSlabType type : VerticalSlabType.values()) {
                if (type.direction == null || direction != type.direction) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

