/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.frozenup.block;

import com.ninni.frozenup.init.FrozenUpBlocks;
import com.ninni.frozenup.init.FrozenUpSoundEvents;
import com.ninni.frozenup.item.AbstractDrinkableMugItem;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MugBlock
extends HorizontalDirectionalBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    protected static final VoxelShape MUG = MugBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0);
    protected static final VoxelShape HANDLE = MugBlock.m_49796_((double)7.0, (double)2.5, (double)2.0, (double)9.0, (double)7.5, (double)4.0);
    protected static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)MUG, (VoxelShape)HANDLE);
    protected static final VoxelShape NORTH_SHAPE = Shapes.m_83110_((VoxelShape)MUG, (VoxelShape)HANDLE);
    protected static final VoxelShape SOUTH_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)7.0, (double)2.5, (double)12.0, (double)9.0, (double)7.5, (double)14.0), (VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0));
    protected static final VoxelShape EAST_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)12.0, (double)2.5, (double)7.0, (double)14.0, (double)7.5, (double)9.0), (VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0));
    protected static final VoxelShape WEST_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)2.5, (double)7.0, (double)4.0, (double)7.5, (double)9.0), (VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0));
    @Nullable
    private final Supplier<Item> mugItem;

    public MugBlock(@Nullable Supplier<Item> mugItem, BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.mugItem = mugItem;
    }

    public MugBlock(BlockBehaviour.Properties settings) {
        this(null, settings);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item;
        Item item2 = item = this.mugItem == null ? null : this.mugItem.get();
        if (item instanceof AbstractDrinkableMugItem && !state.m_60713_((Block)FrozenUpBlocks.EMPTY_MUG.get())) {
            item.m_5922_(new ItemStack((ItemLike)item), world, (LivingEntity)player);
            world.m_46597_(pos, (BlockState)((Block)FrozenUpBlocks.EMPTY_MUG.get()).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
            if (!world.f_46443_) {
                world.m_6269_(null, (Entity)player, (SoundEvent)FrozenUpSoundEvents.ITEM_MUG_DRINK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> SHAPE;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        Player player = ctx.m_43723_();
        HumanoidArm arm = player != null ? player.m_5737_() : HumanoidArm.RIGHT;
        HumanoidArm activeArm = ctx.m_43724_() == InteractionHand.MAIN_HAND ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
        Direction facing = ctx.m_8125_();
        return state == null ? null : (BlockState)state.m_61124_((Property)FACING, (Comparable)(arm == HumanoidArm.RIGHT && activeArm == HumanoidArm.RIGHT || arm == HumanoidArm.LEFT && activeArm == HumanoidArm.LEFT ? facing.m_122427_() : facing.m_122428_()));
    }
}

