/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass.model;

import com.mojang.math.Vector3f;
import com.supermartijn642.connectedglass.CGPaneBlock;
import com.supermartijn642.connectedglass.ClientProxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.registries.ForgeRegistries;

public class CGPaneBakedModel
implements IDynamicBakedModel {
    private static final FaceBakery BAKERY = new FaceBakery();
    private final CGPaneBlock pane;

    public CGPaneBakedModel(CGPaneBlock pane) {
        this.pane = pane;
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransforms m_7442_() {
        return Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation(ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50069_), "")).m_7442_();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        Direction[] directionArray;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (side == null) {
            directionArray = Direction.values();
        } else {
            Direction[] directionArray2 = new Direction[1];
            directionArray = directionArray2;
            directionArray2[0] = side;
        }
        Direction[] sides = directionArray;
        boolean culling = side != null;
        for (Direction side2 : sides) {
            quads.addAll(this.getPostQuad(side2, culling, this.isEnabledUp(null, extraData), this.isEnabledDown(null, extraData)));
            float[] uv = this.getUV(side2, extraData);
            for (Direction part : Direction.Plane.HORIZONTAL) {
                quads.addAll(this.getPartQuad(state, part, side2, uv, culling, this.isEnabledUp(part, extraData), this.isEnabledDown(part, extraData)));
            }
        }
        return quads;
    }

    protected TextureAtlasSprite getTexture() {
        return ClientProxy.TEXTURES.get((Object)this.pane.block);
    }

    protected float[] getUV(Direction side, ModelData modelData) {
        if (side == Direction.UP || side == Direction.DOWN) {
            return this.getBorderUV();
        }
        return new float[]{0.0f, 0.0f, 16.0f, 16.0f};
    }

    protected List<BakedQuad> getPostQuad(Direction side, boolean culling, boolean isEnabledUp, boolean isEnabledDown) {
        boolean hasCulling;
        if (side.m_122434_() != Direction.Axis.Y) {
            return Collections.emptyList();
        }
        boolean bl = hasCulling = side == Direction.UP ? isEnabledUp : isEnabledDown;
        if (hasCulling != culling) {
            return Collections.emptyList();
        }
        Vector3f from = new Vector3f(7.0f, 0.0f, 7.0f);
        Vector3f to = new Vector3f(9.0f, 16.0f, 9.0f);
        float[] uv = new float[]{0.875f, 14.875f, 1.125f, 15.125f};
        BlockElementFace face = new BlockElementFace((Direction)(hasCulling ? side : null), -1, "", new BlockFaceUV(uv, 0));
        BakedQuad quad = BAKERY.m_111600_(from, to, face, this.getTexture(), side, (ModelState)BlockModelRotation.X0_Y0, null, true, null);
        return Collections.singletonList(quad);
    }

    protected List<BakedQuad> getPartQuad(BlockState state, Direction part, Direction side, float[] totalUV, boolean culling, boolean isEnabledUp, boolean isEnabledDown) {
        BooleanProperty property;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        float unitW = (totalUV[2] - totalUV[0]) / 16.0f;
        float unitH = (totalUV[3] - totalUV[1]) / 16.0f;
        Object object = part == Direction.NORTH ? CrossCollisionBlock.f_52309_ : (part == Direction.EAST ? CrossCollisionBlock.f_52310_ : (part == Direction.SOUTH ? CrossCollisionBlock.f_52311_ : (property = part == Direction.WEST ? CrossCollisionBlock.f_52312_ : null)));
        if (state == null && (part == Direction.NORTH || part == Direction.SOUTH) || state != null && ((Boolean)state.m_61143_((Property)property)).booleanValue()) {
            boolean hasQuad = true;
            float[] uv = new float[]{};
            boolean hasCulling = false;
            int rotation = 0;
            if (side == Direction.UP || side == Direction.DOWN) {
                hasCulling = side == Direction.UP ? isEnabledUp : isEnabledDown;
                uv = part == Direction.NORTH || part == Direction.EAST ? new float[]{totalUV[0] + 7.0f * unitW, totalUV[1], totalUV[0] + 9.0f * unitW, totalUV[1] + 7.0f * unitH} : new float[]{totalUV[0] + 7.0f * unitW, totalUV[1] + 9.0f * unitH, totalUV[0] + 9.0f * unitW, totalUV[3]};
                if (part.m_122434_() == Direction.Axis.X) {
                    rotation = 90;
                }
            } else if (side.m_122424_() == part) {
                hasQuad = false;
            } else if (side == part) {
                uv = this.getBorderUV();
                uv[0] = uv[0] + 7.0f * unitW;
                uv[2] = uv[2] - 7.0f * unitW;
                hasCulling = true;
            } else if (side.m_122428_() == part) {
                uv = new float[]{totalUV[0] + 9.0f * unitW, totalUV[1], totalUV[2], totalUV[3]};
            } else if (side.m_122427_() == part) {
                uv = new float[]{totalUV[0], totalUV[1], totalUV[0] + 7.0f * unitW, totalUV[3]};
            }
            if (hasQuad && hasCulling == culling) {
                Vector3f from = this.getPartFromPos(part);
                Vector3f to = this.getPartToPos(part);
                BlockElementFace face = new BlockElementFace((Direction)(hasCulling ? side : null), -1, "", new BlockFaceUV(uv, rotation));
                quads.add(BAKERY.m_111600_(from, to, face, this.getTexture(), side, (ModelState)BlockModelRotation.X0_Y0, null, true, null));
            }
        } else if (side == part && !culling) {
            Vector3f from = new Vector3f(7.0f, 0.0f, 7.0f);
            Vector3f to = new Vector3f(9.0f, 16.0f, 9.0f);
            float[] uv = new float[]{totalUV[0] + 7.0f * unitW, totalUV[1], totalUV[0] + 9.0f * unitH, totalUV[3]};
            BlockElementFace face = new BlockElementFace(null, -1, "", new BlockFaceUV(uv, 0));
            quads.add(BAKERY.m_111600_(from, to, face, this.getTexture(), side, (ModelState)BlockModelRotation.X0_Y0, null, true, null));
        }
        return quads;
    }

    private Vector3f getPartFromPos(Direction part) {
        if (part == Direction.NORTH) {
            return new Vector3f(7.0f, 0.0f, 0.0f);
        }
        if (part == Direction.EAST) {
            return new Vector3f(9.0f, 0.0f, 7.0f);
        }
        if (part == Direction.SOUTH) {
            return new Vector3f(7.0f, 0.0f, 9.0f);
        }
        if (part == Direction.WEST) {
            return new Vector3f(0.0f, 0.0f, 7.0f);
        }
        return null;
    }

    private Vector3f getPartToPos(Direction part) {
        if (part == Direction.NORTH) {
            return new Vector3f(9.0f, 16.0f, 7.0f);
        }
        if (part == Direction.EAST) {
            return new Vector3f(16.0f, 16.0f, 9.0f);
        }
        if (part == Direction.SOUTH) {
            return new Vector3f(9.0f, 16.0f, 16.0f);
        }
        if (part == Direction.WEST) {
            return new Vector3f(7.0f, 16.0f, 9.0f);
        }
        return null;
    }

    protected float[] getBorderUV() {
        return new float[]{0.0f, 0.0f, 16.0f, 16.0f};
    }

    protected boolean isEnabledUp(Direction part, ModelData extraData) {
        return false;
    }

    protected boolean isEnabledDown(Direction part, ModelData extraData) {
        return false;
    }
}

