/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass;

import com.supermartijn642.connectedglass.CGDummyBlockStateProvider;
import com.supermartijn642.connectedglass.CGDummyItemModelProvider;
import com.supermartijn642.connectedglass.CGGlassBlock;
import com.supermartijn642.connectedglass.CGGlassType;
import com.supermartijn642.connectedglass.CGPaneBlock;
import com.supermartijn642.connectedglass.data.CGBlockTagProvider;
import com.supermartijn642.connectedglass.data.CGChiselingRecipeProvider;
import com.supermartijn642.connectedglass.data.CGItemTagProvider;
import com.supermartijn642.connectedglass.data.CGLootTableProvider;
import com.supermartijn642.connectedglass.data.CGRecipeProvider;
import com.supermartijn642.connectedglass.data.CGTagProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="connectedglass")
public class ConnectedGlass {
    public static final List<CGGlassBlock> BLOCKS = new ArrayList<CGGlassBlock>();
    public static final List<CGPaneBlock> PANES = new ArrayList<CGPaneBlock>();
    public static final CreativeModeTab GROUP = new CreativeModeTab("connectedglass"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)CGGlassType.BORDERLESS_GLASS.block);
        }
    };

    @Mod.EventBusSubscriber(modid="connectedglass", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onRegisterEvent(RegisterEvent e) {
            if (e.getRegistryKey().equals((Object)ForgeRegistries.Keys.BLOCKS)) {
                RegistryEvents.onBlockRegistry((IForgeRegistry<Block>)Objects.requireNonNull(e.getForgeRegistry()));
            } else if (e.getRegistryKey().equals((Object)ForgeRegistries.Keys.ITEMS)) {
                RegistryEvents.onItemRegistry((IForgeRegistry<Item>)Objects.requireNonNull(e.getForgeRegistry()));
            }
        }

        public static void onBlockRegistry(IForgeRegistry<Block> registry) {
            for (CGGlassType type : CGGlassType.values()) {
                type.init();
                BLOCKS.addAll(type.blocks);
                if (!type.hasPanes) continue;
                PANES.addAll(type.panes);
            }
            for (CGGlassBlock block : BLOCKS) {
                registry.register(block.getRegistryName(), (Object)block);
            }
            for (CGPaneBlock pane : PANES) {
                registry.register(pane.getRegistryName(), (Object)pane);
            }
        }

        public static void onItemRegistry(IForgeRegistry<Item> registry) {
            for (CGGlassBlock block : BLOCKS) {
                RegistryEvents.registerItemBlock(registry, block.getRegistryName(), (Block)block);
            }
            for (CGPaneBlock pane : PANES) {
                RegistryEvents.registerItemBlock(registry, pane.getRegistryName(), (Block)pane);
            }
        }

        private static void registerItemBlock(IForgeRegistry<Item> registry, ResourceLocation registryName, Block block) {
            registry.register(registryName, (Object)new BlockItem(block, new Item.Properties().m_41491_(GROUP)));
        }

        @SubscribeEvent
        public static void registerDataProviders(GatherDataEvent e) {
            if (e.includeServer()) {
                e.getGenerator().m_236039_(true, (DataProvider)new CGRecipeProvider(e.getGenerator()));
                CGTagProvider.init();
                CGBlockTagProvider blockTagProvider = new CGBlockTagProvider(e.getGenerator(), e.getExistingFileHelper());
                e.getGenerator().m_236039_(true, (DataProvider)blockTagProvider);
                e.getGenerator().m_236039_(true, (DataProvider)new CGItemTagProvider(e.getGenerator(), blockTagProvider, e.getExistingFileHelper()));
                e.getGenerator().m_236039_(true, (DataProvider)new CGLootTableProvider(e.getGenerator()));
                e.getGenerator().m_236039_(true, (DataProvider)new CGChiselingRecipeProvider(e.getGenerator(), e.getExistingFileHelper()));
            }
            if (e.includeClient()) {
                e.getGenerator().m_236039_(true, (DataProvider)new CGDummyBlockStateProvider(e.getGenerator(), e.getExistingFileHelper()));
                e.getGenerator().m_236039_(true, (DataProvider)new CGDummyItemModelProvider(e.getGenerator(), e.getExistingFileHelper()));
            }
        }
    }
}

