/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.common.item;

import fonnymunkey.simplehats.SimpleHats;
import fonnymunkey.simplehats.common.init.ModConfig;
import fonnymunkey.simplehats.common.init.ModRegistry;
import fonnymunkey.simplehats.common.item.HatItem;
import fonnymunkey.simplehats.util.HatEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BagItem
extends Item {
    private HatEntry.HatSeason hatSeason = HatEntry.HatSeason.NONE;
    private boolean seasonal = false;
    private Rarity rarity = Rarity.COMMON;
    private List<HatItem> availableHatList = new ArrayList<HatItem>();
    private WeightedListInt availableHatListWeighted = null;

    public BagItem(Rarity rarity) {
        super(new Item.Properties().m_41497_(rarity).m_41491_(ModRegistry.HAT_TAB));
        this.rarity = rarity;
    }

    public BagItem(HatEntry.HatSeason hatSeason) {
        super(new Item.Properties().m_41497_(Rarity.EPIC).m_41491_(ModRegistry.HAT_TAB));
        this.hatSeason = hatSeason;
        this.seasonal = true;
        this.rarity = Rarity.EPIC;
    }

    public static SoundEvent getUnwrapFinishSound() {
        return SoundEvents.f_11675_;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        player.m_5496_(BagItem.getUnwrapFinishSound(), 1.0f, 1.0f + (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.4f);
        itemStack.m_41774_(1);
        if (!level.f_46443_) {
            if (!this.seasonal && HatEntry.HatSeason.getSeason() != HatEntry.HatSeason.NONE && (double)level.m_213780_().m_188501_() < (Double)ModConfig.COMMON.seasonalBagChance.get()) {
                player.m_19998_((ItemLike)BagItem.getSeasonalBag());
            }
            player.m_19998_(this.getBagResult(level));
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    private static Item getSeasonalBag() {
        switch (HatEntry.HatSeason.getSeason()) {
            case EASTER: {
                return (Item)ModRegistry.HATBAG_EASTER.get();
            }
            case SUMMER: {
                return (Item)ModRegistry.HATBAG_SUMMER.get();
            }
            case HALLOWEEN: {
                return (Item)ModRegistry.HATBAG_HALLOWEEN.get();
            }
            case FESTIVE: {
                return (Item)ModRegistry.HATBAG_FESTIVE.get();
            }
        }
        SimpleHats.logger.log(org.apache.logging.log4j.Level.ERROR, "Failed to get seasonal bag type.");
        return Items.f_41852_;
    }

    private ItemLike getBagResult(Level level) {
        if (this.availableHatList.size() == 0) {
            for (HatItem hat : ModRegistry.hatList) {
                if (hat.getHatEntry().getHatRarity() != this.rarity && !this.seasonal || hat.getHatEntry().getHatWeight() == 0 || hat.getHatEntry().getHatSeason() != this.hatSeason) continue;
                this.availableHatList.add(hat);
            }
            if (this.availableHatList.size() == 0) {
                SimpleHats.logger.log(org.apache.logging.log4j.Level.ERROR, "Failed to populate " + (this.seasonal ? this.hatSeason : this.rarity) + " loot list.");
                return Items.f_41852_;
            }
        }
        if (this.availableHatListWeighted == null) {
            try {
                SimpleWeightedRandomList.Builder<IntProvider> tempListBuilder = this.generateSimpleWeightedList((SimpleWeightedRandomList.Builder<IntProvider>)SimpleWeightedRandomList.m_146263_().m_146271_((Object)ConstantInt.m_146483_((int)0), this.availableHatList.get(0).getHatEntry().getHatWeight()), 1);
                this.availableHatListWeighted = new WeightedListInt(tempListBuilder.m_146270_());
            }
            catch (Exception ex) {
                SimpleHats.logger.log(org.apache.logging.log4j.Level.ERROR, "Failed to generate " + (this.seasonal ? this.hatSeason : this.rarity) + " weighted loot table: " + ex);
                return Items.f_41852_;
            }
        }
        return (ItemLike)this.availableHatList.get(this.availableHatListWeighted.m_214085_(level.f_46441_));
    }

    private SimpleWeightedRandomList.Builder<IntProvider> generateSimpleWeightedList(SimpleWeightedRandomList.Builder<IntProvider> list, int i) {
        if (i < this.availableHatList.size()) {
            list.m_146271_((Object)ConstantInt.m_146483_((int)i), this.availableHatList.get(i).getHatEntry().getHatWeight());
            list = this.generateSimpleWeightedList(list, ++i);
        }
        return list;
    }
}

