/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.common;

import fonnymunkey.simplehats.SimpleHats;
import fonnymunkey.simplehats.common.entity.HatDisplay;
import fonnymunkey.simplehats.common.init.HatJson;
import fonnymunkey.simplehats.common.init.ModRegistry;
import fonnymunkey.simplehats.common.item.HatItem;
import fonnymunkey.simplehats.common.item.HatItemDyeable;
import fonnymunkey.simplehats.util.HatEntry;
import fonnymunkey.simplehats.util.UUIDHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.Level;
import top.theillusivec4.curios.api.event.CurioEquipEvent;

public class EventHandler {

    @Mod.EventBusSubscriber(modid="simplehats", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class EventHandlerForge {
        @SubscribeEvent
        public static void curioEquipEvent(CurioEquipEvent event) {
            LivingEntity livingEntity;
            if (event.getEntity().f_19853_.m_5776_() || event.isCanceled()) {
                return;
            }
            ItemStack stack = event.getStack();
            if (stack.m_41720_() == ModRegistry.HATSPECIAL.get() && (livingEntity = event.getSlotContext().entity()) instanceof Player) {
                Player player = (Player)livingEntity;
                CompoundTag tag = stack.m_41784_();
                tag.m_128405_("CustomModelData", UUIDHandler.getUUIDMap().getOrDefault(player.m_20149_(), 0).intValue());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="simplehats", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class EventHandlerMod {
        @SubscribeEvent
        public static void entityAttributeCreation(EntityAttributeCreationEvent event) {
            event.put((EntityType)ModRegistry.HATDISPLAYENTITY.get(), HatDisplay.createAttributes().m_22265_());
        }

        @SubscribeEvent
        public static void registerHats(RegisterEvent event) {
            if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.ITEMS)) {
                for (HatEntry entry : HatJson.getHatList()) {
                    HatItem hat = entry.getHatDyeSettings().getUseDye() ? new HatItemDyeable(entry) : new HatItem(entry);
                    event.register(ForgeRegistries.Keys.ITEMS, new ResourceLocation("simplehats", entry.getHatName()), () -> hat);
                    ModRegistry.hatList.add(hat);
                }
                SimpleHats.logger.log(Level.INFO, "Generated " + ModRegistry.hatList.size() + " hat items from hat entries.");
            }
        }
    }
}

