/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.world.level.block.entity;

import fuzs.visualworkbench.init.ModRegistry;
import fuzs.visualworkbench.world.inventory.ModCraftingMenu;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CraftingTableBlockEntity
extends BaseContainerBlockEntity {
    private static final String LAST_RECIPE_ID_TAG = "LastRecipeId";
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private ItemStack lastResult = ItemStack.f_41583_;
    public int combinedLight;
    public int ticks;
    public float currentAngle;
    public float nextAngle;
    private byte sector;
    private boolean animating;
    private float animationAngleStart;
    private float animationAngleEnd;
    private double startTicks;
    private double playerAngle;

    public CraftingTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.CRAFTING_TABLE_BLOCK_ENTITY.get(), pos, state);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.crafting");
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.clear();
        ContainerHelper.m_18980_((CompoundTag)tag, this.inventory);
        this.lastResult = ItemStack.m_41712_((CompoundTag)tag.m_128469_(LAST_RECIPE_ID_TAG));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18976_((CompoundTag)tag, this.inventory, (boolean)true);
        CompoundTag compoundTag = new CompoundTag();
        this.lastResult.m_41739_(compoundTag);
        tag.m_128365_(LAST_RECIPE_ID_TAG, (Tag)compoundTag);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return index >= 0 && index < this.inventory.size() ? (ItemStack)this.inventory.get(index) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.inventory, (int)index, (int)count);
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack itemStack = ContainerHelper.m_18966_(this.inventory, (int)index);
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index >= 0 && index < this.inventory.size()) {
            this.inventory.set(index, (Object)stack);
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        if (this.m_58904_().m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInventory) {
        return new ModCraftingMenu(id, playerInventory, (Container)this, ContainerLevelAccess.m_39289_((Level)this.m_58904_(), (BlockPos)this.m_58899_()), this::setLastResult);
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public ItemStack getLastResult() {
        return this.lastResult;
    }

    private void setLastResult(ItemStack lastResult) {
        this.lastResult = lastResult.m_41619_() ? ItemStack.f_41583_ : lastResult;
        this.m_6596_();
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, CraftingTableBlockEntity pBlockEntity) {
        byte sector;
        if (pBlockEntity.m_7983_()) {
            return;
        }
        pBlockEntity.combinedLight = pBlockEntity.m_58904_() != null ? CraftingTableBlockEntity.getLightColor((BlockAndTintGetter)pLevel, pBlockEntity.m_58899_().m_7494_()) : 0xF000F0;
        ++pBlockEntity.ticks;
        Player playerentity = pLevel.m_45924_((double)pBlockEntity.f_58858_.m_123341_() + 0.5, (double)pBlockEntity.f_58858_.m_123342_() + 0.5, (double)pBlockEntity.f_58858_.m_123343_() + 0.5, 3.0, false);
        if (playerentity != null) {
            double d0 = playerentity.m_20185_() - ((double)pBlockEntity.f_58858_.m_123341_() + 0.5);
            double d1 = playerentity.m_20189_() - ((double)pBlockEntity.f_58858_.m_123343_() + 0.5);
            pBlockEntity.playerAngle = (Math.atan2(-d0, -d1) + 3.9269908169872414) % (Math.PI * 2);
        }
        if (pBlockEntity.sector != (sector = (byte)(pBlockEntity.playerAngle * 2.0 / Math.PI))) {
            pBlockEntity.animating = true;
            pBlockEntity.animationAngleStart = pBlockEntity.currentAngle;
            float delta1 = (float)sector * 90.0f - pBlockEntity.currentAngle;
            float abs1 = Math.abs(delta1);
            float delta2 = delta1 + 360.0f;
            float shift = Math.abs(delta2);
            float delta3 = delta1 - 360.0f;
            float abs3 = Math.abs(delta3);
            pBlockEntity.animationAngleEnd = abs3 < abs1 && abs3 < shift ? delta3 + pBlockEntity.currentAngle : (shift < abs1 && shift < abs3 ? delta2 + pBlockEntity.currentAngle : delta1 + pBlockEntity.currentAngle);
            pBlockEntity.startTicks = pBlockEntity.ticks;
            pBlockEntity.sector = sector;
        }
        if (pBlockEntity.animating) {
            if ((double)pBlockEntity.ticks >= pBlockEntity.startTicks + 20.0) {
                pBlockEntity.animating = false;
                pBlockEntity.currentAngle = pBlockEntity.nextAngle = (pBlockEntity.animationAngleEnd + 360.0f) % 360.0f;
            } else {
                pBlockEntity.currentAngle = (CraftingTableBlockEntity.easeOutQuad((double)pBlockEntity.ticks - pBlockEntity.startTicks, pBlockEntity.animationAngleStart, pBlockEntity.animationAngleEnd - pBlockEntity.animationAngleStart, 20.0) + 360.0f) % 360.0f;
                pBlockEntity.nextAngle = (CraftingTableBlockEntity.easeOutQuad(Math.min((double)(pBlockEntity.ticks + 1) - pBlockEntity.startTicks, 20.0), pBlockEntity.animationAngleStart, pBlockEntity.animationAngleEnd - pBlockEntity.animationAngleStart, 20.0) + 360.0f) % 360.0f;
                if (pBlockEntity.currentAngle != 0.0f || pBlockEntity.nextAngle != 0.0f) {
                    if (pBlockEntity.currentAngle == 0.0f && pBlockEntity.nextAngle >= 180.0f) {
                        pBlockEntity.currentAngle = 360.0f;
                    }
                    if (pBlockEntity.nextAngle == 0.0f && pBlockEntity.currentAngle >= 180.0f) {
                        pBlockEntity.nextAngle = 360.0f;
                    }
                }
            }
        }
    }

    private static float easeOutQuad(double t, float b, float c, double d) {
        float z = (float)t / (float)d;
        return -c * z * (z - 2.0f) + b;
    }

    public static int getLightColor(BlockAndTintGetter displayReader, BlockPos pos) {
        return CraftingTableBlockEntity.getLightColor(displayReader, displayReader.m_8055_(pos), pos);
    }

    public static int getLightColor(BlockAndTintGetter displayReader, BlockState state, BlockPos pos) {
        int k;
        if (state.m_60788_((BlockGetter)displayReader, pos)) {
            return 0xF000F0;
        }
        int i = displayReader.m_45517_(LightLayer.SKY, pos);
        int j = displayReader.m_45517_(LightLayer.BLOCK, pos);
        if (j < (k = state.m_60791_())) {
            j = k;
        }
        return i << 20 | j << 4;
    }
}

