/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.network;

import de.markusbordihn.dailyrewards.data.RewardData;
import de.markusbordihn.dailyrewards.data.RewardUserData;
import de.markusbordihn.dailyrewards.network.message.MessageGeneralRewardsForCurrentMonth;
import de.markusbordihn.dailyrewards.network.message.MessageUserRewardsForCurrentMonth;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class NetworkHandler {
    protected static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    private static final String PROTOCOL_VERSION = "2";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("daily_rewards", "network"), () -> "2", "2"::equals, "2"::equals);
    private static int id = 0;

    protected NetworkHandler() {
    }

    public static void registerNetworkHandler(FMLCommonSetupEvent event) {
        log.info("{} Network Handler for {} with version {} ...", (Object)"\ud83d\udcb0 Register Daily Rewards", (Object)INSTANCE, (Object)PROTOCOL_VERSION);
        event.enqueueWork(() -> {
            INSTANCE.registerMessage(id++, MessageGeneralRewardsForCurrentMonth.class, (message, buffer) -> buffer.m_130079_(message.getData()), buffer -> new MessageGeneralRewardsForCurrentMonth(buffer.m_130260_()), MessageGeneralRewardsForCurrentMonth::handle);
            INSTANCE.registerMessage(id++, MessageUserRewardsForCurrentMonth.class, (message, buffer) -> {
                buffer.m_130079_(message.getData());
                buffer.writeInt(message.getRewardedDays());
                buffer.m_130070_(message.getLastRewardedDay());
            }, buffer -> new MessageUserRewardsForCurrentMonth(buffer.m_130260_(), buffer.readInt(), buffer.m_130277_()), MessageUserRewardsForCurrentMonth::handle);
        });
    }

    public static void syncGeneralRewardForCurrentMonth(ServerPlayer serverPlayer) {
        CompoundTag data = RewardData.get().getRewardsForCurrentMonthSyncData();
        if (serverPlayer != null && serverPlayer.m_20148_() != null && data != null && !data.m_128456_()) {
            log.debug("Sending general reward for current month to {}: {}", (Object)serverPlayer, (Object)data);
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MessageGeneralRewardsForCurrentMonth(data));
        }
    }

    public static void syncUserRewardForCurrentMonth(ServerPlayer serverPlayer) {
        if (serverPlayer == null || serverPlayer.m_20148_() == null) {
            return;
        }
        UUID uuid = serverPlayer.m_20148_();
        CompoundTag data = RewardUserData.get().getRewardsForCurrentMonthSyncData(uuid);
        int rewardedDays = RewardUserData.get().getRewardedDaysForCurrentMonth(uuid);
        String lastRewardedDay = RewardUserData.get().getLastRewardedDayForCurrentMonth(uuid);
        if (data != null && !data.m_128456_()) {
            log.debug("Sending user reward for current month to {}: {}", (Object)serverPlayer, (Object)data);
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MessageUserRewardsForCurrentMonth(data, rewardedDays, lastRewardedDay));
        }
    }
}

