/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.data;

import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RewardClientData {
    protected static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    private static List<ItemStack> generalRewardItems = new ArrayList<ItemStack>();
    private static List<ItemStack> userRewardItems = new ArrayList<ItemStack>();
    private static int userRewardedDays = 0;
    private static String userLastRewardedDay;

    protected RewardClientData() {
    }

    public static int getRewardedDaysForCurrentMonth() {
        return userRewardedDays;
    }

    public static void setRewardedDaysForCurrentMonth(int rewardedDays) {
        userRewardedDays = rewardedDays;
    }

    public static String getLastRewardedDayForCurrentMonth() {
        return userLastRewardedDay;
    }

    public static void setLastRewardedDayForCurrentMonth(String lastRewardedDay) {
        userLastRewardedDay = lastRewardedDay;
    }

    public static List<ItemStack> getGeneralRewardsForCurrentMonth() {
        return generalRewardItems;
    }

    public static void setGeneralRewardsForCurrentMonth(List<ItemStack> generalRewards) {
        generalRewardItems = generalRewards;
    }

    public static void setGeneralRewardsForCurrentMonth(String data) {
        CompoundTag compoundTag;
        try {
            compoundTag = TagParser.m_129359_((String)data);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new JsonSyntaxException("Invalid nbt tag: " + commandSyntaxException.getMessage());
        }
        if (compoundTag != null) {
            RewardClientData.setGeneralRewardsForCurrentMonth(compoundTag);
        }
    }

    public static void setGeneralRewardsForCurrentMonth(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("ItemList")) {
            ListTag itemListTag = compoundTag.m_128437_("ItemList", 10);
            generalRewardItems = new ArrayList<ItemStack>();
            for (int i = 0; i < itemListTag.size(); ++i) {
                generalRewardItems.add(ItemStack.m_41712_((CompoundTag)itemListTag.m_128728_(i)));
            }
        } else {
            log.error("Unable to load general rewards for current month data from {}!", (Object)compoundTag);
        }
    }

    public static List<ItemStack> getUserRewardsForCurrentMonth() {
        return userRewardItems;
    }

    public static void setUserRewardsForCurrentMonth(List<ItemStack> userRewards) {
        userRewardItems = userRewards;
    }

    public static void setUserRewardsForCurrentMonth(String data) {
        CompoundTag compoundTag;
        try {
            compoundTag = TagParser.m_129359_((String)data);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new JsonSyntaxException("Invalid nbt tag: " + commandSyntaxException.getMessage());
        }
        if (compoundTag != null) {
            RewardClientData.setUserRewardsForCurrentMonth(compoundTag);
        }
    }

    public static void setUserRewardsForCurrentMonth(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("ItemList")) {
            ListTag itemListTag = compoundTag.m_128437_("ItemList", 10);
            userRewardItems = new ArrayList<ItemStack>();
            for (int i = 0; i < itemListTag.size(); ++i) {
                userRewardItems.add(ItemStack.m_41712_((CompoundTag)itemListTag.m_128728_(i)));
            }
        } else {
            log.error("Unable to load user rewards for current month data from {}!", (Object)compoundTag);
        }
    }
}

