/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.dailyrewards.Constants;
import de.markusbordihn.dailyrewards.config.CommonConfig;
import de.markusbordihn.dailyrewards.item.ModItems;
import de.markusbordihn.dailyrewards.menu.RewardMenu;
import de.markusbordihn.dailyrewards.menu.slots.RewardSlot;
import de.markusbordihn.dailyrewards.menu.slots.TakeableRewardSlot;
import de.markusbordihn.dailyrewards.rewards.Rewards;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class RewardScreen
extends AbstractContainerScreen<RewardMenu> {
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    protected static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    private int rewardDaysForCurrentMonth = Rewards.getDaysCurrentMonth();
    private int rewardedDays = 0;
    private int rewardTimePerDay = 30;
    private int rewardTimePerDayInSeconds = this.rewardTimePerDay * 60 + 60;
    private int updateTicker = 0;
    private String nextRewardTimeString;
    private LocalPlayer localPlayer;
    private boolean reloadToClaim = false;
    private MutableComponent rewardScreenTitle;

    public RewardScreen(RewardMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
    }

    public void rendererTakeableRewardSlot(PoseStack poseStack, int x, int y) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_ICONS);
        poseStack.m_85836_();
        this.m_93228_(poseStack, x + 12, y - 5, 0, 0, 16, 16);
        poseStack.m_85849_();
    }

    public void renderRewardSlot(PoseStack poseStack, int x, int y) {
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        RewardScreen.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + 16), (int)(y + 18 + 8), (int)-2136298838);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
    }

    protected void renderNextTimeForReward(PoseStack poseStack, int x, int y) {
        if (this.reloadToClaim) {
            this.f_96547_.m_92889_(poseStack, (Component)Component.m_237115_((String)"text.daily_rewards.next_reward.reload"), (float)x + 15.0f, (float)y, 0xFF0000);
            return;
        }
        if ((this.updateTicker++ & 0x13) == 0) {
            int localPlayerTickCount = this.localPlayer != null ? this.localPlayer.f_19797_ : 0;
            String lastRewardedDay = ((RewardMenu)this.f_97732_).getLastRewardedDay();
            long nextRewardTime = Rewards.getCurrentYearMonthDay().equals(lastRewardedDay) ? Duration.between(LocalDateTime.now(), LocalDateTime.now().withHour(23).withMinute(59).withSecond(59)).toSeconds() + (long)this.rewardTimePerDayInSeconds : (long)(this.rewardTimePerDayInSeconds - localPlayerTickCount / 20);
            this.nextRewardTimeString = LocalTime.MIN.plusSeconds(nextRewardTime + 60L).toString();
            if (this.nextRewardTimeString.length() == 5) {
                this.nextRewardTimeString = this.nextRewardTimeString + ":00";
            }
            if ("00:00:00".equals(this.nextRewardTimeString)) {
                log.debug("Reload screen to be able to claim for day {} ...", (Object)(this.rewardedDays + 1));
                this.reloadToClaim = true;
            }
            if (this.updateTicker >= 20) {
                this.updateTicker = 0;
            }
        }
        this.f_96547_.m_92889_(poseStack, (Component)Component.m_237110_((String)"text.daily_rewards.next_reward.in", (Object[])new Object[]{this.nextRewardTimeString}), (float)x, (float)y, 0x666666);
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97727_ = 242;
        this.rewardedDays = ((RewardMenu)this.f_97732_).getRewardedDays();
        this.rewardScreenTitle = Component.m_237110_((String)"text.daily_rewards.reward_screen", (Object[])new Object[]{this.rewardedDays});
        this.localPlayer = Minecraft.m_91087_() != null ? Minecraft.m_91087_().f_91074_ : null;
        this.rewardTimePerDay = (Integer)RewardScreen.COMMON.rewardTimePerDay.get();
        this.rewardTimePerDayInSeconds = this.rewardTimePerDay * 60;
        this.f_97728_ = 8;
        this.f_97729_ = 6;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.f_97730_ = 8;
        this.f_97731_ = this.f_97727_ - 92;
    }

    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, x, y, partialTicks);
        for (int k = 0; k < ((RewardMenu)this.f_97732_).f_38839_.size(); ++k) {
            Slot slot = (Slot)((RewardMenu)this.f_97732_).f_38839_.get(k);
            if (slot instanceof TakeableRewardSlot && !slot.m_7993_().m_150930_((Item)ModItems.TAKEN_REWARD.get())) {
                this.rendererTakeableRewardSlot(poseStack, this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_);
                continue;
            }
            if (!(slot instanceof RewardSlot)) continue;
            this.renderRewardSlot(poseStack, this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_);
        }
        this.renderNextTimeForReward(poseStack, this.f_97735_ + 28, this.f_97736_ + 140);
        this.m_7025_(poseStack, x, y);
    }

    protected void m_7027_(PoseStack poseStack, int x, int y) {
        this.f_96547_.m_92889_(poseStack, (Component)this.rewardScreenTitle, (float)this.f_97728_, (float)this.f_97729_, 0x404040);
        this.f_96547_.m_92889_(poseStack, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, 0x404040);
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_GENERIC_54);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_ + 20, 0, 0, 176, 222);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, 176, 139);
        RewardScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 5), (int)(this.f_97736_ + 15), (float)3.0f, (float)64.0f, (int)165, (int)130, (int)255, (int)4096);
        int dayCounter = 1;
        for (int i = 0; i < 4; ++i) {
            int slotTopPos = this.f_97736_ + 2 + i * 31;
            for (int i2 = 0; i2 < 8; ++i2) {
                if (dayCounter > this.rewardDaysForCurrentMonth) continue;
                int slotLeftPos = this.f_97735_ + 7 + Math.round((float)i2 * 20.5f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_GENERIC_54);
                this.m_93228_(poseStack, slotLeftPos, slotTopPos + 26, 7, 17, 18, 18);
                this.m_93228_(poseStack, slotLeftPos, slotTopPos + 16, 7, 17, 18, 18);
                this.f_96547_.m_92883_(poseStack, "" + dayCounter, (float)slotLeftPos + (dayCounter < 10 ? 6.0f : 4.0f), (float)slotTopPos + 35.0f, 0x404040);
                ++dayCounter;
            }
        }
    }
}

