/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod.mixin;

import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;
import redstonedubstep.mods.vanishmod.misc.FieldHolder;
import redstonedubstep.mods.vanishmod.misc.SoundSuppressionHelper;

@Mixin(value={PlayerList.class})
public abstract class MixinPlayerList {
    @Inject(method={"placeNewPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastSystemMessage(Lnet/minecraft/network/chat/Component;Z)V")})
    public void onSendJoinMessage(Connection networkManager, ServerPlayer player, CallbackInfo ci) {
        if (VanishUtil.removeFromQueue(player.m_36316_().getName()) && !VanishUtil.isVanished((Entity)player)) {
            VanishUtil.toggleVanish(player);
        }
        FieldHolder.joiningPlayer = player;
    }

    @ModifyVariable(method={"broadcastChatMessage(Lnet/minecraft/network/chat/PlayerChatMessage;Lnet/minecraft/commands/CommandSourceStack;Lnet/minecraft/network/chat/ChatType$Bound;)V"}, at=@At(value="HEAD"), argsOnly=true)
    public ChatType.Bound redirectAsChatSender(ChatType.Bound original, PlayerChatMessage chatMessage, CommandSourceStack commandSource) {
        ServerPlayer player;
        Entity entity;
        if (((Boolean)VanishConfig.CONFIG.hidePlayerNameInChat.get()).booleanValue() && (entity = commandSource.m_81373_()) instanceof ServerPlayer && VanishUtil.isVanished((Entity)(player = (ServerPlayer)entity))) {
            return ChatType.m_240968_(VanishUtil.getChatTypeRegistryKey(original, (Player)player), (RegistryAccess)player.f_19853_.m_5962_(), (Component)Component.m_237113_((String)"vanished").m_130940_(ChatFormatting.GRAY));
        }
        return original;
    }

    @Inject(method={"broadcast"}, at={@At(value="HEAD")})
    public void onBroadcast(Player except, double x, double y, double z, double radius, ResourceKey<Level> dimension, Packet<?> packet, CallbackInfo callbackInfo) {
        if (((Boolean)VanishConfig.CONFIG.hidePlayersFromWorld.get()).booleanValue() && except != null && (packet instanceof ClientboundSoundPacket || packet instanceof ClientboundSoundEntityPacket || packet instanceof ClientboundLevelEventPacket)) {
            SoundSuppressionHelper.putSoundPacket(packet, except);
        }
    }
}

