/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod.misc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;

public class SoundSuppressionHelper {
    private static final Map<ServerPlayer, Pair<BlockPos, Entity>> vanishedPlayersAndHitResults = new HashMap<ServerPlayer, Pair<BlockPos, Entity>>();
    private static Pair<Packet<?>, Player> packetOrigin = null;

    public static boolean shouldCapturePlayers() {
        return (Boolean)VanishConfig.CONFIG.indirectSoundSuppression.get() != false || (Boolean)VanishConfig.CONFIG.indirectParticleSuppression.get() != false;
    }

    public static void updateVanishedPlayerMap(ServerPlayer player, boolean vanished) {
        if (vanished) {
            vanishedPlayersAndHitResults.put(player, null);
        } else {
            vanishedPlayersAndHitResults.remove(player);
        }
        new HashSet<ServerPlayer>(vanishedPlayersAndHitResults.keySet()).stream().filter(Entity::m_213877_).forEach(vanishedPlayersAndHitResults::remove);
    }

    public static void updateBlockHitResult(ServerPlayer player, BlockHitResult hitResult) {
        if (VanishUtil.isVanished((Entity)player)) {
            Pair<BlockPos, Entity> oldHitResults = vanishedPlayersAndHitResults.get(player);
            vanishedPlayersAndHitResults.put(player, (Pair<BlockPos, Entity>)(oldHitResults == null ? Pair.of((Object)hitResult.m_82425_(), null) : Pair.of((Object)hitResult.m_82425_(), (Object)((Entity)oldHitResults.getRight()))));
        }
    }

    public static void updateEntityHitResult(ServerPlayer player, Entity hitEntity) {
        if (VanishUtil.isVanished((Entity)player)) {
            vanishedPlayersAndHitResults.put(player, (Pair<BlockPos, Entity>)Pair.of((Object)hitEntity.m_20183_(), (Object)hitEntity));
        }
    }

    public static void invalidateHitResults(ServerPlayer player) {
        if (VanishUtil.isVanished((Entity)player)) {
            vanishedPlayersAndHitResults.put(player, null);
        }
    }

    public static void putSoundPacket(Packet<?> packet, Player player) {
        packetOrigin = Pair.of(packet, (Object)player);
    }

    public static Player getPlayerForPacket(Packet<?> packet) {
        return packetOrigin != null && ((Packet)packetOrigin.getLeft()).equals(packet) ? (Player)packetOrigin.getRight() : null;
    }

    public static boolean shouldSuppressSoundEventFor(Player player, Level level, double x, double y, double z, Player forPlayer) {
        return SoundSuppressionHelper.shouldSuppressSoundEventFor(player, level, new Vec3(x, y, z), forPlayer);
    }

    public static boolean shouldSuppressSoundEventFor(Player player, Level level, Vec3 soundOrigin, Player forPlayer) {
        if (VanishUtil.isVanished((Entity)player, (Entity)forPlayer)) {
            return true;
        }
        if (!((Boolean)VanishConfig.CONFIG.indirectSoundSuppression.get()).booleanValue() || VanishUtil.canSeeVanishedPlayers((Entity)forPlayer)) {
            return false;
        }
        return SoundSuppressionHelper.areVanishedPlayersAt(level, soundOrigin) || SoundSuppressionHelper.vanishedPlayerVehicleAt(level, soundOrigin) || SoundSuppressionHelper.vanishedPlayersInteractWith(level, new BlockPos(soundOrigin));
    }

    public static boolean shouldSuppressSoundEventFor(Player player, Level level, Entity soundOrigin, Player forPlayer) {
        if (VanishUtil.isVanished((Entity)player, (Entity)forPlayer)) {
            return true;
        }
        if (!((Boolean)VanishConfig.CONFIG.indirectSoundSuppression.get()).booleanValue() || VanishUtil.canSeeVanishedPlayers((Entity)forPlayer)) {
            return false;
        }
        return SoundSuppressionHelper.areVanishedPlayersAt(level, soundOrigin.m_20182_()) || SoundSuppressionHelper.isVanishedPlayerVehicle(soundOrigin) || SoundSuppressionHelper.vanishedPlayersInteractWith(level, soundOrigin);
    }

    public static boolean shouldSuppressParticlesFor(Player player, Level level, double x, double y, double z, Player forPlayer) {
        Vec3 soundOrigin = new Vec3(x, y, z);
        if (VanishUtil.isVanished((Entity)player, (Entity)forPlayer)) {
            return true;
        }
        if (!((Boolean)VanishConfig.CONFIG.indirectParticleSuppression.get()).booleanValue() || VanishUtil.canSeeVanishedPlayers((Entity)forPlayer)) {
            return false;
        }
        return SoundSuppressionHelper.areVanishedPlayersAt(level, soundOrigin) || SoundSuppressionHelper.vanishedPlayerVehicleAt(level, soundOrigin) || SoundSuppressionHelper.vanishedPlayersInteractWith(level, new BlockPos(soundOrigin));
    }

    public static boolean areVanishedPlayersAt(Level level, Vec3 pos) {
        VoxelShape shape = Shapes.m_83144_().m_83216_(pos.f_82479_ - 0.5, pos.f_82480_ - 0.5, pos.f_82481_ - 0.5);
        return vanishedPlayersAndHitResults.keySet().stream().filter(p -> p.f_19853_.equals(level) && p.f_8941_.m_9290_() != GameType.SPECTATOR).anyMatch(p -> Shapes.m_83157_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)p.m_20191_()), (BooleanOp)BooleanOp.f_82689_));
    }

    public static boolean vanishedPlayerVehicleAt(Level level, Vec3 pos) {
        VoxelShape shape = Shapes.m_83144_().m_83216_(pos.f_82479_ - 0.5, pos.f_82480_ - 0.5, pos.f_82481_ - 0.5);
        return vanishedPlayersAndHitResults.keySet().stream().filter(p -> p.f_19853_.equals(level) && p.f_8941_.m_9290_() != GameType.SPECTATOR).map(Entity::m_20202_).filter(Objects::nonNull).anyMatch(v -> Shapes.m_83157_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)v.m_20191_()), (BooleanOp)BooleanOp.f_82689_));
    }

    public static boolean isVanishedPlayerVehicle(Entity entity) {
        return vanishedPlayersAndHitResults.keySet().stream().anyMatch(p -> p.f_8941_.m_9290_() != GameType.SPECTATOR && entity.equals((Object)p.m_20202_()));
    }

    public static boolean vanishedPlayersInteractWith(Level level, BlockPos pos) {
        return vanishedPlayersAndHitResults.entrySet().stream().filter(e -> ((ServerPlayer)e.getKey()).f_19853_.equals(level)).anyMatch(p -> p.getValue() != null && SoundSuppressionHelper.equalsThisOrConnected(pos, level, (BlockPos)((Pair)p.getValue()).getLeft()));
    }

    public static boolean vanishedPlayersInteractWith(Level level, Entity entity) {
        return vanishedPlayersAndHitResults.entrySet().stream().filter(e -> ((ServerPlayer)e.getKey()).f_19853_.equals(level)).anyMatch(p -> p.getValue() != null && entity.equals(((Pair)p.getValue()).getRight()));
    }

    public static boolean equalsThisOrConnected(BlockPos soundPos, Level level, BlockPos interactPos) {
        BlockState state;
        if (soundPos.equals((Object)interactPos)) {
            return true;
        }
        if (interactPos != null && (state = level.m_8055_(interactPos)).m_60734_() instanceof ChestBlock) {
            return soundPos.equals((Object)interactPos.m_121945_(ChestBlock.m_51584_((BlockState)state)));
        }
        return false;
    }
}

