/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.api.PlayerVanishEvent;
import redstonedubstep.mods.vanishmod.compat.Mc2DiscordCompat;
import redstonedubstep.mods.vanishmod.misc.SoundSuppressionHelper;

public class VanishUtil {
    public static final MutableComponent VANISHMOD_PREFIX = Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)"Vanishmod").m_130938_(s -> s.m_131157_(ChatFormatting.GRAY).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/vanishmod")))).m_7220_((Component)Component.m_237113_((String)"] ").m_130940_(ChatFormatting.WHITE));
    private static final Set<ServerPlayer> vanishedPlayers = new HashSet<ServerPlayer>();
    private static final Set<String> vanishingQueue = new HashSet<String>();

    public static List<? extends Entity> formatEntityList(List<? extends Entity> rawList, Entity forPlayer) {
        return rawList.stream().filter(entity -> {
            Player player;
            return !(entity instanceof Player) || !VanishUtil.isVanished((Entity)(player = (Player)entity), forPlayer);
        }).collect(Collectors.toList());
    }

    public static List<ServerPlayer> formatPlayerList(List<ServerPlayer> rawList, Entity forPlayer) {
        return rawList.stream().filter(player -> !VanishUtil.isVanished((Entity)player, forPlayer)).collect(Collectors.toList());
    }

    public static void toggleVanish(ServerPlayer player) {
        boolean vanishes = !VanishUtil.isVanished((Entity)player);
        String note = "Note: You can still see yourself in the tab list for technical reasons, but you are vanished for other players. \nNote: Be careful when producing noise near other players, because while most sounds will get suppressed, some won't due to technical limitations. \nNote: While vanished, only players that are able to see you will receive your chat messages. If you want to chat with everyone, use the /say command.";
        if (vanishes) {
            player.m_213846_((Component)VANISHMOD_PREFIX.m_6881_().m_130946_("Note: ").m_7220_((Component)Component.m_237113_((String)"(...)").m_130938_(s -> s.m_131157_(ChatFormatting.GRAY).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)note))))));
        }
        VanishUtil.sendJoinOrLeaveMessageToPlayers(player.m_9236_().m_7654_().m_6846_().m_11314_(), player, vanishes, false);
        VanishUtil.updateVanishedStatus(player, vanishes);
        VanishUtil.sendJoinOrLeaveMessageToPlayers(player.m_9236_().m_7654_().m_6846_().m_11314_(), player, vanishes, true);
        VanishUtil.sendPacketsOnVanish(player, player.m_9236_(), vanishes);
    }

    public static void sendPacketsOnVanish(ServerPlayer currentPlayer, ServerLevel world, boolean vanishes) {
        List list = world.m_7654_().m_6846_().m_11314_();
        ServerChunkCache chunkProvider = currentPlayer.m_9236_().m_7726_();
        for (ServerPlayer player : list) {
            if (player.equals((Object)currentPlayer)) continue;
            if (!VanishUtil.canSeeVanishedPlayers((Entity)player)) {
                player.f_8906_.m_9829_((Packet)new ClientboundPlayerInfoPacket(vanishes ? ClientboundPlayerInfoPacket.Action.REMOVE_PLAYER : ClientboundPlayerInfoPacket.Action.ADD_PLAYER, new ServerPlayer[]{currentPlayer}));
            }
            if (VanishUtil.isVanished((Entity)player)) {
                currentPlayer.f_8906_.m_9829_((Packet)new ClientboundPlayerInfoPacket(VanishUtil.canSeeVanishedPlayers((Entity)currentPlayer, vanishes) ? ClientboundPlayerInfoPacket.Action.ADD_PLAYER : ClientboundPlayerInfoPacket.Action.REMOVE_PLAYER, new ServerPlayer[]{player}));
            }
            if (!((Boolean)VanishConfig.CONFIG.hidePlayersFromWorld.get()).booleanValue()) continue;
            if (vanishes && !VanishUtil.canSeeVanishedPlayers((Entity)player)) {
                player.f_8906_.m_9829_((Packet)new ClientboundRemoveEntitiesPacket(new int[]{currentPlayer.m_19879_()}));
                continue;
            }
            if (!VanishUtil.isVanished((Entity)player) || VanishUtil.canSeeVanishedPlayers((Entity)currentPlayer, vanishes)) continue;
            currentPlayer.f_8906_.m_9829_((Packet)new ClientboundRemoveEntitiesPacket(new int[]{player.m_19879_()}));
        }
        if (chunkProvider.f_8325_.f_140150_.containsKey(currentPlayer.m_19879_())) {
            chunkProvider.f_8325_.f_140150_.remove(currentPlayer.m_19879_());
            chunkProvider.m_8463_((Entity)currentPlayer);
        }
        currentPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)VanishUtil.getVanishedStatusText(currentPlayer, vanishes)));
    }

    public static void sendJoinOrLeaveMessageToPlayers(List<ServerPlayer> playerList, ServerPlayer sender, boolean leaveMessage, boolean beforeStatusChange) {
        if (((Boolean)VanishConfig.CONFIG.sendFakeJoinLeaveMessages.get()).booleanValue() && leaveMessage != beforeStatusChange && sender.f_8924_.m_6846_().m_11314_().contains(sender)) {
            MutableComponent message = Component.m_237110_((String)(leaveMessage ? "multiplayer.player.left" : "multiplayer.player.joined"), (Object[])new Object[]{sender.m_5446_()}).m_130940_(ChatFormatting.YELLOW);
            for (ServerPlayer receiver : playerList) {
                receiver.m_213846_((Component)message);
            }
            if (ModList.get().isLoaded("mc2discord")) {
                Mc2DiscordCompat.sendFakeJoinLeaveMessage(sender, leaveMessage);
            }
        }
    }

    public static void updateVanishedStatus(ServerPlayer player, boolean vanished) {
        CompoundTag persistentData = player.getPersistentData();
        CompoundTag deathPersistentData = persistentData.m_128469_("PlayerPersisted");
        deathPersistentData.m_128379_("Vanished", vanished);
        persistentData.m_128365_("PlayerPersisted", (Tag)deathPersistentData);
        if (ModList.get().isLoaded("mc2discord")) {
            Mc2DiscordCompat.hidePlayer(player, vanished);
        }
        VanishUtil.updateVanishedPlayerList(player, vanished);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerVanishEvent((Player)player, vanished));
        player.refreshTabListName();
    }

    public static void updateVanishedPlayerList(ServerPlayer player, boolean vanished) {
        if (vanished) {
            vanishedPlayers.add(player);
        } else {
            vanishedPlayers.remove(player);
        }
        SoundSuppressionHelper.updateVanishedPlayerMap(player, vanished);
    }

    public static MutableComponent getVanishedStatusText(ServerPlayer player, boolean isVanished) {
        return Component.m_237110_((String)(isVanished ? (String)VanishConfig.CONFIG.onVanishQuery.get() : (String)VanishConfig.CONFIG.onUnvanishQuery.get()), (Object[])new Object[]{player.m_5446_()});
    }

    public static boolean addToQueue(String playerName) {
        return vanishingQueue.add(playerName);
    }

    public static boolean removeFromQueue(String playerName) {
        return vanishingQueue.remove(playerName);
    }

    public static boolean canSeeVanishedPlayers(Entity entity) {
        return VanishUtil.canSeeVanishedPlayers(entity, VanishUtil.isVanished(entity));
    }

    public static boolean canSeeVanishedPlayers(Entity entity, boolean isVanished) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return (Boolean)VanishConfig.CONFIG.vanishedPlayersSeeEachOther.get() != false && isVanished || (Integer)VanishConfig.CONFIG.seeVanishedPermissionLevel.get() >= 0 && player.m_20310_(((Integer)VanishConfig.CONFIG.seeVanishedPermissionLevel.get()).intValue());
        }
        return false;
    }

    public static ResourceKey<ChatType> getChatTypeRegistryKey(ChatType.Bound chatType, Player player) {
        return player.f_19853_.m_5962_().m_175515_(Registry.f_235730_).m_7854_((Object)chatType.f_240859_()).orElse(ChatType.f_130598_);
    }

    public static boolean isVanished(Entity player) {
        return VanishUtil.isVanished(player, null);
    }

    public static boolean isVanished(Entity player, Entity forPlayer) {
        if (player instanceof Player && !player.f_19853_.f_46443_) {
            boolean isVanished = player.getPersistentData().m_128469_("PlayerPersisted").m_128471_("Vanished");
            if (forPlayer != null) {
                if (player.equals((Object)forPlayer)) {
                    return false;
                }
                return isVanished && !VanishUtil.canSeeVanishedPlayers(forPlayer);
            }
            return isVanished;
        }
        return false;
    }
}

