/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.event.VanillaGameEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;
import redstonedubstep.mods.vanishmod.misc.FieldHolder;
import redstonedubstep.mods.vanishmod.misc.SoundSuppressionHelper;

@Mod.EventBusSubscriber(modid="vmod")
public class VanishEventListener {
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && VanishUtil.isVanished((Entity)(player = (ServerPlayer)player2))) {
            player.m_213846_((Component)VanishUtil.VANISHMOD_PREFIX.m_6881_().m_130946_("Note: You are currently vanished"));
            VanishUtil.updateVanishedPlayerList(player, true);
        }
        if (event.getEntity().equals((Object)FieldHolder.joiningPlayer)) {
            FieldHolder.joiningPlayer = null;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onTabListName(PlayerEvent.TabListNameFormat event) {
        if (VanishUtil.isVanished((Entity)event.getEntity())) {
            MutableComponent vanishedName = Component.m_237113_((String)"").m_130940_(ChatFormatting.ITALIC);
            vanishedName.m_7220_((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"Vanished").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)"] ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)(event.getDisplayName() == null ? PlayerTeam.m_83348_((Team)event.getEntity().m_5647_(), (Component)event.getEntity().m_7755_()) : event.getDisplayName()));
            event.setDisplayName((Component)vanishedName);
        }
    }

    @SubscribeEvent
    public static void onInteractBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player;
        if (SoundSuppressionHelper.shouldCapturePlayers() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.f_8941_.m_9290_() != GameType.SPECTATOR) {
                SoundSuppressionHelper.updateBlockHitResult(player2, event.getHitVec());
            }
        }
    }

    @SubscribeEvent
    public static void onInteractEntity(PlayerInteractEvent.EntityInteract event) {
        Player player;
        if (SoundSuppressionHelper.shouldCapturePlayers() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.f_8941_.m_9290_() != GameType.SPECTATOR) {
                SoundSuppressionHelper.updateEntityHitResult(player2, event.getTarget());
            }
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player;
        if (SoundSuppressionHelper.shouldCapturePlayers() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.f_8941_.m_9290_() != GameType.SPECTATOR) {
                SoundSuppressionHelper.updateEntityHitResult(player2, event.getTarget());
            }
        }
    }

    @SubscribeEvent
    public static void onChangeTarget(LivingChangeTargetEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity;
        if (((Boolean)VanishConfig.CONFIG.hidePlayersFromWorld.get()).booleanValue() && (livingEntity = event.getNewTarget()) instanceof ServerPlayer && VanishUtil.isVanished((Entity)(player = (ServerPlayer)livingEntity))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        EntityHitResult hitResult;
        HitResult hitResult2;
        if (((Boolean)VanishConfig.CONFIG.hidePlayersFromWorld.get()).booleanValue() && (hitResult2 = event.getRayTraceResult()) instanceof EntityHitResult && VanishUtil.isVanished((hitResult = (EntityHitResult)hitResult2).m_82443_(), event.getProjectile().m_37282_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onVanillaGameEvent(VanillaGameEvent event) {
        Entity entity = event.getCause();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (((Boolean)VanishConfig.CONFIG.hidePlayersFromWorld.get()).booleanValue() && VanishUtil.isVanished((Entity)player)) {
                event.setCanceled(true);
            }
        }
    }
}

