/*
 * Decompiled with CFR 0.152.
 */
package redstonedubstep.mods.vanishmod;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import redstonedubstep.mods.vanishmod.VanishConfig;
import redstonedubstep.mods.vanishmod.VanishUtil;

public class VanishCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register(VanishCommand.alias("v"));
        dispatcher.register(VanishCommand.alias("vanish"));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> alias(String prefix) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)prefix).requires(player -> player.m_6761_(((Integer)VanishConfig.CONFIG.vanishCommandPermissionLevel.get()).intValue()))).executes(ctx -> VanishCommand.vanish((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).m_81375_()))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"toggle").executes(ctx -> VanishCommand.vanish((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> VanishCommand.vanish((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").executes(ctx -> VanishCommand.getVanishedStatus((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> VanishCommand.getVanishedStatus((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"queue").executes(ctx -> VanishCommand.queue((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).m_81375_().m_36316_().getName()))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> VanishCommand.queue((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"player")))));
    }

    private static int vanish(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)VanishUtil.VANISHMOD_PREFIX.m_6881_().m_7220_((Component)Component.m_237110_((String)(!VanishUtil.isVanished((Entity)player) ? (String)VanishConfig.CONFIG.onVanishMessage.get() : (String)VanishConfig.CONFIG.onUnvanishMessage.get()), (Object[])new Object[]{player.m_5446_()})), true);
        VanishUtil.toggleVanish(player);
        return 1;
    }

    private static int getVanishedStatus(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        MutableComponent vanishedStatus = VanishUtil.getVanishedStatusText(player, VanishUtil.isVanished((Entity)player));
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)VanishUtil.VANISHMOD_PREFIX.m_6881_().m_7220_((Component)vanishedStatus), false);
        Entity entity = ((CommandSourceStack)ctx.getSource()).m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer currentPlayer = (ServerPlayer)entity;
            currentPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)vanishedStatus));
        }
        return 1;
    }

    private static int queue(CommandContext<CommandSourceStack> ctx, String playerName) {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11255_(playerName);
        if (player != null) {
            if (!VanishUtil.isVanished((Entity)player)) {
                VanishCommand.vanish(ctx, player);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)VanishUtil.VANISHMOD_PREFIX.m_6881_().m_7220_((Component)Component.m_237110_((String)"Could not add already vanished player %s to the vanishing queue", (Object[])new Object[]{playerName})));
            }
            return 1;
        }
        if (VanishUtil.removeFromQueue(playerName)) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)VanishUtil.VANISHMOD_PREFIX.m_6881_().m_7220_((Component)Component.m_237110_((String)"Removed %s from the vanishing queue", (Object[])new Object[]{playerName})), true);
        } else if (VanishUtil.addToQueue(playerName)) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)VanishUtil.VANISHMOD_PREFIX.m_6881_().m_7220_((Component)Component.m_237110_((String)"Added %s to the vanishing queue", (Object[])new Object[]{playerName})), true);
        }
        return 1;
    }
}

