/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.integration;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IScaleableGuiScreen;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.integration.ScreenEventListener;
import team.creative.creativecore.common.gui.packet.LayerOpenPacket;

public class GuiScreenIntegration
extends Screen
implements IGuiIntegratedParent,
IScaleableGuiScreen {
    public final Minecraft mc = Minecraft.m_91087_();
    private List<GuiLayer> layers = new ArrayList<GuiLayer>();
    protected ScreenEventListener listener;

    public GuiScreenIntegration(GuiLayer layer) {
        super((Component)Component.m_237113_((String)"gui-api"));
        layer.setParent(this);
        this.layers.add(layer);
        layer.init();
    }

    protected void m_7856_() {
        if (this.listener == null) {
            this.listener = new ScreenEventListener(this, this);
        }
        this.m_7787_(this.listener);
    }

    @Override
    public int getWidth() {
        int width = 0;
        for (GuiLayer layer : this.layers) {
            width = Math.max(width, layer.getWidth());
        }
        return width;
    }

    @Override
    public int getHeight() {
        int height = 0;
        for (GuiLayer layer : this.layers) {
            height = Math.max(height, layer.getHeight());
        }
        return height;
    }

    @Override
    public void clientTick() {
        for (GuiLayer layer : this.layers) {
            layer.tick();
        }
    }

    public void m_7861_() {
        for (GuiLayer layer : this.layers) {
            layer.closed();
        }
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public Player getPlayer() {
        return this.mc.f_91074_;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.render(stack, this, this.listener, mouseX, mouseY);
    }

    @Override
    public List<GuiLayer> getLayers() {
        return this.layers;
    }

    @Override
    public GuiLayer getTopLayer() {
        if (this.layers.isEmpty()) {
            return EMPTY;
        }
        return this.layers.get(this.layers.size() - 1);
    }

    @Override
    public void openLayer(GuiLayer layer) {
        layer.setParent(this);
        this.layers.add(layer);
        layer.init();
    }

    @Override
    public void closeLayer(GuiLayer layer) {
        int index = this.layers.indexOf(layer);
        if (index != -1) {
            this.closeLayer(index);
        }
    }

    @Override
    public void closeLayer(int layer) {
        for (int i = 0; i <= layer; ++i) {
            this.layers.get(i).closed();
        }
        this.layers = this.layers.subList(0, layer);
        if (this.layers.isEmpty()) {
            this.m_7379_();
        }
    }

    @Override
    public void closeTopLayer() {
        this.closeLayer(this.layers.size() - 1);
    }

    @Override
    public GuiLayer openLayer(LayerOpenPacket packet) {
        packet.executeClient(this.getPlayer());
        return this.layers.get(this.layers.size() - 1);
    }

    public void m_94757_(double x, double y) {
        this.listener.m_94757_(x, y);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.listener.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.listener.m_7920_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.listener.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }
}

