/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.server.entity;

import com.github.alexthe668.domesticationinnovation.server.entity.DIEntityRegistry;
import com.github.alexthe668.domesticationinnovation.server.entity.TameableUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class ChainLightningEntity
extends Entity {
    private static final EntityDataAccessor<Integer> CREATOR_ID = SynchedEntityData.m_135353_(ChainLightningEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FROM_ID = SynchedEntityData.m_135353_(ChainLightningEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TARGET_COUNT = SynchedEntityData.m_135353_(ChainLightningEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CURRENT_TARGET_ID = SynchedEntityData.m_135353_(ChainLightningEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DIES_IN = SynchedEntityData.m_135353_(ChainLightningEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private List<Entity> previouslyShocked = new ArrayList<Entity>();
    private boolean hasShocked = false;
    private boolean hasChained = false;

    public ChainLightningEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public ChainLightningEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType)DIEntityRegistry.CHAIN_LIGHTNING.get(), world);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CREATOR_ID, (Object)-1);
        this.f_19804_.m_135372_(FROM_ID, (Object)-1);
        this.f_19804_.m_135372_(TARGET_COUNT, (Object)1);
        this.f_19804_.m_135372_(CURRENT_TARGET_ID, (Object)-1);
        this.f_19804_.m_135372_(DIES_IN, (Object)5);
    }

    public void m_8119_() {
        super.m_8119_();
        Entity creator = this.getCreatorEntity();
        Entity current = this.getToEntity();
        if (creator instanceof LivingEntity && current != null) {
            this.m_146884_(new Vec3(current.m_20185_(), current.m_20186_() + (double)(current.m_20206_() * 0.5f), current.m_20189_()));
            if (!this.f_19853_.f_46443_ && !this.hasShocked) {
                this.hasShocked = true;
                current.m_6469_(DamageSource.f_19306_, 3.0f);
            }
        }
        if (!this.f_19853_.f_46443_) {
            if (!this.hasChained && this.getChainsLeft() > 0 && creator instanceof LivingEntity) {
                Entity closestValid = null;
                for (Entity entity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(8.0))) {
                    if (entity.equals((Object)creator) || TameableUtils.hasSameOwnerAs((LivingEntity)creator, entity) || this.previouslyShocked.contains(entity) || creator.m_7307_(entity) || !(entity instanceof Mob) || !this.hasLineOfSight(entity) || closestValid != null && !(this.m_20270_(entity) < this.m_20270_(closestValid))) continue;
                    closestValid = entity;
                }
                if (closestValid != null) {
                    this.createLightningAt(closestValid);
                    this.hasChained = true;
                }
            }
            if (this.getDiesInTicks() > 0) {
                this.setDiesInTicks(this.getDiesInTicks() - 1);
            } else {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private boolean hasLineOfSight(Entity entity) {
        if (entity.f_19853_ != this.f_19853_) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 vec31 = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return this.f_19853_.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    private void createLightningAt(Entity closestValid) {
        ChainLightningEntity child = (ChainLightningEntity)((EntityType)DIEntityRegistry.CHAIN_LIGHTNING.get()).m_20615_(this.f_19853_);
        child.previouslyShocked = new ArrayList<Entity>(this.previouslyShocked);
        child.previouslyShocked.add(closestValid);
        child.setCreatorEntityID(this.getCreatorEntityID());
        child.setFromEntityID(this.m_19879_());
        child.setToEntityID(closestValid.m_19879_());
        child.m_20359_(closestValid);
        child.setChainsLeft(this.getChainsLeft() - 1);
        this.f_19853_.m_7967_((Entity)child);
    }

    public int getCreatorEntityID() {
        return (Integer)this.f_19804_.m_135370_(CREATOR_ID);
    }

    public void setCreatorEntityID(int id) {
        this.f_19804_.m_135381_(CREATOR_ID, (Object)id);
    }

    public Entity getCreatorEntity() {
        return this.getCreatorEntityID() == -1 ? null : this.f_19853_.m_6815_(this.getCreatorEntityID());
    }

    public int getFromEntityID() {
        return (Integer)this.f_19804_.m_135370_(FROM_ID);
    }

    public void setFromEntityID(int id) {
        this.f_19804_.m_135381_(FROM_ID, (Object)id);
    }

    public Entity getFromEntity() {
        return this.getFromEntityID() == -1 ? null : this.f_19853_.m_6815_(this.getFromEntityID());
    }

    public int getToEntityID() {
        return (Integer)this.f_19804_.m_135370_(CURRENT_TARGET_ID);
    }

    public void setToEntityID(int id) {
        this.f_19804_.m_135381_(CURRENT_TARGET_ID, (Object)id);
    }

    public Entity getToEntity() {
        return this.getToEntityID() == -1 ? null : this.f_19853_.m_6815_(this.getToEntityID());
    }

    public int getChainsLeft() {
        return (Integer)this.f_19804_.m_135370_(TARGET_COUNT);
    }

    public void setChainsLeft(int i) {
        this.f_19804_.m_135381_(TARGET_COUNT, (Object)i);
    }

    public int getDiesInTicks() {
        return (Integer)this.f_19804_.m_135370_(DIES_IN);
    }

    public void setDiesInTicks(int i) {
        this.f_19804_.m_135381_(DIES_IN, (Object)i);
    }

    protected void m_7378_(CompoundTag p_20052_) {
    }

    protected void m_7380_(CompoundTag p_20139_) {
    }
}

