/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.server.block;

import com.github.alexthe668.domesticationinnovation.server.block.DITileEntityRegistry;
import com.github.alexthe668.domesticationinnovation.server.entity.TameableUtils;
import com.github.alexthe668.domesticationinnovation.server.misc.DIWorldData;
import com.github.alexthe668.domesticationinnovation.server.misc.LanternRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.world.ForgeChunkManager;

public class WaywardLanternBlockEntity
extends BlockEntity {
    private int checkAgainIn = 100;
    private int entityLoadTimeout = 0;
    private List<LanternRequest> workingRequests = new ArrayList<LanternRequest>();
    private List<UUID> finishedRequests = new ArrayList<UUID>();

    public WaywardLanternBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DITileEntityRegistry.WAYWARD_LANTERN.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WaywardLanternBlockEntity te) {
        block9: {
            block8: {
                DIWorldData data;
                if (!te.finishedRequests.isEmpty()) {
                    data = DIWorldData.get(level);
                    te.workingRequests.removeIf(lanternRequest -> te.finishedRequests.contains(lanternRequest.getPetUUID()));
                    for (UUID uuid : te.finishedRequests) {
                        data.removeMatchingLanternRequests(uuid);
                    }
                    te.finishedRequests.clear();
                }
                if (!te.workingRequests.isEmpty()) break block8;
                if (te.checkAgainIn > 0) {
                    --te.checkAgainIn;
                } else {
                    te.checkAgainIn = 200 + level.f_46441_.m_188503_(400);
                    data = DIWorldData.get(level);
                    for (Player player : WaywardLanternBlockEntity.getPlayers(level, pos)) {
                        te.workingRequests.addAll(data.getLanternRequestsFor(player.m_20148_()));
                    }
                }
                break block9;
            }
            if (!(level instanceof ServerLevel)) break block9;
            ServerLevel serverLevel = (ServerLevel)level;
            for (LanternRequest request : te.workingRequests) {
                WaywardLanternBlockEntity.loadChunksAround(serverLevel, request.getPetUUID(), request.getChunkPosition(), true);
                Entity entityFromChunk = serverLevel.m_8791_(request.getPetUUID());
                ++te.entityLoadTimeout;
                if (entityFromChunk == null && te.entityLoadTimeout <= 200) continue;
                te.entityLoadTimeout = 0;
                if (entityFromChunk != null) {
                    BlockPos putAt = WaywardLanternBlockEntity.getPlaceFor(entityFromChunk, pos, level.f_46441_);
                    entityFromChunk.m_6021_((double)((float)putAt.m_123341_() + 0.5f), (double)putAt.m_123342_(), (double)((float)putAt.m_123343_() + 0.5f));
                    Entity owner = TameableUtils.getOwnerOf(entityFromChunk);
                    if (owner instanceof Player) {
                        ((Player)owner).m_5661_((Component)Component.m_237110_((String)"message.domesticationinnovation.wayward_lantern_return", (Object[])new Object[]{entityFromChunk.m_7755_()}), false);
                    }
                    te.finishedRequests.add(request.getPetUUID());
                }
                WaywardLanternBlockEntity.loadChunksAround(serverLevel, request.getPetUUID(), request.getChunkPosition(), false);
            }
        }
    }

    private static void loadChunksAround(ServerLevel serverLevel, UUID ticket, BlockPos center, boolean load) {
        ChunkPos chunkPos = new ChunkPos(center);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"domesticationinnovation", (UUID)ticket, (int)(chunkPos.f_45578_ + i), (int)(chunkPos.f_45579_ + j), (boolean)load, (boolean)true);
            }
        }
    }

    private static List<Player> getPlayers(Level level, BlockPos pos) {
        double dist = 4096.0;
        ArrayList<Player> withinDist = new ArrayList<Player>();
        for (Player player : level.m_6907_()) {
            if (!(player.m_20238_(Vec3.m_82512_((Vec3i)pos)) < dist)) continue;
            withinDist.add(player);
        }
        return withinDist;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("CheckAgainIn")) {
            this.checkAgainIn = tag.m_128451_("CheckAgainIn");
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("CheckAgainIn", this.checkAgainIn);
    }

    private static BlockPos getPlaceFor(Entity entity, BlockPos lanternPos, RandomSource random) {
        int maxDist = (int)Math.max(entity.m_20205_() + 1.0f, 10.0f);
        for (int i = 0; i < 10; ++i) {
            BlockPos at = lanternPos.m_7918_(random.m_188503_(maxDist) - maxDist / 2, 1, random.m_188503_(maxDist) - maxDist / 2);
            while (entity.f_19853_.m_8055_(at).m_60795_() && at.m_123342_() > entity.f_19853_.m_141937_() && entity.f_19853_.m_45772_(entity.m_6095_().m_20585_((double)((float)at.m_123341_() + 0.5f), (double)(at.m_123342_() - 1), (double)((float)at.m_123343_() + 0.5f)))) {
                at = at.m_7495_();
            }
            if (entity.f_19853_.m_45772_(entity.m_6095_().m_20585_((double)((float)at.m_123341_() + 0.5f), (double)at.m_123342_(), (double)((float)at.m_123343_() + 0.5f)))) {
                return at;
            }
            if (!entity.m_5830_()) continue;
            return lanternPos.m_7494_();
        }
        return lanternPos.m_7494_();
    }
}

