/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.mixin;

import com.github.alexthe666.citadel.server.entity.IComandableMob;
import com.github.alexthe668.domesticationinnovation.DomesticationMod;
import com.github.alexthe668.domesticationinnovation.server.entity.ModifedToBeTameable;
import com.github.alexthe668.domesticationinnovation.server.entity.TameableUtils;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Axolotl.class})
public abstract class AxolotlMixin
extends Animal
implements ModifedToBeTameable,
IComandableMob {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(Axolotl.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(Axolotl.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.m_135353_(Axolotl.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    @Shadow
    public abstract void m_7378_(CompoundTag var1);

    protected AxolotlMixin(EntityType<? extends Animal> type, Level lvl) {
        super(type, lvl);
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/axolotl/Axolotl;defineSynchedData()V"})
    private void di_registerData(CallbackInfo ci) {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(COMMAND, (Object)0);
        this.f_19804_.m_135372_(TAMED, (Object)false);
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/axolotl/Axolotl;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void di_writeAdditional(CompoundTag compoundNBT, CallbackInfo ci) {
        compoundNBT.m_128405_("DICommand", this.getCommand());
        compoundNBT.m_128379_("Tamed", this.isTame());
        if (this.getTameOwnerUUID() != null) {
            compoundNBT.m_128362_("Owner", this.getTameOwnerUUID());
        }
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/axolotl/Axolotl;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void di_readAdditional(CompoundTag compoundNBT, CallbackInfo ci) {
        UUID uuid;
        this.setCommand(compoundNBT.m_128451_("DICommand"));
        this.setTame(compoundNBT.m_128471_("Tamed"));
        if (compoundNBT.m_128403_("Owner")) {
            uuid = compoundNBT.m_128342_("Owner");
        } else {
            String s = compoundNBT.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setTameOwnerUUID(uuid);
                this.setTame(true);
            }
            catch (Throwable throwable) {
                this.setTame(false);
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/axolotl/Axolotl;saveToBucketTag(Lnet/minecraft/world/item/ItemStack;)V"})
    private void di_writeAdditionalBucket(ItemStack stack, CallbackInfo ci) {
        CompoundTag compoundNBT = stack.m_41784_();
        this.m_7380_(compoundNBT);
        compoundNBT.m_128405_("DICommand", this.getCommand());
        compoundNBT.m_128379_("Tamed", this.isTame());
        if (this.getTameOwnerUUID() != null) {
            compoundNBT.m_128362_("Owner", this.getTameOwnerUUID());
        }
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/axolotl/Axolotl;loadFromBucketTag(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void di_readAdditionalBucket(CompoundTag compoundNBT, CallbackInfo ci) {
        UUID uuid;
        this.m_7378_(compoundNBT);
        this.setCommand(compoundNBT.m_128451_("DICommand"));
        this.setTame(compoundNBT.m_128471_("Tamed"));
        if (compoundNBT.m_128403_("Owner")) {
            uuid = compoundNBT.m_128342_("Owner");
        } else {
            String s = compoundNBT.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setTameOwnerUUID(uuid);
                this.setTame(true);
            }
            catch (Throwable throwable) {
                this.setTame(false);
            }
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/animal/axolotl/Axolotl;mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, remap=true, at={@At(value="HEAD")}, cancellable=true)
    private void di_onInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (((Boolean)DomesticationMod.CONFIG.tameableAxolotl.get()).booleanValue()) {
            ItemStack itemStack = player.m_21120_(hand);
            if (!this.isTame() && this.isFish(itemStack)) {
                this.m_142075_(player, hand, itemStack);
                this.m_5634_(2.0f);
                this.m_5496_(SoundEvents.f_11788_, this.m_6121_(), this.m_6100_());
                if (!this.f_19853_.f_46443_) {
                    if (this.m_217043_().m_188503_(4) == 0) {
                        this.spawnTamingParticles(true);
                    } else {
                        this.spawnTamingParticles(false);
                        this.setTame(true);
                        this.setTameOwnerUUID(player.m_20148_());
                        if (player instanceof ServerPlayer) {
                            CriteriaTriggers.f_10590_.m_68829_((ServerPlayer)player, (Animal)this);
                        }
                    }
                }
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            } else if (this.isTame() && itemStack.m_41720_() != Items.f_42447_) {
                if (this.isFish(itemStack) && this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(2.0f);
                    this.m_5496_(SoundEvents.f_11788_, this.m_6121_(), this.m_6100_());
                    cir.setReturnValue((Object)InteractionResult.SUCCESS);
                } else if (super.m_6071_(player, hand) == InteractionResult.PASS && ((Boolean)DomesticationMod.CONFIG.trinaryCommandSystem.get()).booleanValue()) {
                    player.m_21011_(hand, true);
                    cir.setReturnValue((Object)this.playerSetCommand(player, this));
                }
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/axolotl/Axolotl;customServerAiStep()V"})
    private void di_customServerAiStep(CallbackInfo ci) {
        if (this.isTame() && this.getTameOwner() != null) {
            if (this.getTameOwner().m_21214_() != null && this.getTameOwner().m_21214_().m_6084_() && !TameableUtils.hasSameOwnerAs((LivingEntity)this, (Entity)this.getTameOwner().m_21214_())) {
                this.m_6710_(this.getTameOwner().m_21214_());
            }
            if (this.getTameOwner().m_21188_() != null && this.getTameOwner().m_21188_().m_6084_() && !TameableUtils.hasSameOwnerAs((LivingEntity)this, (Entity)this.getTameOwner().m_21188_())) {
                this.m_6710_(this.getTameOwner().m_21188_());
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, remap=true, method={"Lnet/minecraft/world/entity/animal/axolotl/Axolotl;removeWhenFarAway(D)Z"}, cancellable=true)
    private void di_removeWhenFarAway(double dist, CallbackInfoReturnable<Boolean> cir) {
        if (this.isTame()) {
            cir.setReturnValue((Object)false);
        }
    }

    private void spawnTamingParticles(boolean smoke) {
        if (!this.f_19853_.f_46443_) {
            SimpleParticleType particleoptions = smoke ? ParticleTypes.f_123762_ : ParticleTypes.f_123750_;
            for (int i = 0; i < 7; ++i) {
                double d0 = this.m_217043_().m_188583_() * 0.02;
                double d1 = this.m_217043_().m_188583_() * 0.02;
                double d2 = this.m_217043_().m_188583_() * 0.02;
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 3, d0, d1, d2, (double)0.03f);
            }
        }
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public void setCommand(int i) {
        this.f_19804_.m_135381_(COMMAND, (Object)i);
    }

    @Override
    public boolean isTame() {
        return (Boolean)this.f_19804_.m_135370_(TAMED);
    }

    @Override
    public void setTame(boolean b) {
        this.f_19804_.m_135381_(TAMED, (Object)b);
    }

    private boolean isFish(ItemStack stack) {
        return this.m_6898_(stack) || stack.m_41720_() == Items.f_42528_;
    }

    @Override
    @Nullable
    public UUID getTameOwnerUUID() {
        return (Boolean)DomesticationMod.CONFIG.tameableAxolotl.get() != false ? ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null) : null;
    }

    @Override
    public void setTameOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }

    @Override
    @Nullable
    public LivingEntity getTameOwner() {
        try {
            UUID uuid = this.getTameOwnerUUID();
            return uuid == null ? null : this.f_19853_.m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Override
    public boolean isFollowingOwner() {
        return this.getCommand() == 2 && (Boolean)DomesticationMod.CONFIG.trinaryCommandSystem.get() != false;
    }

    @Override
    public boolean isStayingStill() {
        return this.getCommand() == 1 && (Boolean)DomesticationMod.CONFIG.trinaryCommandSystem.get() != false;
    }

    @Override
    public boolean isValidAttackTarget(LivingEntity target) {
        if (this.m_7307_((Entity)target)) {
            return false;
        }
        if (this.getTameOwner() != null && this.getTameOwner().m_21214_() != null && this.getTameOwner().m_21214_().equals((Object)target)) {
            return !TameableUtils.hasSameOwnerAs((LivingEntity)this, (Entity)target) && !this.m_7307_((Entity)target);
        }
        if (this.getTameOwner() != null && this.getTameOwner().m_21188_() != null && this.getTameOwner().m_21188_().equals((Object)target)) {
            return !TameableUtils.hasSameOwnerAs((LivingEntity)this, (Entity)target) && !this.m_7307_((Entity)target);
        }
        return false;
    }

    public void sendCommandMessage(Player owner, int command, Component name) {
        owner.m_5661_((Component)Component.m_237110_((String)("message.domesticationinnovation.command_" + command), (Object[])new Object[]{name}), true);
    }
}

