/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.videosurface;

import com.sun.jna.Pointer;
import uk.co.caprica.vlcj.binding.internal.ReportSizeChanged;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_color_primaries_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_color_space_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_getProcAddress_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_makeCurrent_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_orient_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_output_cfg_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_output_cleanup_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_output_set_resize_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_output_setup_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_render_cfg_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_setup_device_cfg_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_setup_device_info_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_swap_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_transfer_func_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_update_output_cb;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.videoengine.VideoEngine;
import uk.co.caprica.vlcj.player.embedded.videosurface.videoengine.VideoEngineCallback;

public final class VideoEngineVideoSurface
extends VideoSurface {
    private static final int GL_RGBA = 6408;
    private final VideoEngine engine;
    private final VideoEngineCallback callback;
    private final libvlc_video_output_setup_cb setup = new SetupCallback();
    private final libvlc_video_output_cleanup_cb cleanup = new CleanupCallback();
    private final libvlc_video_output_set_resize_cb setResize = new SetResizeCallback();
    private final libvlc_video_update_output_cb updateOutput = new UpdateOutputCallback();
    private final libvlc_video_swap_cb swap = new SwapCallback();
    private final libvlc_video_makeCurrent_cb makeCurrent = new MakeCurrentCallback();
    private final libvlc_video_getProcAddress_cb getProcAddress = new GetProcAddressCallback();

    public VideoEngineVideoSurface(VideoEngine engine, VideoEngineCallback callback, VideoSurfaceAdapter videoSurfaceAdapter) {
        super(videoSurfaceAdapter);
        this.engine = engine;
        this.callback = callback;
    }

    @Override
    public void attach(MediaPlayer mediaPlayer) {
        LibVlc.libvlc_video_set_output_callbacks(mediaPlayer.mediaPlayerInstance(), this.engine.intValue(), this.setup, this.cleanup, this.setResize, this.updateOutput, this.swap, this.makeCurrent, this.getProcAddress, null, null, null);
    }

    private final class SetupCallback
    implements libvlc_video_output_setup_cb {
        private SetupCallback() {
        }

        @Override
        public int setup(Pointer opaque, libvlc_video_setup_device_cfg_t cfg, libvlc_video_setup_device_info_t out) {
            return VideoEngineVideoSurface.this.callback.onSetup(opaque, cfg, out) ? 1 : 0;
        }
    }

    private final class CleanupCallback
    implements libvlc_video_output_cleanup_cb {
        private CleanupCallback() {
        }

        @Override
        public void cleanup(Pointer opaque) {
            VideoEngineVideoSurface.this.callback.onCleanup(opaque);
        }
    }

    private final class SetResizeCallback
    implements libvlc_video_output_set_resize_cb {
        private SetResizeCallback() {
        }

        @Override
        public void setResizeCallback(Pointer opaque, ReportSizeChanged report_size_change, Pointer report_opaque) {
            VideoEngineVideoSurface.this.callback.onSetResizeCallback(opaque, report_size_change, report_opaque);
        }
    }

    private class UpdateOutputCallback
    implements libvlc_video_update_output_cb {
        private UpdateOutputCallback() {
        }

        @Override
        public int updateOutput(Pointer opaque, libvlc_video_render_cfg_t cfg, libvlc_video_output_cfg_t output) {
            output.u.writeField("opengl_format", 6408);
            output.full_range = 1;
            output.colorspace = libvlc_video_color_space_e.libvlc_video_colorspace_BT709.intValue();
            output.primaries = libvlc_video_color_primaries_e.libvlc_video_primaries_BT709.intValue();
            output.transfer = libvlc_video_transfer_func_e.libvlc_video_transfer_func_SRGB.intValue();
            output.orientation = libvlc_video_orient_t.libvlc_video_orient_top_left.intValue();
            return VideoEngineVideoSurface.this.callback.onUpdateOutput(opaque, cfg, output) ? 1 : 0;
        }
    }

    private class SwapCallback
    implements libvlc_video_swap_cb {
        private SwapCallback() {
        }

        @Override
        public void swap(Pointer opaque) {
            VideoEngineVideoSurface.this.callback.onSwap(opaque);
        }
    }

    private class MakeCurrentCallback
    implements libvlc_video_makeCurrent_cb {
        private MakeCurrentCallback() {
        }

        @Override
        public int makeCurrent(Pointer opaque, int enter) {
            return VideoEngineVideoSurface.this.callback.onMakeCurrent(opaque, enter != 0) ? 1 : 0;
        }
    }

    private class GetProcAddressCallback
    implements libvlc_video_getProcAddress_cb {
        private GetProcAddressCallback() {
        }

        @Override
        public Pointer getProcAddress(Pointer opaque, String fct_name) {
            return Pointer.createConstant((long)VideoEngineVideoSurface.this.callback.onGetProcAddress(opaque, fct_name));
        }
    }
}

