/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.component.callback;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import uk.co.caprica.vlcj.player.base.VideoTrack;
import uk.co.caprica.vlcj.player.component.callback.BaseCallbackImagePainter;

public class ScaledCallbackImagePainter
extends BaseCallbackImagePainter {
    private volatile Dimension renderSize;

    @Override
    public void videoTrackChanged(VideoTrack videoTrack) {
        this.renderSize = videoTrack != null ? new Dimension(videoTrack.width(), videoTrack.height()) : null;
    }

    @Override
    public void prepare(Graphics2D g2, JComponent component) {
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    @Override
    public void paint(Graphics2D g2, JComponent component, BufferedImage image) {
        int width = component.getWidth();
        int height = component.getHeight();
        g2.setColor(component.getBackground());
        g2.fillRect(0, 0, width, height);
        if (image != null) {
            int imageWidth = this.renderSize != null ? this.renderSize.width : image.getWidth();
            int imageHeight = this.renderSize != null ? this.renderSize.height : image.getHeight();
            float sx = (float)width / (float)imageWidth;
            float sy = (float)height / (float)imageHeight;
            float sf = Math.min(sx, sy);
            float scaledW = (float)imageWidth * sf;
            float scaledH = (float)imageHeight * sf;
            g2.translate(((float)width - scaledW) / 2.0f, ((float)height - scaledH) / 2.0f);
            if ((double)sf != 1.0) {
                g2.scale(sf, sf);
            }
            g2.drawImage(image, null, 0, 0);
        }
    }
}

