/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import com.sun.jna.ptr.IntByReference;
import java.awt.Dimension;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_adjust_option_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_viewpoint_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.DeinterlaceMode;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.Position;
import uk.co.caprica.vlcj.player.base.Viewpoint;

public final class VideoApi
extends BaseApi {
    VideoApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public void setDeinterlace(int deinterlace, DeinterlaceMode deinterlaceMode) {
        LibVlc.libvlc_video_set_deinterlace(this.mediaPlayerInstance, deinterlace, deinterlaceMode != null ? deinterlaceMode.stringValue() : null);
    }

    public void setAdjustVideo(boolean adjustVideo) {
        LibVlc.libvlc_video_set_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Enable.intValue(), adjustVideo ? 1 : 0);
    }

    public boolean isAdjustVideo() {
        return LibVlc.libvlc_video_get_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Enable.intValue()) == 1;
    }

    public float contrast() {
        return LibVlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Contrast.intValue());
    }

    public void setContrast(float contrast) {
        LibVlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Contrast.intValue(), contrast);
    }

    public float brightness() {
        return LibVlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Brightness.intValue());
    }

    public void setBrightness(float brightness) {
        LibVlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Brightness.intValue(), brightness);
    }

    public float hue() {
        return LibVlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Hue.intValue());
    }

    public void setHue(float hue) {
        LibVlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Hue.intValue(), hue);
    }

    public float saturation() {
        return LibVlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Saturation.intValue());
    }

    public void setSaturation(float saturation) {
        LibVlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Saturation.intValue(), saturation);
    }

    public float gamma() {
        return LibVlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Gamma.intValue());
    }

    public void setGamma(float gamma) {
        LibVlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Gamma.intValue(), gamma);
    }

    public void setVideoTitleDisplay(Position position, int timeout) {
        LibVlc.libvlc_media_player_set_video_title_display(this.mediaPlayerInstance, position.intValue(), timeout);
    }

    public void setAspectRatio(String aspectRatio) {
        LibVlc.libvlc_video_set_aspect_ratio(this.mediaPlayerInstance, aspectRatio);
    }

    public float scale() {
        return LibVlc.libvlc_video_get_scale(this.mediaPlayerInstance);
    }

    public void setScale(float factor) {
        LibVlc.libvlc_video_set_scale(this.mediaPlayerInstance, factor);
    }

    public void setCropRatio(int num, int den) {
        LibVlc.libvlc_video_set_crop_ratio(this.mediaPlayerInstance, num, den);
    }

    public void setCropWindow(int x, int y, int width, int height) {
        if (width == 0 || height == 0) {
            throw new IllegalArgumentException("Width and height must be non-zero");
        }
        LibVlc.libvlc_video_set_crop_window(this.mediaPlayerInstance, x, y, width, height);
    }

    public void setCropBorder(int left, int top, int right, int bottom) {
        LibVlc.libvlc_video_set_crop_border(this.mediaPlayerInstance, left, right, top, bottom);
    }

    public Dimension videoDimension() {
        IntByReference px = new IntByReference();
        IntByReference py = new IntByReference();
        int result = LibVlc.libvlc_video_get_size(this.mediaPlayerInstance, 0, px, py);
        if (result == 0) {
            return new Dimension(px.getValue(), py.getValue());
        }
        return null;
    }

    public Viewpoint newViewpoint() {
        libvlc_video_viewpoint_t viewpoint = LibVlc.libvlc_video_new_viewpoint();
        if (viewpoint != null) {
            return new Viewpoint(viewpoint);
        }
        return null;
    }

    public boolean updateViewpoint(Viewpoint viewpoint, boolean absolute) {
        return LibVlc.libvlc_video_update_viewpoint(this.mediaPlayerInstance, viewpoint.viewpoint(), absolute ? 1 : 0) == 0;
    }
}

