/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_track_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_tracklist_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.types.size_t;
import uk.co.caprica.vlcj.player.base.Track;

public abstract class TrackList<T extends Track> {
    private final libvlc_media_tracklist_t instance;
    private final List<T> tracks;

    TrackList(libvlc_media_tracklist_t instance) {
        this.instance = instance;
        this.tracks = this.initTracks();
    }

    public final List<T> tracks() {
        return this.tracks;
    }

    public final void release() {
        LibVlc.libvlc_media_tracklist_delete(this.instance);
    }

    private List<T> initTracks() {
        int trackCount = LibVlc.libvlc_media_tracklist_count(this.instance).intValue();
        ArrayList<T> tracks = new ArrayList<T>(trackCount);
        for (int i = 0; i < trackCount; ++i) {
            libvlc_media_track_t track = LibVlc.libvlc_media_tracklist_at(this.instance, new size_t(i));
            tracks.add(this.initTrack(track));
        }
        return Collections.unmodifiableList(tracks);
    }

    protected abstract T initTrack(libvlc_media_track_t var1);

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(super.toString()).append('[');
        sb.append("tracks=").append(this.tracks).append(']');
        return sb.toString();
    }
}

