/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_track_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_tracklist_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.types.size_t;
import uk.co.caprica.vlcj.media.TrackType;
import uk.co.caprica.vlcj.player.base.AudioTrack;
import uk.co.caprica.vlcj.player.base.AudioTrackList;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.TextTrack;
import uk.co.caprica.vlcj.player.base.TextTrackList;
import uk.co.caprica.vlcj.player.base.Track;
import uk.co.caprica.vlcj.player.base.VideoTrack;
import uk.co.caprica.vlcj.player.base.VideoTrackList;

public final class TrackApi
extends BaseApi {
    TrackApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public VideoTrackList videoTracks() {
        return this.videoTracks(false);
    }

    public VideoTrackList videoTracks(boolean selected) {
        libvlc_media_tracklist_t trackList = LibVlc.libvlc_media_player_get_tracklist(this.mediaPlayerInstance, TrackType.VIDEO.intValue(), selected ? 1 : 0);
        if (trackList != null) {
            return new VideoTrackList(trackList);
        }
        return null;
    }

    public AudioTrackList audioTracks() {
        return this.audioTracks(false);
    }

    public AudioTrackList audioTracks(boolean selected) {
        libvlc_media_tracklist_t trackList = LibVlc.libvlc_media_player_get_tracklist(this.mediaPlayerInstance, TrackType.AUDIO.intValue(), selected ? 1 : 0);
        if (trackList != null) {
            return new AudioTrackList(trackList);
        }
        return null;
    }

    public TextTrackList textTracks() {
        return this.textTracks(false);
    }

    public TextTrackList textTracks(boolean selected) {
        libvlc_media_tracklist_t trackList = LibVlc.libvlc_media_player_get_tracklist(this.mediaPlayerInstance, TrackType.TEXT.intValue(), selected ? 1 : 0);
        if (trackList != null) {
            return new TextTrackList(trackList);
        }
        return null;
    }

    public VideoTrack selectedVideoTrack() {
        libvlc_media_track_t track = LibVlc.libvlc_media_player_get_selected_track(this.mediaPlayerInstance, TrackType.VIDEO.intValue());
        if (track != null) {
            return new VideoTrack(track);
        }
        return null;
    }

    public AudioTrack selectedAudioTrack() {
        libvlc_media_track_t track = LibVlc.libvlc_media_player_get_selected_track(this.mediaPlayerInstance, TrackType.AUDIO.intValue());
        if (track != null) {
            return new AudioTrack(track);
        }
        return null;
    }

    public TextTrack selectedTextTrack() {
        libvlc_media_track_t track = LibVlc.libvlc_media_player_get_selected_track(this.mediaPlayerInstance, TrackType.TEXT.intValue());
        if (track != null) {
            return new TextTrack(track);
        }
        return null;
    }

    public Track track(String trackId) {
        libvlc_media_track_t track = LibVlc.libvlc_media_player_get_track_from_id(this.mediaPlayerInstance, trackId);
        if (track != null) {
            switch (TrackType.trackType(track.i_type)) {
                case AUDIO: {
                    return new AudioTrack(track);
                }
                case VIDEO: {
                    return new VideoTrack(track);
                }
                case TEXT: {
                    return new TextTrack(track);
                }
            }
        }
        return null;
    }

    public void selectTrack(Track track) {
        LibVlc.libvlc_media_player_select_track(this.mediaPlayerInstance, track.instance());
    }

    public <T extends Track> void select(T ... tracks) {
        if (tracks != null && tracks.length > 0) {
            this.select(TrackType.AUDIO, (Track[])tracks);
            this.select(TrackType.VIDEO, (Track[])tracks);
            this.select(TrackType.TEXT, (Track[])tracks);
        }
    }

    public <T extends Track> void select(List<T> tracks) {
        this.select(tracks.toArray(new Track[0]));
    }

    public void select(TrackType type, String ... trackIds) {
        if (trackIds != null && trackIds.length > 0) {
            LibVlc.libvlc_media_player_select_tracks_by_ids(this.mediaPlayerInstance, type.intValue(), String.join((CharSequence)",", trackIds));
        }
    }

    public void select(TrackType type, List<String> trackIds) {
        this.select(type, trackIds.toArray(new String[0]));
    }

    public void deselect(TrackType ... types) {
        if (types != null && types.length > 0) {
            for (TrackType type : types) {
                LibVlc.libvlc_media_player_unselect_track_type(this.mediaPlayerInstance, type.intValue());
            }
        }
    }

    public void deselect(List<TrackType> types) {
        this.deselect(types.toArray(new TrackType[0]));
    }

    private void select(TrackType type, Track[] tracks) {
        ArrayList<libvlc_media_track_t> list = new ArrayList<libvlc_media_track_t>(tracks.length);
        for (int i = 0; i < tracks.length; ++i) {
            Track track = tracks[i];
            if (track.trackType() != type) continue;
            list.add(track.instance());
        }
        if (!list.isEmpty()) {
            LibVlc.libvlc_media_player_select_tracks(this.mediaPlayerInstance, type.intValue(), (Pointer)TrackApi.getPointerArray(tracks), new size_t(list.size()));
        }
    }

    private static Memory getPointerArray(Track[] tracks) {
        int count = tracks.length;
        Memory memory = new Memory((long)(Native.POINTER_SIZE * count));
        Pointer[] pointers = new Pointer[count];
        for (int i = 0; i < count; ++i) {
            pointers[i] = tracks[i].instance().getPointer();
        }
        memory.write(0L, pointers, 0, pointers.length);
        return memory;
    }
}

