/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.LongByReference;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_time_point_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_watch_time_on_discontinuity;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_watch_time_on_update;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.TimePoint;
import uk.co.caprica.vlcj.player.base.WatchTimeListener;

public final class TimeApi
extends BaseApi {
    private static final long VLC_CLOCK_FREQ = 1000000L;
    private static final long VLC_TICK_INVALID = 0L;
    private WatchTimeListener watchTimeListener;
    private final libvlc_media_player_watch_time_on_update onUpdateCallback = new libvlc_media_player_watch_time_on_update(){

        @Override
        public void callback(libvlc_media_player_time_point_t value, Pointer data) {
            TimePoint timePoint = new TimePoint(value.rate, value.length_us, value.system_date_us, value.ts_us, value.position);
            TimeApi.this.watchTimeListener.watchTimeUpdate(TimeApi.this.mediaPlayer, timePoint, TimeApi.fromPointer(data));
        }
    };
    private final libvlc_media_player_watch_time_on_discontinuity onDiscontinuityCallback = new libvlc_media_player_watch_time_on_discontinuity(){

        @Override
        public void callback(long system_date_us, Pointer data) {
            TimeApi.this.watchTimeListener.watchTimeDiscontinuity(TimeApi.this.mediaPlayer, system_date_us, TimeApi.fromPointer(data));
        }
    };

    TimeApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public boolean watchTime(long minimumPeriodBetweenUpdates, Long data, WatchTimeListener listener) {
        this.watchTimeListener = listener;
        return 0 == LibVlc.libvlc_media_player_watch_time(this.mediaPlayerInstance, minimumPeriodBetweenUpdates, this.onUpdateCallback, this.onDiscontinuityCallback, TimeApi.toPointer(data));
    }

    public void unwatchTime() {
        LibVlc.libvlc_media_player_unwatch_time(this.mediaPlayerInstance);
        this.watchTimeListener = null;
    }

    public boolean interpolate(TimePoint timePoint) {
        boolean result;
        LongByReference out_ts = new LongByReference();
        DoubleByReference out_pos = new DoubleByReference();
        boolean bl = result = LibVlc.libvlc_media_player_time_point_interpolate(TimeApi.toInstance(timePoint), LibVlc.libvlc_clock(), out_ts, out_pos) == 0;
        if (result) {
            timePoint.update(out_ts.getValue(), out_pos.getValue());
        }
        return result;
    }

    public long nextInterval(int seconds) {
        return 1000000L * (long)seconds;
    }

    public boolean isValidTime(long value) {
        return value != 0L;
    }

    public long nextAbsoluteTimestamp(TimePoint timePoint, long interpolatedTimestamp, long nextInterval) {
        return LibVlc.libvlc_media_player_time_point_get_next_date(TimeApi.toInstance(timePoint), LibVlc.libvlc_clock(), interpolatedTimestamp, nextInterval);
    }

    public long nextRelativeTimestamp(TimePoint timePoint, long interpolatedTimestamp, long nextInterval) {
        return this.nextAbsoluteTimestamp(timePoint, interpolatedTimestamp, nextInterval) - LibVlc.libvlc_clock();
    }

    @Override
    protected void release() {
        if (this.watchTimeListener != null) {
            this.unwatchTime();
        }
    }

    private static Pointer toPointer(Long value) {
        return value != null ? Pointer.createConstant((long)value) : null;
    }

    private static Long fromPointer(Pointer pointer) {
        return Pointer.nativeValue((Pointer)pointer);
    }

    private static libvlc_media_player_time_point_t toInstance(TimePoint timePoint) {
        libvlc_media_player_time_point_t result = (libvlc_media_player_time_point_t)Structure.newInstance(libvlc_media_player_time_point_t.class);
        result.setAutoWrite(false);
        result.position = timePoint.position();
        result.rate = timePoint.rate();
        result.ts_us = timePoint.timestamp();
        result.length_us = timePoint.length();
        result.system_date_us = timePoint.systemDate();
        result.write();
        return result;
    }
}

