/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.MediaPlayerEventAdapter;

final class MediaPlayerPlayLatch {
    private final MediaPlayer mediaPlayer;

    MediaPlayerPlayLatch(MediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean play() {
        CountDownLatch latch = new CountDownLatch(1);
        LatchListener listener = new LatchListener(latch);
        this.mediaPlayer.events().addMediaPlayerEventListener(listener);
        try {
            boolean playing = this.mediaPlayer.controls().play();
            if (playing) {
                latch.await();
                boolean bl = listener.playing.get();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.mediaPlayer.events().removeMediaPlayerEventListener(listener);
        }
    }

    private static final class LatchListener
    extends MediaPlayerEventAdapter {
        private final CountDownLatch latch;
        private final AtomicBoolean playing = new AtomicBoolean();

        private LatchListener(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void playing(MediaPlayer mediaPlayer) {
            this.playing.set(true);
            this.latch.countDown();
        }

        @Override
        public void error(MediaPlayer mediaPlayer) {
            this.playing.set(false);
            this.latch.countDown();
        }
    }
}

