/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.co.caprica.vlcj.player.base.EqualizerListener;

public final class Equalizer {
    private final int bandCount;
    private final List<EqualizerListener> listeners = new ArrayList<EqualizerListener>();
    private float preamp;
    private final float[] bandAmps;

    public Equalizer(int bandCount) {
        this.bandCount = bandCount;
        this.bandAmps = new float[bandCount];
    }

    public void addEqualizerListener(EqualizerListener listener) {
        this.listeners.add(listener);
    }

    public void removeEqualizerListener(EqualizerListener listener) {
        this.listeners.remove(listener);
    }

    public int bandCount() {
        return this.bandCount;
    }

    public float preamp() {
        return this.preamp;
    }

    public void setPreamp(float newPreamp) {
        this.applyPreamp(newPreamp);
        this.fireEqualizerChanged();
    }

    public float amp(int index) {
        if (index >= 0 && index < this.bandCount) {
            return this.bandAmps[index];
        }
        throw new IllegalArgumentException("Invalid band index");
    }

    public void setAmp(int index, float newAmp) {
        this.checkAmp(newAmp);
        if (index < 0 || index >= this.bandCount) {
            throw new IllegalArgumentException("Invalid band index");
        }
        this.bandAmps[index] = newAmp;
        this.fireEqualizerChanged();
    }

    public float[] amps() {
        float[] result = new float[this.bandCount];
        this.copy(this.bandAmps, result);
        return result;
    }

    public void setAmps(float[] newAmps) {
        this.applyAmps(newAmps);
        this.fireEqualizerChanged();
    }

    public void setAmps(float newPreamp, float[] newAmps) {
        this.applyPreamp(newPreamp);
        this.applyAmps(newAmps);
        this.fireEqualizerChanged();
    }

    public void setEqualizer(Equalizer equalizer) {
        if (equalizer == null) {
            throw new IllegalArgumentException();
        }
        this.preamp = equalizer.preamp;
        this.copy(equalizer.bandAmps, this.bandAmps);
        this.fireEqualizerChanged();
    }

    public void reset() {
        this.preamp = 0.0f;
        for (int i = 0; i < this.bandCount; ++i) {
            this.bandAmps[i] = 0.0f;
        }
        this.fireEqualizerChanged();
    }

    private void applyPreamp(float newPreamp) {
        this.checkAmp(newPreamp);
        this.preamp = newPreamp;
    }

    private void applyAmps(float[] newAmps) {
        if (newAmps != null && newAmps.length == this.bandCount) {
            for (float newAmp : newAmps) {
                this.checkAmp(newAmp);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.copy(newAmps, this.bandAmps);
    }

    private void checkAmp(float amp) {
        if (amp < -20.0f || amp > 20.0f) {
            throw new IllegalArgumentException("Invalid amplification value: " + amp);
        }
    }

    private void copy(float[] from, float[] to) {
        System.arraycopy(from, 0, to, 0, this.bandCount);
    }

    private void fireEqualizerChanged() {
        for (EqualizerListener listener : this.listeners) {
            listener.equalizerChanged(this);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(40);
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("preamp=").append(this.preamp).append(',');
        sb.append("bandAmps=").append(Arrays.toString(this.bandAmps)).append(']');
        return sb.toString();
    }
}

