/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.internal.libvlc_chapter_description_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.strings.NativeString;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.ChapterDescription;
import uk.co.caprica.vlcj.player.base.MediaPlayer;

public final class ChapterApi
extends BaseApi {
    ChapterApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public int count() {
        return LibVlc.libvlc_media_player_get_chapter_count(this.mediaPlayerInstance);
    }

    public int chapter() {
        return LibVlc.libvlc_media_player_get_chapter(this.mediaPlayerInstance);
    }

    public void setChapter(int chapterNumber) {
        LibVlc.libvlc_media_player_set_chapter(this.mediaPlayerInstance, chapterNumber);
    }

    public void next() {
        LibVlc.libvlc_media_player_next_chapter(this.mediaPlayerInstance);
    }

    public void previous() {
        LibVlc.libvlc_media_player_previous_chapter(this.mediaPlayerInstance);
    }

    public List<ChapterDescription> descriptions(int title) {
        ArrayList<ChapterDescription> result;
        PointerByReference chapters = new PointerByReference();
        int chapterCount = LibVlc.libvlc_media_player_get_full_chapter_descriptions(this.mediaPlayerInstance, title, chapters);
        if (chapterCount != -1) {
            Pointer[] pointers;
            result = new ArrayList<ChapterDescription>(chapterCount);
            for (Pointer pointer : pointers = chapters.getValue().getPointerArray(0L, chapterCount)) {
                libvlc_chapter_description_t chapterDescription = (libvlc_chapter_description_t)Structure.newInstance(libvlc_chapter_description_t.class, (Pointer)pointer);
                chapterDescription.read();
                result.add(new ChapterDescription(chapterDescription.i_time_offset, chapterDescription.i_duration, NativeString.copyNativeString(chapterDescription.psz_name)));
            }
            LibVlc.libvlc_chapter_descriptions_release(chapters.getValue(), chapterCount);
        } else {
            result = new ArrayList(0);
        }
        return result;
    }

    public List<ChapterDescription> descriptions() {
        return this.descriptions(this.mediaPlayer.titles().title());
    }

    public List<List<ChapterDescription>> allDescriptions() {
        int titleCount = this.mediaPlayer.titles().titleCount();
        ArrayList<List<ChapterDescription>> result = new ArrayList<List<ChapterDescription>>(Math.max(titleCount, 0));
        for (int i = 0; i < titleCount; ++i) {
            result.add(this.descriptions(i));
        }
        return result;
    }
}

