/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.media;

public abstract class TrackInfo {
    private final int codec;
    private final String codecName;
    private final int originalCodec;
    private final String originalCodecName;
    private final int id;
    private final int profile;
    private final int level;
    private final int bitRate;
    private final String language;
    private final String description;
    private final String trackId;
    private final boolean stable;
    private final String name;
    private final boolean selected;
    private final String codecDescription;

    protected TrackInfo(int codec, int originalCodec, int id, int profile, int level, int bitRate, String language, String description, String trackId, boolean idStable, String name, boolean selected, String codecDescription) {
        this.codec = codec;
        this.codecName = this.codecName(codec);
        this.originalCodec = originalCodec;
        this.originalCodecName = this.codecName(originalCodec);
        this.id = id;
        this.profile = profile;
        this.level = level;
        this.bitRate = bitRate;
        this.language = language;
        this.description = description;
        this.trackId = trackId;
        this.stable = idStable;
        this.name = name;
        this.selected = selected;
        this.codecDescription = codecDescription;
    }

    public final int codec() {
        return this.codec;
    }

    public final String codecName() {
        return this.codecName;
    }

    public final int orignalCodec() {
        return this.codec;
    }

    public final String originalCodecName() {
        return this.originalCodecName;
    }

    public final int id() {
        return this.id;
    }

    public final int profile() {
        return this.profile;
    }

    public final int level() {
        return this.level;
    }

    public final int bitRate() {
        return this.bitRate;
    }

    public final String language() {
        return this.language;
    }

    public final String description() {
        return this.description;
    }

    public final String trackId() {
        return this.trackId;
    }

    public final boolean stable() {
        return this.stable;
    }

    public final String name() {
        return this.name;
    }

    public final boolean selected() {
        return this.selected;
    }

    public final String codecDescription() {
        return this.codecDescription;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("codec=0x").append(Integer.toHexString(this.codec)).append(',');
        sb.append("codecName=").append(this.codecName).append(',');
        sb.append("originalCodec=0x").append(Integer.toHexString(this.originalCodec)).append(',');
        sb.append("originalCodecName=").append(this.originalCodecName).append(',');
        sb.append("id=").append(this.id).append(',');
        sb.append("profile=").append(this.profile).append(',');
        sb.append("level=").append(this.level).append(',');
        sb.append("bitRate=").append(this.bitRate).append(',');
        sb.append("language=").append(this.language).append(',');
        sb.append("description=").append(this.description).append(',');
        sb.append("trackId=").append(this.trackId).append(',');
        sb.append("stable=").append(this.stable).append(',');
        sb.append("name=").append(this.name).append(',');
        sb.append("selected=").append(this.selected).append(',');
        sb.append("codecDescription=").append(this.codecDescription).append(']');
        return sb.toString();
    }

    private String codecName(int codec) {
        return codec != 0 ? new String(new byte[]{(byte)codec, (byte)(codec >>> 8), (byte)(codec >>> 16), (byte)(codec >>> 24)}).trim() : null;
    }
}

