/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.media;

import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.media.EventApi;
import uk.co.caprica.vlcj.media.InfoApi;
import uk.co.caprica.vlcj.media.MediaRef;
import uk.co.caprica.vlcj.media.MetaApi;
import uk.co.caprica.vlcj.media.OptionsApi;
import uk.co.caprica.vlcj.media.ParseApi;
import uk.co.caprica.vlcj.media.SlaveApi;
import uk.co.caprica.vlcj.media.StatsApi;
import uk.co.caprica.vlcj.media.SubitemApi;
import uk.co.caprica.vlcj.media.ThumbnailApi;
import uk.co.caprica.vlcj.media.TrackApi;

public final class Media {
    protected final libvlc_instance_t libvlcInstance;
    protected final libvlc_media_t mediaInstance;
    private final EventApi eventApi;
    private final InfoApi infoApi;
    private final MetaApi metaApi;
    private final OptionsApi optionsApi;
    private final ParseApi parseApi;
    private final SlaveApi slaveApi;
    private final StatsApi statsApi;
    private final SubitemApi subitemApi;
    private final ThumbnailApi thumbnailApi;
    private final TrackApi trackApi;

    public Media(libvlc_instance_t libvlcInstance, libvlc_media_t media) {
        this.libvlcInstance = libvlcInstance;
        this.mediaInstance = media;
        this.eventApi = new EventApi(this);
        this.infoApi = new InfoApi(this);
        this.metaApi = new MetaApi(this);
        this.optionsApi = new OptionsApi(this);
        this.parseApi = new ParseApi(this);
        this.slaveApi = new SlaveApi(this);
        this.statsApi = new StatsApi(this);
        this.subitemApi = new SubitemApi(this);
        this.thumbnailApi = new ThumbnailApi(this);
        this.trackApi = new TrackApi(this);
    }

    public EventApi events() {
        return this.eventApi;
    }

    public InfoApi info() {
        return this.infoApi;
    }

    public MetaApi meta() {
        return this.metaApi;
    }

    public OptionsApi options() {
        return this.optionsApi;
    }

    public ParseApi parsing() {
        return this.parseApi;
    }

    public SlaveApi slaves() {
        return this.slaveApi;
    }

    public StatsApi stats() {
        return this.statsApi;
    }

    public SubitemApi subitems() {
        return this.subitemApi;
    }

    public ThumbnailApi thumbnails() {
        return this.thumbnailApi;
    }

    public TrackApi tracks() {
        return this.trackApi;
    }

    public MediaRef newMediaRef() {
        LibVlc.libvlc_media_retain(this.mediaInstance);
        return new MediaRef(this.libvlcInstance, this.mediaInstance);
    }

    public Media newMedia() {
        LibVlc.libvlc_media_retain(this.mediaInstance);
        return new Media(this.libvlcInstance, this.mediaInstance);
    }

    public MediaRef duplicateMediaRef() {
        return new MediaRef(this.libvlcInstance, LibVlc.libvlc_media_duplicate(this.mediaInstance));
    }

    public Media duplicateMedia() {
        return new Media(this.libvlcInstance, LibVlc.libvlc_media_duplicate(this.mediaInstance));
    }

    public void release() {
        this.eventApi.release();
        this.infoApi.release();
        this.optionsApi.release();
        this.parseApi.release();
        this.metaApi.release();
        this.slaveApi.release();
        this.statsApi.release();
        this.subitemApi.release();
        this.thumbnailApi.release();
        this.trackApi.release();
        LibVlc.libvlc_media_release(this.mediaInstance);
    }

    public libvlc_media_t mediaInstance() {
        return this.mediaInstance;
    }
}

