/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.texture;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import team.creative.littleframes.client.texture.TextureSeeker;

public class TextureStorage {
    private File cacheDirectory;
    private File index;
    private Map<String, CacheEntry> entries;

    public TextureStorage() {
        this.cacheDirectory = new File(Minecraft.m_91087_().f_91069_, "littleframe_cache");
        this.index = new File(this.cacheDirectory, "index");
        this.entries = new HashMap<String, CacheEntry>();
        if (!this.cacheDirectory.exists()) {
            this.cacheDirectory.mkdirs();
        }
        this.loadIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String url, String etag, long time, long expireTime, byte[] data) {
        CacheEntry entry = new CacheEntry(url, etag, time, expireTime);
        boolean saved = false;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(entry.getFile());
            ((OutputStream)out).write(data);
            saved = true;
        }
        catch (IOException e) {
            try {
                TextureSeeker.LOGGER.error("Failed to save cache entry {}", (Object)e, (Object)url);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        IOUtils.closeQuietly((OutputStream)out);
        if (saved) {
            this.entries.put(url, entry);
            this.saveIndex();
        }
    }

    public CacheEntry getEntry(String url) {
        return this.entries.get(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIndex() {
        if (this.index.exists()) {
            Map<String, CacheEntry> previousEntries = this.entries;
            this.entries = new HashMap<String, CacheEntry>();
            DataInputStream in = null;
            try {
                in = new DataInputStream(new GZIPInputStream(new FileInputStream(this.index)));
                int length = in.readInt();
                for (int i = 0; i < length; ++i) {
                    String url = in.readUTF();
                    String etag = in.readUTF();
                    long time = in.readLong();
                    long expireTime = in.readLong();
                    CacheEntry entry = new CacheEntry(url, etag.length() > 0 ? etag : null, time, expireTime);
                    this.entries.put(entry.getUrl(), entry);
                }
            }
            catch (IOException e) {
                try {
                    TextureSeeker.LOGGER.error("Failed to load cache index", (Throwable)e);
                    this.entries = previousEntries;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
            }
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveIndex() {
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(this.index)));
            out.writeInt(this.entries.size());
            for (Map.Entry<String, CacheEntry> mapEntry : this.entries.entrySet()) {
                CacheEntry entry = mapEntry.getValue();
                out.writeUTF(entry.getUrl());
                out.writeUTF(entry.getEtag() == null ? "" : entry.getEtag());
                out.writeLong(entry.getTime());
                out.writeLong(entry.getExpireTime());
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            TextureSeeker.LOGGER.error("Failed to save cache index", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    public void deleteEntry(String url) {
        this.entries.remove(url);
        File file = TextureStorage.getFile(url);
        if (file.exists()) {
            file.delete();
        }
    }

    private static File getFile(String url) {
        return new File(TextureSeeker.TEXTURE_STORAGE.cacheDirectory, Base64.encodeBase64String((byte[])url.getBytes()));
    }

    public static class CacheEntry {
        private String url;
        private String etag;
        private long time;
        private long expireTime;

        public CacheEntry(String url, String etag, long time, long expireTime) {
            this.url = url;
            this.etag = etag;
            this.time = time;
            this.expireTime = expireTime;
        }

        public void setEtag(String etag) {
            this.etag = etag;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public void setExpireTime(long expireTime) {
            this.expireTime = expireTime;
        }

        public String getUrl() {
            return this.url;
        }

        public String getEtag() {
            return this.etag;
        }

        public long getTime() {
            return this.time;
        }

        public long getExpireTime() {
            return this.expireTime;
        }

        public File getFile() {
            return TextureStorage.getFile(this.url);
        }
    }
}

